/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.gadgets.ui;

import com.ibm.etools.webtools.gadgets.core.IGadgetsModelProperties;
import com.ibm.etools.webtools.gadgets.ui.Messages;
import com.ibm.etools.webtools.webpage.core.internal.util.ProjectFacetsUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;
import org.eclipse.wst.common.project.facet.ui.IFacetWizardPage;
import org.eclipse.wst.common.project.facet.ui.IWizardContext;
import org.eclipse.wst.web.ui.internal.wizards.DataModelFacetInstallPage;

public class NewWidgetWizardPage
extends DataModelFacetInstallPage
implements IFacetWizardPage,
IGadgetsModelProperties {
    protected Button fBrowseButton;

    public NewWidgetWizardPage() {
        super("enabler.widgets.facet.install.page");
        this.setTitle(Messages.NewWidgetWizardPage_create_widget);
        this.setDescription(Messages.NewWidgetWizardPage_create_widget_desc);
        this.model.addListener((IDataModelListener)this);
    }

    public NewWidgetWizardPage(IDataModel dataModel) {
        this();
        this.model = dataModel;
        this.model.addListener((IDataModelListener)this);
        this.synchHelper = this.initializeSynchHelper(this.model);
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        GridData gdhData = new GridData();
        Label textLabel = new Label(composite, 0);
        textLabel.setText(Messages.NewWidgetWizardPage_widget_name);
        Text text = new Text(composite, 2048);
        gdhData = NewWidgetWizardPage.gdhfill();
        gdhData.horizontalSpan = 2;
        text.setLayoutData((Object)gdhData);
        this.synchHelper.synchText(text, "WIDGET_NAME", null);
        text.selectAll();
        text.setFocus();
        Label folderLabel = new Label(composite, 0);
        folderLabel.setText(Messages.NewWidgetWizardPage_folder_name);
        Text folder = new Text(composite, 2048);
        gdhData = NewWidgetWizardPage.gdhfill();
        folder.setLayoutData((Object)gdhData);
        this.synchHelper.synchText(folder, "FOLDER", null);
        this.fBrowseButton = new Button(composite, 8);
        this.fBrowseButton.setText(Messages.NewWidgetWizardPage_browse);
        this.fBrowseButton.addListener(13, (Listener)this);
        Label templateLabel = new Label(composite, 0);
        templateLabel.setText(Messages.NewWidgetWizardPage_widget_template);
        Combo event = new Combo(composite, 8);
        gdhData = NewWidgetWizardPage.gdhfill();
        gdhData.horizontalSpan = 2;
        event.setLayoutData((Object)gdhData);
        this.synchHelper.synchCombo(event, "WIDGET_TYPE", null);
        Button chk2 = new Button(composite, 32);
        gdhData = NewWidgetWizardPage.gdhfill();
        gdhData.horizontalSpan = 3;
        chk2.setText(Messages.NewWidgetWizardPage_edit);
        chk2.setLayoutData((Object)gdhData);
        this.synchHelper.synchCheckbox(chk2, "EDIT_MODE", null);
        if (this.model.getBooleanProperty("INSTALL_WIDGET_FACET")) {
            Button chk3 = new Button(composite, 32);
            gdhData = NewWidgetWizardPage.gdhfill();
            gdhData.horizontalSpan = 3;
            chk3.setText(Messages.NewWidgetWizardPage_install_facet);
            chk3.setLayoutData((Object)gdhData);
            this.synchHelper.synchCheckbox(chk3, "INSTALL_WIDGET_FACET", null);
        }
        return composite;
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"WIDGET_NAME", "FOLDER"};
    }

    public void transferStateToConfig() {
    }

    public void setWizardContext(IWizardContext context) {
    }

    protected boolean showValidationErrorsOnEnter() {
        return true;
    }

    public void propertyChanged(DataModelEvent event) {
        String propertyName = event.getPropertyName();
        if ("IFacetDataModelProperties.FACET_PROJECT_NAME".equals(propertyName)) {
            this.model.notifyPropertyChange("WIDGET_NAME", 1);
        } else if ("FOLDER".equals(propertyName)) {
            this.model.notifyPropertyChange("WIDGET_NAME", 1);
        }
        super.propertyChanged(event);
    }

    public void handleEvent(Event event) {
        if (event.widget.equals(this.fBrowseButton)) {
            this.handleBrowseButtonPressed();
        }
        super.handleEvent(event);
    }

    public void handleBrowseButtonPressed() {
        ISelectionStatusValidator validator = this.getContainerDialogSelectionValidator();
        ViewerFilter filter = this.getContainerDialogViewerFilter();
        WorkbenchContentProvider contentProvider = new WorkbenchContentProvider();
        DecoratingLabelProvider labelProvider = new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
        dialog.setValidator(validator);
        dialog.setTitle(Messages.NewWidgetWizardPage_Container_selection);
        dialog.setMessage(Messages.NewWidgetWizardPage_Choose_a_container);
        dialog.addFilter(filter);
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        if (this.model.isPropertySet("WIDGET_PROJECT")) {
            IProject project = (IProject)this.model.getProperty("WIDGET_PROJECT");
            if (this.model.isPropertySet("FOLDER")) {
                String folderName = this.model.getStringProperty("FOLDER");
                IPath folderPath = new Path(folderName).removeFirstSegments(1);
                IFolder folder = project.getFolder(folderPath);
                dialog.setInitialSelection((Object)folder);
            }
        }
        if (dialog.open() == 0) {
            Object element = dialog.getFirstResult();
            try {
                if (element instanceof IContainer) {
                    IContainer container = (IContainer)element;
                    String newContainerPathString = container.getFullPath().toString();
                    this.model.setProperty("FOLDER", (Object)newContainerPathString);
                }
            }
            catch (Exception exception) {}
        }
    }

    protected ViewerFilter getContainerDialogViewerFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object element) {
                boolean ret = false;
                if (element instanceof IProject) {
                    IProject project = (IProject)element;
                    IProject thisProject = (IProject)((DataModelWizardPage)NewWidgetWizardPage.this).model.getProperty("WIDGET_PROJECT");
                    if (project.equals((Object)thisProject)) {
                        ret = ProjectFacetsUtil.isWebProject((IProject)project);
                    }
                } else if (element instanceof IContainer) {
                    IContainer container = (IContainer)element;
                    ret = ProjectFacetsUtil.isWithinWebRoot((IContainer)container);
                }
                return ret;
            }
        };
    }

    private ISelectionStatusValidator getContainerDialogSelectionValidator() {
        return new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                Status ret = new Status(4, "com.ibm.etools.webtools.gadgets.ui", 4, Messages.NewWidgetWizardPage_Choose_web_content_folder, null);
                try {
                    IContainer container;
                    String folderName;
                    if (!(selection[0] == null || selection[0] instanceof IProject || (folderName = (container = (IContainer)selection[0]).getFullPath().lastSegment()).equalsIgnoreCase("WEB-INF") || folderName.equalsIgnoreCase("META-INF"))) {
                        ret = new Status(0, "com.ibm.etools.webtools.gadgets.ui", 0, "", null);
                    }
                }
                catch (Exception exception) {}
                return ret;
            }
        };
    }
}

