/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iwt.publish.wizards;

import com.ibm.etools.webtools.filetransfer.wizards.nls.ResourceHandler;
import com.ibm.iwt.publish.wizards.JarFileExporter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class JarFileOperation
extends WorkspaceModifyOperation {
    private JarFileExporter exporter;
    private String fDestinationFilename;
    private IProgressMonitor monitor;
    private int leadupStartDepth = 0;
    private Vector resourcesToExport;
    private IResource resource;
    private boolean useCompression = true;
    private boolean createLeadupStructure = true;
    private boolean generateManifestFile = false;

    public JarFileOperation(IResource res, String filename) {
        this.resource = res;
        this.fDestinationFilename = filename;
    }

    public JarFileOperation(IResource res, Vector resources, String filename) {
        this(res, filename);
        this.resourcesToExport = resources;
    }

    protected int countChildrenOf(IResource resource) {
        if (resource.getType() == 1) {
            return 1;
        }
        try {
            int count = 0;
            if (resource.isAccessible()) {
                IResource[] children = ((IContainer)resource).members();
                int i = 0;
                while (i < children.length) {
                    count += this.countChildrenOf(children[i]);
                    ++i;
                }
            }
            return count;
        }
        catch (CoreException coreException) {
            return -1;
        }
    }

    protected int countSelectedResources() {
        int result = 0;
        Enumeration resources = this.resourcesToExport.elements();
        while (resources.hasMoreElements()) {
            result += this.countChildrenOf((IResource)resources.nextElement());
        }
        return result;
    }

    protected void execute(IProgressMonitor progressMonitor) throws CoreException {
        this.monitor = progressMonitor;
        try {
            this.initialize();
        }
        catch (IOException e) {
            throw new CoreException(J2EEPlugin.newErrorStatus((String)NLS.bind((String)ResourceHandler._5concat, (Object[])new Object[]{e.getMessage()}), (Throwable)e));
        }
        try {
            if (this.resourcesToExport == null) {
                this.monitor.beginTask(ResourceHandler.Exporting__UI_, this.countChildrenOf(this.resource));
                this.exportResource(this.resource);
            } else {
                this.monitor.beginTask(ResourceHandler.Exporting__UI_, this.countSelectedResources());
                this.exportSpecifiedResources();
            }
            try {
                this.exporter.finished();
            }
            catch (IOException e) {
                throw new CoreException(J2EEPlugin.newErrorStatus((String)NLS.bind((String)ResourceHandler._6concat, (Object[])new Object[0]), (Throwable)e));
            }
        }
        finally {
            this.monitor.done();
        }
    }

    protected void exportResource(IResource resource) {
        if (!resource.isAccessible()) {
            return;
        }
        if (resource.getType() == 1) {
            String destinationName = resource.getFullPath().removeFirstSegments(this.leadupStartDepth).toString();
            this.monitor.subTask(destinationName);
            try {
                this.exporter.write((IFile)resource, destinationName);
            }
            catch (IOException iOException) {
            }
            catch (CoreException coreException) {}
            this.monitor.worked(1);
            if (this.monitor.isCanceled()) {
                return;
            }
        } else {
            try {
                IResource[] children = ((IContainer)resource).members();
                int i = 0;
                while (i < children.length) {
                    this.exportResource(children[i]);
                    ++i;
                }
            }
            catch (CoreException coreException) {}
        }
    }

    protected void exportSpecifiedResources() {
        Enumeration resources = this.resourcesToExport.elements();
        while (resources.hasMoreElements()) {
            IResource currentResource = (IResource)resources.nextElement();
            if (this.resource == null && !this.createLeadupStructure) {
                this.leadupStartDepth = currentResource.getFullPath().segmentCount() - 1;
            }
            this.exportResource(currentResource);
        }
    }

    protected void initialize() throws IOException {
        this.exporter = new JarFileExporter(this.fDestinationFilename, this.useCompression, this.generateManifestFile);
        if (this.resource == null) {
            this.leadupStartDepth = 2;
        } else {
            this.leadupStartDepth = this.resource.getFullPath().segmentCount();
            if (this.resource.getType() == 1) {
                --this.leadupStartDepth;
            }
            if (this.createLeadupStructure) {
                this.leadupStartDepth = Math.min(2, this.leadupStartDepth);
            }
        }
    }
}

