/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iwt.ftpexport.wizards;

import com.ibm.etools.ftp.core.internal.PublishServerInfo;
import com.ibm.etools.webtools.filetransfer.wizards.nls.ResourceHandler;
import com.ibm.iwt.ftpexport.core.FtpExportServerArchive;
import com.ibm.iwt.ftpexport.wizards.FtpExportWizardPage1;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class FtpExportWizardPage2
extends WizardPage
implements Listener {
    private Label fFtpExportServerLabel;
    private Text fUserLoginText;
    private Text fPasswordText;
    private Button fSavePasswordCheckbox;
    private FtpExportWizardPage1 fPage1;

    public FtpExportWizardPage2() {
        super("PublishWizardPage2");
        this.setTitle(ResourceHandler.Identify_FTP_Login_Informa_UI_);
        this.setDescription(ResourceHandler.Provide_user_authenticatio_UI_);
    }

    private Button createCheckbox(Composite parent, String text) {
        Button button = new Button(parent, 32);
        button.setText(text);
        button.addListener(13, (Listener)this);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)data);
        return button;
    }

    private Composite createComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    public void createControl(Composite parent) {
        Composite shell = this.createComposite(parent, 2);
        this.createHorizontalFiller(shell, 2);
        Group group = this.createGroup(shell, 2, ResourceHandler.User_Authentication_UI_);
        GridData gd = (GridData)group.getLayoutData();
        gd.horizontalSpan = 2;
        this.createLabel((Composite)group, ResourceHandler.User_Login__UI_);
        this.fUserLoginText = this.createText((Composite)group);
        this.createLabel((Composite)group, ResourceHandler.Password_UI_);
        this.fPasswordText = this.createText((Composite)group);
        this.fPasswordText.setEchoChar('*');
        this.createHorizontalFiller(shell, 2);
        this.fSavePasswordCheckbox = this.createCheckbox(shell, ResourceHandler.Save_password_when_finishe_UI_);
        gd = (GridData)this.fSavePasswordCheckbox.getLayoutData();
        gd.horizontalIndent = 8;
        this.initializePage();
        this.setControl((Control)shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "com.ibm.etools.webtools.filetransfer.wizards.expw0003");
    }

    private Group createGroup(Composite parent, int numColumns, String text) {
        Group group = new Group(parent, 16);
        group.setText(text);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        group.setLayout((Layout)layout);
        return group;
    }

    private Label createHorizontalFiller(Composite parent, int horizontalSpan) {
        Label label = new Label(parent, 16384);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = horizontalSpan;
        label.setLayoutData((Object)data);
        return label;
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    private Text createText(Composite parent) {
        Text text = new Text(parent, 2052);
        text.addListener(24, (Listener)this);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.widthHint = 250;
        text.setLayoutData((Object)data);
        return text;
    }

    protected void enter(int direction) {
        this.populateFields();
        this.fUserLoginText.setFocus();
    }

    public String getPassword() {
        return this.fPasswordText.getText();
    }

    public boolean getSavePassword() {
        return this.fSavePasswordCheckbox.getSelection();
    }

    public String getUserLogin() {
        return this.fUserLoginText.getText();
    }

    public void handleEvent(Event event) {
        this.validatePage();
    }

    private void initializePage() {
        FtpExportServerArchive sa = this.fPage1.getServerArchive();
        if (sa != null) {
            PublishServerInfo si = sa.hasFtpExportServerInfo(this.fPage1.getPublishServer());
            this.updateFields(si);
        }
        this.validatePage();
    }

    public boolean isPageComplete() {
        return this.fUserLoginText != null && this.isValidUserLogin(this.fUserLoginText.getText()) && this.fPasswordText != null && this.isValidPassword(this.fPasswordText.getText());
    }

    private boolean isValidPassword(String password) {
        return true;
    }

    private boolean isValidUserLogin(String userLogin) {
        return !userLogin.equals("");
    }

    private void populateFields() {
        this.fFtpExportServerLabel.setText(String.valueOf(ResourceHandler.FTP_URL___UI_) + this.fPage1.getPublishServer());
    }

    public void setPage1(FtpExportWizardPage1 page1) {
        this.fPage1 = page1;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fUserLoginText.setFocus();
        }
    }

    public void updateFields(PublishServerInfo si) {
        if (si != null && this.fUserLoginText != null) {
            this.fUserLoginText.setText(si.getUserLogin());
            this.fPasswordText.setText(si.getPassword());
            this.fSavePasswordCheckbox.setSelection(si.getSavePassword());
        }
    }

    private void validatePage() {
        if (!this.isValidUserLogin(this.fUserLoginText.getText())) {
            this.setPageComplete(false);
            return;
        }
        if (!this.isValidPassword(this.fPasswordText.getText())) {
            this.setPageComplete(false);
            return;
        }
        this.setPageComplete(true);
    }
}

