/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iwt.ftpexport.wizards;

import com.ibm.etools.ftp.core.internal.FtpFirewall;
import com.ibm.etools.ftp.core.internal.PublishServerInfo;
import com.ibm.etools.webtools.filetransfer.wizards.nls.ResourceHandler;
import com.ibm.iwt.ftpexport.IContinueQuery;
import com.ibm.iwt.ftpexport.core.FtpExportServerArchive;
import com.ibm.iwt.ftpexport.wizards.FirewallDialog;
import com.ibm.iwt.ftpexport.wizards.FtpExportOperation;
import com.ibm.iwt.ftpexport.wizards.FtpExportWizard;
import com.ibm.iwt.ftpexport.wizards.FtpExportWizardPage2;
import com.ibm.iwt.util.PathConverter;
import com.ibm.iwt.webtools.WebToolsPlugin;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class FtpExportWizardPage1
extends WizardPage
implements IContinueQuery,
Listener {
    private Text fContainerNameText;
    private Button fContainerBrowseButton;
    private Combo fServerNameCombo;
    private Combo fTargetFolderCombo;
    private Button fPassiveModeCheckbox;
    private Button fUseFirewallCheckbox;
    private Button fFirewallSettings;
    private Text fConnectionTimeoutText;
    private FtpExportWizardPage2 fPage2;
    private FtpExportServerArchive fServerArchive = new FtpExportServerArchive();
    private IStructuredSelection fCurrentSelection = null;
    private boolean fExportCurrentSelection = false;
    private boolean fIsInitialize = false;
    private static final String FTP_PREFIX = "ftp://";
    private static final String FTP_PROTOCOL = "ftp";
    private static final String CURRENT_SELECTION = ResourceHandler.current_selection;
    private static final int DEFAULT_CONNECTION_TIMEOUT = 10000;
    private FtpFirewall fFirewallData;
    private static final String ID_HOSTNAME = "FtpExportWizardPage1.Hostname";
    private static final String ID_TARGETFOLDER = "FtpExportWizardPage1.TargetFolder";
    protected static final int COMBO_HISTORY_LENGTH = 10;

    public FtpExportWizardPage1() {
        super("PublishWizardPage1");
        this.setTitle(ResourceHandler.Specify_the_URL_for_the_FT_UI_2);
        this.setDescription(ResourceHandler.Identify_the_FTP_Server_an_UI_);
    }

    private Button createCheckbox(Composite parent, String text) {
        Button button = new Button(parent, 32);
        button.setText(text);
        button.addListener(13, (Listener)this);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)data);
        return button;
    }

    private Combo createCombo(Composite parent, int style, int numColumns) {
        Combo combo = new Combo(parent, style);
        combo.addListener(24, (Listener)this);
        combo.addListener(13, (Listener)this);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = numColumns;
        combo.setLayoutData((Object)data);
        return combo;
    }

    private Composite createComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    public void createControl(Composite parent) {
        Composite shell = this.createComposite(parent, 3);
        this.createLabel(shell, ResourceHandler.Container__UI_);
        this.fContainerNameText = this.createText(shell, 250);
        this.fContainerBrowseButton = new Button(shell, 0x1000008);
        this.fContainerBrowseButton.setText(ResourceHandler.Browse____UI_);
        this.fContainerBrowseButton.addListener(13, (Listener)this);
        GridData gd = new GridData(768);
        this.fContainerBrowseButton.setLayoutData((Object)gd);
        this.createLabel(shell, ResourceHandler.FTP_URL_HOST__UI_);
        this.fServerNameCombo = this.createCombo(shell, 4, 1);
        this.createHorizontalFiller(shell, 1);
        this.createLabel(shell, ResourceHandler.FTP_URL_FOLDER__UI_);
        this.fTargetFolderCombo = this.createCombo(shell, 4, 1);
        this.createHorizontalFiller(shell, 1);
        Group group = this.createGroup(shell, 2, ResourceHandler.FTP_Options_UI_);
        gd = (GridData)group.getLayoutData();
        gd.horizontalSpan = 3;
        this.fPassiveModeCheckbox = this.createCheckbox((Composite)group, ResourceHandler.Use_PASV_Mode__Passive_Mod_UI_);
        gd = (GridData)this.fPassiveModeCheckbox.getLayoutData();
        gd.horizontalIndent = 8;
        this.createHorizontalFiller((Composite)group, 1);
        this.fUseFirewallCheckbox = this.createCheckbox((Composite)group, ResourceHandler.Use_Firewall_UI_);
        gd = (GridData)this.fUseFirewallCheckbox.getLayoutData();
        gd.horizontalIndent = 8;
        this.fFirewallSettings = new Button((Composite)group, 8);
        this.fFirewallSettings.setText(ResourceHandler.Settings____UI_);
        this.fFirewallSettings.addListener(13, (Listener)this);
        this.fFirewallSettings.setEnabled(false);
        Composite connectionGroup = this.createComposite(shell, 3);
        gd = (GridData)connectionGroup.getLayoutData();
        gd.horizontalSpan = 3;
        this.createLabel(connectionGroup, ResourceHandler.Connection_Timeout__millis_UI_);
        this.fConnectionTimeoutText = this.createText(connectionGroup, 50);
        this.createLabel(connectionGroup, ResourceHandler.millis_UI_);
        this.initializePage();
        this.setControl((Control)shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "com.ibm.etools.webtools.filetransfer.wizards.expw0002");
    }

    private Group createGroup(Composite parent, int numColumns, String text) {
        Group group = new Group(parent, 16);
        group.setText(text);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        group.setLayout((Layout)layout);
        return group;
    }

    private Label createHorizontalFiller(Composite parent, int horizontalSpan) {
        Label label = new Label(parent, 16384);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = horizontalSpan;
        label.setLayoutData((Object)data);
        return label;
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    private Text createText(Composite parent, int widthHint) {
        Text text = new Text(parent, 2052);
        text.addListener(24, (Listener)this);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = false;
        data.widthHint = widthHint;
        text.setLayoutData((Object)data);
        return text;
    }

    protected void enter(int direction) {
    }

    private boolean executePublishOperation() {
        FtpExportOperation op;
        boolean closeWizard;
        block10: {
            closeWizard = true;
            PublishServerInfo si = new PublishServerInfo();
            URL seedUrl = this.getSeedUrl();
            si.setServerPath(seedUrl == null ? "" : seedUrl.toExternalForm());
            si.setServerName(seedUrl.getHost());
            String rawPath = this.fTargetFolderCombo.getText().trim();
            if (rawPath.startsWith("\"") && rawPath.length() >= 2) {
                rawPath = rawPath.substring(1);
            }
            if (rawPath.endsWith("\"") && rawPath.length() >= 2) {
                rawPath = rawPath.substring(0, rawPath.length() - 1);
            }
            si.setFtpFolder(rawPath);
            int i = seedUrl.getPort();
            if (i == -1) {
                i = 21;
            }
            si.setFtpPort(new Integer(i).toString());
            si.setPassiveMode(this.fPassiveModeCheckbox.getSelection());
            si.setFirewallData(this.fFirewallData);
            si.setUseFirewall(this.fUseFirewallCheckbox.getSelection());
            int connectionTimeout = 10000;
            try {
                connectionTimeout = new Integer(this.fConnectionTimeoutText.getText());
            }
            catch (NumberFormatException numberFormatException) {}
            si.setConnectionTimeout(connectionTimeout);
            si.setUserLogin(this.fPage2.getUserLogin());
            si.setPassword(this.fPage2.getPassword());
            si.setSavePassword(this.fPage2.getSavePassword());
            op = new FtpExportOperation(this.getSpecifiedContainer(), this.fCurrentSelection, si, ResourceHandler.FTP_Export, this);
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
            String errorMessage = op.getErrorString();
            if (errorMessage == null || errorMessage.length() <= 0) break block10;
            MessageDialog.openError((Shell)this.getShell(), (String)ResourceHandler.FTP_Export_Error_UI_, (String)errorMessage);
            return false;
        }
        try {
            if (op.getStatsString() != null) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)ResourceHandler.FTP_Export_Statistics_UI_, (String)op.getStatsString());
            }
        }
        catch (InvocationTargetException oe) {
            WebToolsPlugin.openDialogForException((Throwable)oe);
            closeWizard = false;
        }
        catch (InterruptedException interruptedException) {}
        return closeWizard;
    }

    public boolean finish() {
        boolean closeWizard = this.executePublishOperation();
        this.saveServerArchive();
        return closeWizard;
    }

    private IStructuredSelection getParentSelection() {
        FtpExportWizard wizard = (FtpExportWizard)this.getWizard();
        if (wizard == null) {
            return null;
        }
        return wizard.getSelection();
    }

    public String getPublishServer() {
        return this.getSeedUrlAsString();
    }

    private String getSeedUrlAsString() {
        return this.getSeedUrl() == null ? "" : this.getSeedUrl().toExternalForm();
    }

    private URL getSeedUrl() {
        URL url = null;
        String rawString1 = this.fServerNameCombo.getText().trim();
        if (rawString1.length() == 0) {
            return null;
        }
        String rawString2 = this.fTargetFolderCombo.getText().trim();
        if (rawString2.startsWith("\"") && rawString2.length() >= 2) {
            rawString2 = rawString2.substring(1);
        }
        if (rawString2.endsWith("\"") && rawString2.length() >= 2) {
            rawString2 = rawString2.substring(0, rawString2.length() - 1);
        }
        if (rawString1.endsWith("/") && rawString2.startsWith("/")) {
            rawString1 = rawString1.substring(0, rawString1.length() - 2);
        }
        if (!rawString1.endsWith("/") && !rawString2.startsWith("/")) {
            rawString1 = String.valueOf(rawString1) + "/";
        }
        String wholeString = String.valueOf(rawString1) + rawString2;
        try {
            url = new URL(wholeString);
        }
        catch (MalformedURLException malformedURLException) {
            wholeString = FTP_PREFIX + wholeString;
            try {
                url = new URL(wholeString);
            }
            catch (MalformedURLException malformedURLException2) {}
        }
        if (url != null) {
            if (!url.getProtocol().equalsIgnoreCase(FTP_PROTOCOL)) {
                url = null;
            }
            if (url != null && url.getHost().length() == 0) {
                url = null;
            }
        }
        return url;
    }

    public FtpExportServerArchive getServerArchive() {
        return this.fServerArchive;
    }

    private IResource getSpecifiedContainer() {
        String pathString;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus result = workspace.validatePath(pathString = new Path(this.fContainerNameText.getText()).makeAbsolute().toString(), 7);
        if (result.isOK()) {
            Path path = new Path(pathString);
            if (workspace.getRoot().exists((IPath)path)) {
                return workspace.getRoot().findMember((IPath)path);
            }
        }
        return null;
    }

    protected void handleContainerNameTextModified() {
        if (this.fExportCurrentSelection) {
            this.fExportCurrentSelection = false;
            if (PathConverter.toAbsolutePath((String)this.fContainerNameText.getText()).length() > CURRENT_SELECTION.length()) {
                this.fContainerNameText.setText(PathConverter.toAbsolutePath((String)this.fContainerNameText.getText()).substring(CURRENT_SELECTION.length()));
            } else {
                this.fContainerNameText.setText("");
            }
        }
    }

    public void handleEvent(Event event) {
        Widget source = event.widget;
        if (source.equals(this.fContainerBrowseButton)) {
            this.handleResourceBrowseButtonPressed();
        } else if (source.equals(this.fContainerNameText)) {
            this.handleContainerNameTextModified();
            this.validatePage(false);
        } else if (source.equals(this.fServerNameCombo) || source.equals(this.fTargetFolderCombo)) {
            if (event.type == 13) {
                PublishServerInfo si = this.fServerArchive.hasFtpExportServerInfo(this.getSeedUrlAsString());
                if (this.isValidTimeout()) {
                    si.setConnectionTimeout(Integer.parseInt(this.fConnectionTimeoutText.getText()));
                }
                this.updateFields(si);
                this.fPage2.updateFields(si);
            }
            this.validatePage(false);
        } else if (source.equals(this.fUseFirewallCheckbox)) {
            if (event.type == 13) {
                this.fFirewallSettings.setEnabled(this.fUseFirewallCheckbox.getSelection());
            }
            this.validatePage(false);
        } else if (source.equals(this.fFirewallSettings)) {
            if (event.type == 13) {
                this.handleFirewall();
            }
            this.validatePage(false);
        } else if (source.equals(this.fConnectionTimeoutText)) {
            this.validatePage(false);
        }
    }

    private void handleFirewall() {
        PublishServerInfo si = this.fServerArchive.hasFtpExportServerInfo(this.getSeedUrlAsString());
        FirewallDialog firewallDlg = null;
        FtpFirewall tempFirewallData = null;
        if (si != null) {
            tempFirewallData = si.getFirewallData();
        }
        if (tempFirewallData == null) {
            tempFirewallData = this.fFirewallData;
        }
        if (tempFirewallData == null) {
            tempFirewallData = new FtpFirewall();
            tempFirewallData.setUseSocks(true);
        }
        firewallDlg = new FirewallDialog(this.getShell(), tempFirewallData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)firewallDlg.getShell(), "com.ibm.etools.webtools.filetransfer.wizards.expw00010");
        firewallDlg.setBlockOnOpen(true);
        int rc = firewallDlg.open();
        if (rc == 0) {
            this.fFirewallData = new FtpFirewall();
            this.fFirewallData.setHostname(firewallDlg.getHostname());
            this.fFirewallData.setType(firewallDlg.getType());
            this.fFirewallData.setPort(firewallDlg.getPort());
            this.fFirewallData.setUserID(firewallDlg.getUserID());
            this.fFirewallData.setPassword(firewallDlg.getPassword());
            this.fFirewallData.setSavePassword(firewallDlg.getSavePassword());
            this.fFirewallData.setUseSocks(firewallDlg.getUseSocks());
            this.fFirewallData.setSocksHostName(firewallDlg.getSocksHostName());
            this.fFirewallData.setSocksPort(firewallDlg.getSocksPort());
        }
    }

    protected void handleResourceBrowseButtonPressed() {
        IPath path;
        IResource currentFolder = this.getSpecifiedContainer();
        IContainer container = null;
        if (currentFolder != null && currentFolder.getType() == 1) {
            currentFolder = currentFolder.getParent();
            container = (IContainer)currentFolder;
        }
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setTitle(ResourceHandler.Resource_selection_UI_);
        dialog.setAllowMultiple(false);
        dialog.setMessage(ResourceHandler.Select_the_resource_to_exp_UI_);
        if (container != null) {
            dialog.setInput((Object)container.getProject());
        } else {
            dialog.setInput((Object)WebToolsPlugin.getWorkspace().getRoot());
        }
        dialog.setBlockOnOpen(true);
        dialog.open();
        Object[] resourceList = dialog.getResult();
        if (resourceList != null && resourceList.length > 0 && !PathConverter.toRelativePath((String)(path = ((IResource)resourceList[0]).getFullPath()).toString()).equals(this.fContainerNameText.getText())) {
            this.fExportCurrentSelection = false;
            this.fContainerNameText.setText(PathConverter.toRelativePath((String)path.toString()));
        }
    }

    private void initializePage() {
        Vector serversVector;
        this.fIsInitialize = true;
        this.fCurrentSelection = this.getParentSelection();
        Vector<IResource> selections = new Vector<IResource>();
        for (IResource currentResource : this.fCurrentSelection) {
            if (!currentResource.isAccessible()) continue;
            selections.addElement(currentResource);
        }
        if (!selections.isEmpty()) {
            if (selections.size() == 1) {
                IResource resource = (IResource)selections.firstElement();
                this.fContainerNameText.setText(PathConverter.toRelativePath((String)resource.getFullPath().toString()));
            } else {
                this.fContainerNameText.setText(CURRENT_SELECTION);
                this.fExportCurrentSelection = true;
            }
        }
        this.fConnectionTimeoutText.setText(new Integer(10000).toString());
        this.loadServerArchive();
        IDialogSettings store = this.getDialogSettings();
        if (store != null) {
            String[] serverPaths = store.getArray(ID_HOSTNAME);
            String[] targetFolders = store.getArray(ID_TARGETFOLDER);
            if (serverPaths != null) {
                this.fServerNameCombo.setItems(serverPaths);
                this.fServerNameCombo.select(0);
            }
            if (targetFolders != null) {
                this.fTargetFolderCombo.setItems(targetFolders);
                this.fTargetFolderCombo.select(0);
            }
        }
        if ((serversVector = this.fServerArchive.getFtpExportServerInfos()).size() > 0) {
            PublishServerInfo si = this.fServerArchive.hasFtpExportServerInfo(this.getSeedUrlAsString());
            this.updateFields(si);
            this.fIsInitialize = false;
            this.validatePage(true);
            if (this.isPageComplete()) {
                this.fServerNameCombo.setFocus();
            }
        } else {
            this.fIsInitialize = false;
            this.setPageComplete(false);
            this.fServerNameCombo.setFocus();
        }
    }

    private boolean isValidFtpPort(String ftpPort) {
        if (ftpPort.equals("")) {
            return false;
        }
        int i = 0;
        while (i < ftpPort.length()) {
            if (!Character.isDigit(ftpPort.charAt(i))) {
                this.setErrorMessage(ResourceHandler.Invalid_port_number_UI_);
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isValidSelection(boolean giveErrorFocus) {
        if (!this.fExportCurrentSelection) {
            IResource resource = this.getSpecifiedContainer();
            if (resource != null) {
                IProject targetProject = resource.getProject();
                if (targetProject == null) {
                    this.setErrorMessage(ResourceHandler.Specify_a_valid_container__UI_);
                    if (giveErrorFocus) {
                        this.fContainerNameText.setFocus();
                    }
                    return false;
                }
                this.fCurrentSelection = new StructuredSelection((Object)resource);
            } else {
                this.fCurrentSelection = null;
                this.setErrorMessage(ResourceHandler.Invalid_resource_selection_UI_);
                if (giveErrorFocus) {
                    this.fContainerNameText.setFocus();
                }
                return false;
            }
        }
        return true;
    }

    private boolean isValidServerPath() {
        URL url = this.getSeedUrl();
        if (url == null) {
            if (this.fServerNameCombo.getText().length() == 0) {
                this.setErrorMessage(ResourceHandler.Specify_FTP_Server_URL_UI_);
            } else {
                this.setErrorMessage(ResourceHandler.Invalid_FTP_Server_URL_UI_);
            }
            return false;
        }
        int i = url.getPort();
        if (i != -1) {
            this.isValidFtpPort(new Integer(i).toString());
        }
        return true;
    }

    private boolean isValidFirewall() {
        boolean retVal = true;
        if (this.fUseFirewallCheckbox.getSelection() && this.fFirewallData == null) {
            this.setErrorMessage(ResourceHandler.missing_firewall_info);
            retVal = false;
        }
        return retVal;
    }

    public boolean isValidTimeout() {
        String sTimeout = this.fConnectionTimeoutText.getText().trim();
        int iTimeout = -1;
        if (sTimeout.length() > 0) {
            try {
                Integer T = new Integer(sTimeout);
                iTimeout = T;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return iTimeout > 0;
    }

    public void loadServerArchive() {
        try {
            this.fServerArchive.load();
        }
        catch (Exception exception) {}
    }

    @Override
    public String queryFileError(String pathString) {
        String[] buttonStrings = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IContinueQuery.IGNOREALL};
        String msg = NLS.bind((String)ResourceHandler.error_creating_ERROR_, (Object[])new Object[]{pathString});
        int ret = -1;
        final MessageDialog dialog = new MessageDialog(this.getShell(), ResourceHandler.Error_encountered_UI_, null, msg, 3, buttonStrings, 1);
        dialog.setBlockOnOpen(true);
        Display disp = this.getShell().getDisplay();
        if (!disp.getThread().equals(Thread.currentThread())) {
            disp.syncExec(new Runnable(){

                @Override
                public void run() {
                    dialog.create();
                    dialog.open();
                }
            });
        } else {
            dialog.create();
            dialog.open();
        }
        ret = dialog.getReturnCode();
        return this.delocalize(buttonStrings[ret]);
    }

    protected String delocalize(String localizedStr) {
        if (localizedStr.equals(IDialogConstants.YES_LABEL)) {
            return "YES";
        }
        if (localizedStr.equals(IDialogConstants.NO_LABEL)) {
            return "NO";
        }
        if (localizedStr.equals(IDialogConstants.YES_TO_ALL_LABEL)) {
            return "ALL";
        }
        if (localizedStr.equals(IDialogConstants.CANCEL_LABEL)) {
            return "CANCEL";
        }
        return localizedStr;
    }

    public String queryOverwrite(String pathString) {
        String[] buttonStrings = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL};
        String msg = NLS.bind((String)ResourceHandler.resource_WARN_, (Object[])new Object[]{pathString});
        final MessageDialog dialog = new MessageDialog(this.getShell(), ResourceHandler.Question_UI_, null, msg, 3, buttonStrings, 1);
        dialog.setBlockOnOpen(true);
        Display disp = this.getShell().getDisplay();
        if (!disp.getThread().equals(Thread.currentThread())) {
            disp.syncExec(new Runnable(){

                @Override
                public void run() {
                    dialog.create();
                    dialog.open();
                }
            });
        } else {
            dialog.create();
            dialog.open();
        }
        return this.delocalize(buttonStrings[dialog.getReturnCode()]);
    }

    public void saveServerArchive() {
        IDialogSettings store = this.getDialogSettings();
        if (store != null) {
            String[] hostnames = store.getArray(ID_HOSTNAME);
            if (hostnames == null) {
                hostnames = new String[]{};
            }
            hostnames = this.addToHistory(hostnames, this.fServerNameCombo.getText());
            store.put(ID_HOSTNAME, hostnames);
            String[] folders = store.getArray(ID_TARGETFOLDER);
            if (folders == null) {
                folders = new String[]{};
            }
            folders = this.addToHistory(folders, this.fTargetFolderCombo.getText());
            store.put(ID_TARGETFOLDER, folders);
        }
        PublishServerInfo si = new PublishServerInfo();
        URL url = this.getSeedUrl();
        if (url != null) {
            si.setServerPath(url.toExternalForm());
            si.setServerName(this.fServerNameCombo.getText());
            String rawPath = this.fTargetFolderCombo.getText();
            if (rawPath.startsWith("\"") && rawPath.length() >= 2) {
                rawPath = rawPath.substring(1);
            }
            if (rawPath.endsWith("\"") && rawPath.length() >= 2) {
                rawPath = rawPath.substring(0, rawPath.length() - 1);
            }
            si.setFtpFolder(rawPath);
            int i = url.getPort();
            if (i == -1) {
                i = 21;
            }
            si.setFtpPort(new Integer(i).toString());
            si.setPassiveMode(this.fPassiveModeCheckbox.getSelection());
            si.setUseFirewall(this.fUseFirewallCheckbox.getSelection());
            si.setFirewallData(this.fFirewallData);
            int connectionTimeout = 10000;
            try {
                connectionTimeout = new Integer(this.fConnectionTimeoutText.getText());
            }
            catch (NumberFormatException numberFormatException) {}
            si.setConnectionTimeout(connectionTimeout);
            si.setUserLogin(this.fPage2.getUserLogin());
            if (this.fPage2.getSavePassword()) {
                si.setPassword(this.fPage2.getPassword());
            } else {
                si.setPassword("");
            }
            si.setSavePassword(this.fPage2.getSavePassword());
            this.fServerArchive.addFtpExportServerInfo(si);
            try {
                this.fServerArchive.save();
            }
            catch (Exception exception) {}
        }
    }

    public void setPage2(FtpExportWizardPage2 page2) {
        this.fPage2 = page2;
    }

    public void updateFields(PublishServerInfo si) {
        if (si != null) {
            this.fPassiveModeCheckbox.setSelection(si.getPassiveMode());
            this.fConnectionTimeoutText.setText(new Integer(si.getConnectionTimeout()).toString());
            this.fUseFirewallCheckbox.setSelection(si.getUseFirewall());
            this.fFirewallSettings.setEnabled(si.getUseFirewall());
            this.fFirewallData = si.getFirewallData();
        }
    }

    private void validatePage(boolean changeFocus) {
        if (this.fIsInitialize) {
            this.setErrorMessage(null);
            return;
        }
        if (!this.isValidSelection(changeFocus)) {
            this.setPageComplete(false);
            return;
        }
        if (!this.isValidServerPath()) {
            this.setPageComplete(false);
            return;
        }
        if (!this.isValidFirewall()) {
            this.setPageComplete(false);
            return;
        }
        if (!this.isValidTimeout()) {
            this.setErrorMessage(ResourceHandler.Invalid_Timeout_Value_UI_);
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    private String[] addToHistory(String[] history, String newEntry) {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(history));
        list.remove(newEntry);
        list.add(0, newEntry);
        if (list.size() > 10) {
            list.remove(10);
        }
        String[] r = new String[list.size()];
        list.toArray(r);
        return r;
    }
}

