/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iwt.ftpexport.wizards;

import com.ibm.etools.ftp.core.internal.FtpFirewall;
import com.ibm.etools.webtools.filetransfer.wizards.nls.ResourceHandler;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class FirewallDialog
extends Dialog
implements SelectionListener {
    private Button fFirewallGeneral;
    private Button fFirewallSite;
    private Button fFirewallUserNoLogon;
    private Button fFirewallUser;
    private Button fFirewallOpen;
    private Button fSavePassordButton;
    private Text fHostnameField;
    private Text fUserIDField;
    private Text fPasswordField;
    private Text fPortField;
    private Button fUseSocksButton;
    private Button fUseFtpProxyButton;
    private Text fSocksHostNameField;
    private Text fSocksPortField;
    private boolean fUseSocks = true;
    private String fSocksHostName = "";
    private int fSocksPort = 1080;
    private String fHostname = "";
    private String fUserID = "";
    private String fPassword = "";
    private boolean fSavePassword = false;
    private int fPort = 2121;
    private int fType = 3;
    public String title = ResourceHandler.Firewall_settings_UI_;

    public FirewallDialog(Shell shell) {
        super(shell);
        this.create();
    }

    public FirewallDialog(Shell shell, FtpFirewall data) {
        this(shell);
        if (data != null) {
            this.fUseSocks = data.getUseSocks();
            this.fSocksHostNameField.setText(data.getSocksHostName());
            this.fSocksHostName = data.getSocksHostName();
            this.fSocksPortField.setText(new Integer(data.getSocksPort()).toString());
            this.fSocksPort = data.getSocksPort();
            this.fHostnameField.setText(data.getHostname());
            this.fHostname = data.getHostname();
            this.fUserIDField.setText(data.getUserID());
            this.fUserID = data.getUserID();
            this.fPasswordField.setText(data.getPassword());
            this.fPassword = data.getPassword();
            this.fPortField.setText(new Integer(data.getPort()).toString());
            this.fPort = data.getPort();
            int type = data.getType();
            this.fType = data.getType();
            this.fFirewallGeneral.setSelection(false);
            this.fFirewallSite.setSelection(false);
            this.fFirewallUserNoLogon.setSelection(false);
            this.fFirewallUser.setSelection(false);
            if (type == 0) {
                this.fFirewallGeneral.setSelection(true);
            } else if (type == 1) {
                this.fFirewallSite.setSelection(true);
            } else if (type == 2) {
                this.fFirewallUserNoLogon.setSelection(true);
            } else if (type == 3) {
                this.fFirewallUser.setSelection(true);
            } else if (type == 4) {
                this.fFirewallOpen.setSelection(true);
            }
            if (this.fUseSocks) {
                this.fUseSocksButton.setSelection(true);
                this.fUseFtpProxyButton.setSelection(false);
            } else {
                this.fUseSocksButton.setSelection(false);
                this.fUseFtpProxyButton.setSelection(true);
            }
            this.enableOrDisableOptions();
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    private Button createButton(Composite parent, String text, int style) {
        Button btn = new Button(parent, style);
        btn.setText(text);
        GridData data = new GridData();
        btn.setLayoutData((Object)data);
        return btn;
    }

    private Button createCheckbox(Composite parent, String text) {
        Button button = new Button(parent, 32);
        button.setText(text);
        button.addSelectionListener((SelectionListener)this);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)data);
        return button;
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        c.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        c.setLayoutData((Object)data);
        this.fUseSocksButton = this.createButton(c, "Socks", 16);
        this.fUseSocksButton.addSelectionListener((SelectionListener)this);
        this.createLabel(c, "   ");
        this.fUseSocksButton.setSelection(true);
        this.createHorizontalFiller(c, 1);
        this.createLabel(c, ResourceHandler.Socks_Host_Name___UI_);
        this.fSocksHostNameField = this.createText(c, 140);
        this.createHorizontalFiller(c, 1);
        this.createLabel(c, ResourceHandler.Port_UI_);
        this.fSocksPortField = this.createText(c, 40);
        this.createHorizontalFiller(c, 1);
        this.fUseFtpProxyButton = this.createButton(c, ResourceHandler.FTP_Proxy_UI_, 16);
        this.fUseFtpProxyButton.addSelectionListener((SelectionListener)this);
        this.createLabel(c, "   ");
        this.fUseFtpProxyButton.setSelection(false);
        this.createHorizontalFiller(c, 1);
        this.createLabel(c, ResourceHandler.Hostname__UI_);
        this.fHostnameField = this.createText(c, 140);
        this.createHorizontalFiller(c, 1);
        this.createLabel(c, ResourceHandler.User_ID__UI_);
        this.fUserIDField = this.createText(c, 140);
        this.createHorizontalFiller(c, 1);
        this.createLabel(c, ResourceHandler.Password_UI_);
        this.fPasswordField = this.createText(c, 140);
        this.fPasswordField.setEchoChar('*');
        this.fSavePassordButton = this.createCheckbox(c, ResourceHandler.Save_Password_UI_);
        this.createLabel(c, ResourceHandler.Port__UI_);
        this.fPortField = this.createText(c, 40);
        this.createHorizontalFiller(c, 1);
        Group group = this.createGroup(c, 2, ResourceHandler.Firewall_type_UI_);
        GridData gd = (GridData)group.getLayoutData();
        gd.horizontalSpan = 3;
        this.fFirewallUserNoLogon = this.createButton((Composite)group, ResourceHandler.USER__no_logon__UI_, 16);
        this.fFirewallUserNoLogon.setSelection(true);
        this.fFirewallOpen = this.createButton((Composite)group, ResourceHandler.OPEN_UI_, 16);
        this.fFirewallUser = this.createButton((Composite)group, ResourceHandler.USER_UI_, 16);
        this.fFirewallSite = this.createButton((Composite)group, ResourceHandler.SITE_UI_, 16);
        this.fFirewallGeneral = this.createButton((Composite)group, ResourceHandler.General_UI_, 16);
        this.fFirewallGeneral.setVisible(false);
        this.enableOrDisableOptions();
        return c;
    }

    private Group createGroup(Composite parent, int numColumns, String text) {
        Group group = new Group(parent, 16);
        group.setText(text);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        group.setLayout((Layout)layout);
        return group;
    }

    private Label createHorizontalFiller(Composite parent, int horizontalSpan) {
        Label label = new Label(parent, 16384);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = horizontalSpan;
        label.setLayoutData((Object)data);
        return label;
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    private Text createText(Composite parent, int widthHint) {
        Text text = new Text(parent, 2052);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = false;
        data.widthHint = widthHint;
        text.setLayoutData((Object)data);
        return text;
    }

    private void enableOrDisableOptions() {
        if (this.fUseSocksButton.getSelection()) {
            this.fSocksHostNameField.setEnabled(true);
            this.fSocksPortField.setEnabled(true);
            this.fHostnameField.setEnabled(false);
            this.fUserIDField.setEnabled(false);
            this.fPasswordField.setEnabled(false);
            this.fPortField.setEnabled(false);
            this.fSavePassordButton.setEnabled(false);
            this.fFirewallGeneral.setEnabled(false);
            this.fFirewallSite.setEnabled(false);
            this.fFirewallUserNoLogon.setEnabled(false);
            this.fFirewallUser.setEnabled(false);
            this.fFirewallOpen.setEnabled(false);
        } else if (this.fUseFtpProxyButton.getSelection()) {
            this.fSocksHostNameField.setEnabled(false);
            this.fSocksPortField.setEnabled(false);
            this.fHostnameField.setEnabled(true);
            this.fUserIDField.setEnabled(true);
            this.fPasswordField.setEnabled(true);
            this.fPortField.setEnabled(true);
            this.fSavePassordButton.setEnabled(true);
            this.fFirewallGeneral.setEnabled(true);
            this.fFirewallSite.setEnabled(true);
            this.fFirewallUserNoLogon.setEnabled(true);
            this.fFirewallUser.setEnabled(true);
            this.fFirewallOpen.setEnabled(true);
        }
    }

    public String getHostname() {
        return this.fHostname;
    }

    public String getPassword() {
        return this.fPassword;
    }

    public int getPort() {
        return this.fPort;
    }

    public boolean getSavePassword() {
        return this.fSavePassword;
    }

    public String getSocksHostName() {
        return this.fSocksHostName;
    }

    public int getSocksPort() {
        return this.fSocksPort;
    }

    public int getType() {
        return this.fType;
    }

    public String getUserID() {
        return this.fUserID;
    }

    public boolean getUseSocks() {
        return this.fUseSocks;
    }

    protected void okPressed() {
        if (this.fUseSocksButton.getSelection()) {
            boolean bSuccess = true;
            String socksHostName = "";
            String socksPort = "";
            socksHostName = this.fSocksHostNameField.getText();
            socksPort = this.fSocksPortField.getText();
            socksHostName = socksHostName.trim();
            socksPort = socksPort.trim();
            boolean bPortValid = true;
            boolean bProxyValid = true;
            if (socksPort.length() > 0) {
                try {
                    this.fSocksPort = new Integer(this.fSocksPortField.getText());
                    if (this.fSocksPort <= 0 || this.fSocksPort > 65535) {
                        bPortValid = false;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    bPortValid = false;
                }
            }
            if (socksHostName.length() > 0 && socksPort.length() == 0) {
                bPortValid = false;
            }
            if (socksPort.length() > 0 && socksHostName.length() == 0) {
                bProxyValid = false;
            }
            if (!bPortValid) {
                MessageDialog.openError((Shell)this.getShell(), (String)ResourceHandler.Error_UI_, (String)ResourceHandler.Specify_a_valid_port__ERROR_);
                this.fSocksPortField.setFocus();
                bSuccess = false;
            } else if (!bProxyValid) {
                MessageDialog.openError((Shell)this.getShell(), (String)ResourceHandler.Error_UI_, (String)ResourceHandler.Specify_a_proxy_server__ERROR_);
                this.fSocksHostNameField.setFocus();
                bSuccess = false;
            }
            if (bSuccess) {
                this.fSocksHostName = socksHostName;
                this.fUseSocks = true;
                super.okPressed();
            }
        } else if (this.fUseFtpProxyButton.getSelection()) {
            boolean bSuccess = true;
            String proxyServer = "";
            String strPort = "";
            proxyServer = this.fHostnameField.getText();
            strPort = this.fPortField.getText();
            proxyServer = proxyServer.trim();
            strPort = strPort.trim();
            boolean bPortValid = true;
            boolean bProxyValid = true;
            if (strPort.length() > 0) {
                try {
                    this.fPort = new Integer(this.fPortField.getText());
                    if (this.fPort <= 0 || this.fPort > 65535) {
                        bPortValid = false;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    bPortValid = false;
                }
            }
            if (proxyServer.length() > 0 && strPort.length() == 0) {
                bPortValid = false;
            }
            if (strPort.length() > 0 && proxyServer.length() == 0) {
                bProxyValid = false;
            }
            if (!bPortValid) {
                MessageDialog.openError((Shell)this.getShell(), (String)ResourceHandler.Error_UI_, (String)ResourceHandler.Specify_a_valid_port__ERROR_);
                this.fPortField.setFocus();
                bSuccess = false;
            } else if (!bProxyValid) {
                MessageDialog.openError((Shell)this.getShell(), (String)ResourceHandler.Error_UI_, (String)ResourceHandler.Specify_a_proxy_server__ERROR_);
                this.fHostnameField.setFocus();
                bSuccess = false;
            }
            this.fUserID = this.fUserIDField.getText();
            this.fPassword = this.fPasswordField.getText();
            this.fSavePassword = this.fSavePassordButton.getSelection();
            if (this.fFirewallGeneral.getSelection()) {
                this.fType = 0;
            } else if (this.fFirewallSite.getSelection()) {
                this.fType = 1;
            } else if (this.fFirewallUserNoLogon.getSelection()) {
                this.fType = 2;
            } else if (this.fFirewallUser.getSelection()) {
                this.fType = 3;
            } else if (this.fFirewallOpen.getSelection()) {
                this.fType = 4;
            }
            if (bSuccess) {
                this.fHostname = proxyServer;
                this.fUseSocks = false;
                super.okPressed();
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        Widget source = event.widget;
        if (source == this.fUseSocksButton || source == this.fUseFtpProxyButton) {
            this.enableOrDisableOptions();
        }
    }

    public void widgetSelected(SelectionEvent event) {
        Widget source = event.widget;
        if (source == this.fUseSocksButton || source == this.fUseFtpProxyButton) {
            this.enableOrDisableOptions();
        }
    }
}

