/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iwt.ftpexport.core;

import com.ibm.etools.ftp.core.internal.PublishServerInfo;
import com.ibm.iwt.webtools.WebToolsPlugin;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;

public class FtpExportServerArchive
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Vector fFtpExportServerInfos = new Vector();
    private static final int NUMBER_OF_ENTRIES = 5;
    private static final String ARCHIVE_FILE_NAME = "FtpServers.ser";

    public void addFtpExportServerInfo(PublishServerInfo serverInfo) {
        PublishServerInfo curServerInfo = this.hasFtpExportServerInfo(serverInfo.getServerPath());
        if (curServerInfo == null) {
            while (this.fFtpExportServerInfos.size() >= 5) {
                this.fFtpExportServerInfos.removeElementAt(this.fFtpExportServerInfos.size() - 1);
            }
            this.fFtpExportServerInfos.insertElementAt(serverInfo, 0);
        } else {
            this.fFtpExportServerInfos.removeElement(curServerInfo);
            this.fFtpExportServerInfos.insertElementAt(serverInfo, 0);
        }
    }

    public Vector getFtpExportServerInfos() {
        return this.fFtpExportServerInfos;
    }

    public PublishServerInfo hasFtpExportServerInfo(String serverPath) {
        PublishServerInfo serverInfo = null;
        int i = 0;
        while (i < this.fFtpExportServerInfos.size() && serverInfo == null) {
            if (serverPath.equals(((PublishServerInfo)this.fFtpExportServerInfos.elementAt(i)).getServerPath())) {
                serverInfo = (PublishServerInfo)this.fFtpExportServerInfos.elementAt(i);
            }
            ++i;
        }
        return serverInfo;
    }

    public void load() throws IOException {
        String archiveFullPath = String.valueOf(WebToolsPlugin.getWebToolsPlugin().getStateLocation().toString()) + "\\" + ARCHIVE_FILE_NAME;
        FileInputStream istream = new FileInputStream(archiveFullPath);
        ObjectInputStream p = new ObjectInputStream(istream);
        try {
            this.fFtpExportServerInfos = (Vector)p.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {}
        istream.close();
    }

    public void save() throws IOException {
        String archiveFullPath = String.valueOf(WebToolsPlugin.getWebToolsPlugin().getStateLocation().toString()) + "\\" + ARCHIVE_FILE_NAME;
        FileOutputStream ostream = new FileOutputStream(archiveFullPath);
        ObjectOutputStream p = new ObjectOutputStream(ostream);
        p.writeObject(this.fFtpExportServerInfos);
        ostream.close();
    }
}

