/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iwt.crawler.wizards.http;

import com.ibm.etools.webtools.filetransfer.wizards.nls.ResourceHandler;
import com.ibm.iwt.crawler.wizards.http.HTTPCrawlerSession;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

class AdvancedSettingsDialog
extends Dialog
implements Listener {
    protected Button fUseFirewallButton;
    protected Combo fTypeCombo;
    protected Text fProxyServerField;
    protected Text fProxyServerPortField;
    protected Label fTypeLabel;
    protected Label fProxyServerLabel;
    protected Label fProxyServerPortLabel;
    protected boolean fUseFirewall = false;
    protected int fProxyType = HTTPCrawlerSession.HTTP_PROXY;
    protected String fProxyServer = null;
    protected int fProxyPort = 0;
    protected String title = ResourceHandler.Advanced_Settings_UI_;
    protected String SOCKS = "Socks";
    protected String PROXY = "Proxy";

    AdvancedSettingsDialog(Shell shell) {
        super(shell);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    public Control createDialogArea(Composite parent) {
        this.getShell().setText(ResourceHandler.Advanced_Settings_UI_);
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        panel.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        panel.setLayoutData((Object)data);
        this.fUseFirewallButton = new Button(panel, 32);
        this.fUseFirewallButton.setText(ResourceHandler.Use_Proxy_for_connection_UI_);
        this.fUseFirewallButton.addListener(13, (Listener)this);
        Composite proxySocksGroup = new Composite(panel, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        proxySocksGroup.setLayout((Layout)layout);
        data = new GridData(272);
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        proxySocksGroup.setLayoutData((Object)data);
        this.fTypeLabel = new Label(proxySocksGroup, 0);
        this.fTypeLabel.setText(ResourceHandler.Type__3);
        this.fTypeCombo = new Combo(proxySocksGroup, 8);
        this.fTypeCombo.add(this.PROXY);
        this.fTypeCombo.add(this.SOCKS);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.widthHint = 250;
        this.fTypeCombo.setLayoutData((Object)data);
        this.fTypeCombo.addListener(13, (Listener)this);
        this.fProxyServerLabel = new Label(proxySocksGroup, 0);
        this.fProxyServerLabel.setText(ResourceHandler.Address__4);
        this.fProxyServerField = new Text(proxySocksGroup, 2052);
        if (this.fProxyServer != null) {
            this.fProxyServerField.setText(this.fProxyServer);
        }
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.widthHint = 250;
        this.fProxyServerField.setLayoutData((Object)data);
        this.fProxyServerField.addListener(24, (Listener)this);
        this.fProxyServerPortLabel = new Label(proxySocksGroup, 0);
        this.fProxyServerPortLabel.setText(ResourceHandler.Port__UI_);
        this.fProxyServerPortField = new Text(proxySocksGroup, 2052);
        if (this.fProxyPort > 0) {
            this.fProxyServerPortField.setText(new Integer(this.fProxyPort).toString());
        }
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.widthHint = 250;
        this.fProxyServerPortField.setLayoutData((Object)data);
        this.fProxyServerPortField.addListener(24, (Listener)this);
        if (this.fUseFirewall) {
            this.fUseFirewallButton.setSelection(true);
        }
        if (this.fProxyType > 0) {
            if (this.fProxyType == HTTPCrawlerSession.HTTP_PROXY) {
                this.fTypeCombo.select(0);
            } else if (this.fProxyType == HTTPCrawlerSession.SOCKS_PROXY) {
                this.fTypeCombo.select(1);
            }
        }
        this.handleUseFirewall();
        return panel;
    }

    int getProxyPort() {
        return this.fProxyPort;
    }

    String getProxyServer() {
        return this.fProxyServer;
    }

    int getProxyType() {
        return this.fProxyType;
    }

    public void handleEvent(Event e) {
        Widget source = e.widget;
        if (source == this.fUseFirewallButton) {
            this.handleUseFirewall();
        }
        if (this.fUseFirewall) {
            this.fProxyServer = this.fProxyServerField.getText();
            if (this.fTypeCombo.getSelectionIndex() >= 0 && this.fProxyServer != null && this.fProxyServer.length() > 0) {
                this.getButton(0).setEnabled(true);
            } else {
                this.getButton(0).setEnabled(false);
            }
        } else {
            this.getButton(0).setEnabled(true);
        }
    }

    private void handleUseFirewall() {
        this.fUseFirewall = false;
        if (this.fUseFirewallButton.getSelection()) {
            this.fUseFirewall = true;
        }
        this.fTypeCombo.setEnabled(this.fUseFirewall);
        this.fProxyServerField.setEnabled(this.fUseFirewall);
        this.fProxyServerPortField.setEnabled(this.fUseFirewall);
        this.fTypeLabel.setEnabled(this.fUseFirewall);
        this.fProxyServerLabel.setEnabled(this.fUseFirewall);
        this.fProxyServerPortLabel.setEnabled(this.fUseFirewall);
    }

    boolean isUseFirewall() {
        return this.fUseFirewall;
    }

    protected void okPressed() {
        boolean bSuccess = true;
        this.fUseFirewall = this.fUseFirewallButton.getSelection();
        String proxyServer = "";
        String strPort = "";
        int proxyPort = 0;
        proxyServer = this.fProxyServerField.getText();
        strPort = this.fProxyServerPortField.getText();
        proxyServer = proxyServer.trim();
        strPort = strPort.trim();
        boolean bPortValid = true;
        boolean bProxyValid = true;
        if (strPort.length() > 0) {
            try {
                proxyPort = new Integer(this.fProxyServerPortField.getText());
                if (proxyPort <= 0 || proxyPort > 65535) {
                    bPortValid = false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                bPortValid = false;
            }
        }
        if (proxyServer.length() > 0 && strPort.length() == 0) {
            bPortValid = false;
        }
        if (strPort.length() > 0 && proxyServer.length() == 0) {
            bProxyValid = false;
        }
        if (!bPortValid && this.fUseFirewall) {
            MessageDialog.openError((Shell)this.getShell(), (String)ResourceHandler.Error_UI_, (String)ResourceHandler.Specify_a_valid_port__ERROR_);
            this.fProxyServerPortField.setFocus();
            bSuccess = false;
        } else if (!bProxyValid && this.fUseFirewall) {
            MessageDialog.openError((Shell)this.getShell(), (String)ResourceHandler.Error_UI_, (String)ResourceHandler.Specify_a_proxy_server__ERROR_);
            this.fProxyServerField.setFocus();
            bSuccess = false;
        }
        if (bSuccess) {
            this.fProxyType = this.fTypeCombo.getSelectionIndex() == 0 ? HTTPCrawlerSession.HTTP_PROXY : HTTPCrawlerSession.SOCKS_PROXY;
            this.fProxyPort = proxyPort;
            this.fProxyServer = proxyServer;
            super.okPressed();
        }
    }

    void setProxyPort(int newProxyPort) {
        this.fProxyPort = newProxyPort;
    }

    void setProxyServer(String newProxyServer) {
        this.fProxyServer = newProxyServer;
    }

    void setProxyType(int proxyType) {
        this.fProxyType = proxyType;
    }

    void setUseFirewall(boolean newUseFirewall) {
        this.fUseFirewall = newUseFirewall;
    }
}

