/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iwt.crawler.wizards.ftp;

import com.ibm.etools.ftp.core.internal.FtpFirewall;
import com.ibm.etools.ftp.core.internal.PasswordEncrypt;
import com.ibm.etools.ftp.ui.internal.ViewerItemList;
import com.ibm.etools.webtools.filetransfer.wizards.nls.ResourceHandler;
import com.ibm.iwt.crawler.common.CommonUtil;
import com.ibm.iwt.crawler.common.IURI;
import com.ibm.iwt.crawler.common.URI;
import com.ibm.iwt.crawler.ftp.FTPConnectionParams;
import com.ibm.iwt.crawler.ftp.FTPURL;
import com.ibm.iwt.crawler.wizards.ftp.FTPCrawlerSession;
import com.ibm.iwt.crawler.wizards.ftp.FTPImportOperation;
import com.ibm.iwt.crawler.wizards.ftp.FTPImportPage2;
import com.ibm.iwt.crawler.wizards.ftp.ViewerItem;
import com.ibm.iwt.crawler.wizards.ftp.ViewerItemCellModifier;
import com.ibm.iwt.ftpexport.wizards.FirewallDialog;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.IOverwriteQuery;

class FTPImportPage1
extends WizardPage
implements ISelectionChangedListener,
Listener,
IOverwriteQuery {
    private IResource fCurrentResourceSelection = null;
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private static final int SIZING_TEXT_FIELD_WIDTH_SHORT = 100;
    private static final int COMBO_HISTORY_LENGTH = 5;
    private static final String FTP_PREFIX = "ftp://";
    private static final String FTP_PROTOCOL = "ftp";
    private static final String idStartingUrl = "FTPImportPage1.StartingUrl";
    private static final String idStartingFolder = "FTPImportPage1.StartingFolder";
    private static final String idExcludedHostNames = "FTPImportPage1.ExcludedHostNames";
    private static final String idNoDepthLimitRadio = "FTPImportPage2.NoDepthLimitRadio";
    private static final String idDepthValue = "FTPImportPage2.DepthValue";
    private static final String idPasvModeCheckBox = "FTPImportPage2.PasvModeCheckBox";
    private static final String idFtpLoginField = "FTPImportPage2.FtpLoginField";
    private static final String idFtpPasswordField = "FTPImportPage2.FtpPasswordField";
    private static final String idUseFirewallCheckbox = "FTPImportPage1.UseFirewallCheckbox";
    private static final String idFirewallSettings = "FTPImportPage1.FirewallSettings";
    private static final String idFirewallUseSocks = "FTPImportPage1.FirewallUseSocks";
    private static final String idFirewallSocksHostName = "FTPImportPage1.FirewallSocksHostName";
    private static final String idFirewallSocksPort = "FTPImportPage1.FirewallSocksPort";
    private static final String idFirewallHostName = "FTPImportPage1.FirewallData.fHostName";
    private static final String idFirewallPassword = "FTPImportPage1.FirewallData.fPassword";
    private static final String idFirewallPort = "FTPImportPage1.FirewallData.fPort";
    private static final String idFirewallSavePassword = "FTPImportPage1.FirewallData.fSavePassword";
    private static final String idFirewallType = "FTPImportPage1.FirewallData.fType";
    private static final String idFirewallUserID = "FTPImportPage1.FirewallData.fUserID";
    protected TableViewer fEFolderTable;
    private Combo fStartHostField;
    private Combo fStartFolderField;
    private Button fContainerBrowseButton;
    private Text fContainerNameField;
    private Button fAddButton;
    private Button fDeleteButton;
    private Button fNoDepthLimitRadio;
    private Button fLimitToRadio;
    private Text fDepthField;
    private Text fFtpLoginField;
    private Text fFtpPasswordField;
    private Button fPasvModeCheckBox;
    private Button fUseFirewallCheckbox;
    private Button fFirewallSettings;
    private FTPImportPage2 fImportPage2 = null;
    private FTPCrawlerSession fCrawlerSession = null;
    private FtpFirewall fFirewallData;

    public FTPImportPage1(IStructuredSelection selection) {
        super("ftpImportPage1");
        this.setTitle(ResourceHandler.FTP_Import_1);
        this.setDescription(ResourceHandler.FTPImportDesc);
        this.fCurrentResourceSelection = null;
        Iterator iter = selection.iterator();
        if (iter.hasNext()) {
            this.fCurrentResourceSelection = (IResource)iter.next();
        }
        if (this.fCurrentResourceSelection != null) {
            if (this.fCurrentResourceSelection.getType() == 1) {
                this.fCurrentResourceSelection = this.fCurrentResourceSelection.getParent();
            }
            if (!this.fCurrentResourceSelection.isAccessible()) {
                this.fCurrentResourceSelection = null;
            }
        }
    }

    protected String[] addToHistory(String[] history, String newEntry) {
        ArrayList<String> l = new ArrayList<String>(Arrays.asList(history));
        this.addToHistory(l, newEntry);
        String[] r = new String[l.size()];
        l.toArray(r);
        return r;
    }

    protected void addToHistory(List history, String newEntry) {
        history.remove(newEntry);
        history.add(0, newEntry);
        if (history.size() > 5) {
            history.remove(5);
        }
    }

    private Button createCheckbox(Composite parent, String text) {
        Button button = new Button(parent, 32);
        button.setText(text);
        button.addListener(13, (Listener)this);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)data);
        return button;
    }

    public void createControl(Composite parent) {
        Composite shell = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.numColumns = 3;
        shell.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        shell.setLayoutData((Object)data);
        Label containerLabel = new Label(shell, 0);
        containerLabel.setText(ResourceHandler.Container__UI_);
        data = new GridData();
        data.horizontalAlignment = 1;
        containerLabel.setLayoutData((Object)data);
        this.fContainerNameField = new Text(shell, 2052);
        this.fContainerNameField.addListener(24, (Listener)this);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.widthHint = 250;
        this.fContainerNameField.setLayoutData((Object)data);
        this.fContainerBrowseButton = new Button(shell, 8);
        this.fContainerBrowseButton.setText(ResourceHandler.Browse____UI_);
        this.fContainerBrowseButton.addListener(13, (Listener)this);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.fContainerBrowseButton.setLayoutData((Object)data);
        Label startUrlLabel = new Label(shell, 0);
        startUrlLabel.setText(ResourceHandler.FTP_URL_HOST__UI_);
        data = new GridData();
        data.horizontalAlignment = 1;
        startUrlLabel.setLayoutData((Object)data);
        this.fStartHostField = new Combo(shell, 2048);
        this.fStartHostField.addListener(24, (Listener)this);
        this.fStartHostField.addListener(13, (Listener)this);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.widthHint = 250;
        this.fStartHostField.setLayoutData((Object)data);
        this.createHorizontalFiller(shell, 1);
        Label startUrlFolderLabel = new Label(shell, 0);
        startUrlFolderLabel.setText(ResourceHandler.FTP_URL_FOLDER__UI_);
        data = new GridData();
        data.horizontalAlignment = 1;
        startUrlFolderLabel.setLayoutData((Object)data);
        this.fStartFolderField = new Combo(shell, 2048);
        this.fStartFolderField.addListener(24, (Listener)this);
        this.fStartFolderField.addListener(13, (Listener)this);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.widthHint = 250;
        this.fStartFolderField.setLayoutData((Object)data);
        this.createHorizontalFiller(shell, 1);
        Label ftpLoginIdLabel = new Label(shell, 0);
        ftpLoginIdLabel.setText(ResourceHandler.FTP_Login__UI_);
        data = new GridData();
        data.horizontalAlignment = 1;
        ftpLoginIdLabel.setLayoutData((Object)data);
        this.fFtpLoginField = new Text(shell, 2048);
        this.fFtpLoginField.addListener(24, (Listener)this);
        this.fFtpLoginField.setText("anonymous");
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = false;
        data.widthHint = 100;
        this.fFtpLoginField.setLayoutData((Object)data);
        this.createHorizontalFiller(shell, 1);
        Label ftpPasswordIdLabel = new Label(shell, 0);
        ftpPasswordIdLabel.setText(ResourceHandler.Password_UI_);
        data = new GridData();
        data.horizontalAlignment = 1;
        ftpPasswordIdLabel.setLayoutData((Object)data);
        this.fFtpPasswordField = new Text(shell, 2048);
        this.fFtpPasswordField.setText("");
        this.fFtpPasswordField.addListener(24, (Listener)this);
        this.fFtpPasswordField.setEchoChar('*');
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = false;
        data.widthHint = 100;
        this.fFtpPasswordField.setLayoutData((Object)data);
        this.createHorizontalFiller(shell, 1);
        Group group = this.createGroup(shell, 2, ResourceHandler.FTP_Options_UI_);
        GridData gd = (GridData)group.getLayoutData();
        gd.horizontalSpan = 3;
        this.fPasvModeCheckBox = this.createCheckbox((Composite)group, ResourceHandler.Use_PASV_Mode__Passive_Mod_UI_);
        gd = (GridData)this.fPasvModeCheckBox.getLayoutData();
        gd.horizontalIndent = 4;
        this.createHorizontalFiller((Composite)group, 1);
        this.fUseFirewallCheckbox = this.createCheckbox((Composite)group, ResourceHandler.Use_Firewall_UI_);
        gd = (GridData)this.fUseFirewallCheckbox.getLayoutData();
        gd.horizontalIndent = 4;
        this.fFirewallSettings = new Button((Composite)group, 8);
        this.fFirewallSettings.setText(ResourceHandler.Settings____UI_);
        this.fFirewallSettings.addListener(13, (Listener)this);
        this.fFirewallSettings.setEnabled(false);
        this.createExcludedFolderListGroup(shell);
        Composite depthGroup = new Composite(shell, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.numColumns = 2;
        depthGroup.setLayout((Layout)layout);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = 3;
        depthGroup.setLayoutData((Object)data);
        Label depthCaptionLabel = new Label(depthGroup, 0);
        depthCaptionLabel.setText(ResourceHandler.Depth_limit_when_following1_UI_);
        data = new GridData();
        data.horizontalAlignment = 1;
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = 2;
        depthCaptionLabel.setLayoutData((Object)data);
        this.fNoDepthLimitRadio = new Button(depthGroup, 16);
        this.fNoDepthLimitRadio.setText(ResourceHandler.No_limit_UI_);
        this.fNoDepthLimitRadio.addListener(13, (Listener)this);
        data = new GridData();
        data.horizontalAlignment = 1;
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = 2;
        this.fNoDepthLimitRadio.setLayoutData((Object)data);
        this.fLimitToRadio = new Button(depthGroup, 16);
        this.fLimitToRadio.setText(ResourceHandler.Limit_to__UI_);
        this.fLimitToRadio.addListener(13, (Listener)this);
        this.fDepthField = new Text(depthGroup, 2052);
        this.fDepthField.addListener(24, (Listener)this);
        data = new GridData();
        data.horizontalAlignment = 1;
        data.grabExcessHorizontalSpace = false;
        data.widthHint = 30;
        this.fDepthField.setLayoutData((Object)data);
        this.fStartHostField.setFocus();
        this.restoreWidgetValues();
        if (this.fCurrentResourceSelection != null) {
            String containerPath = this.fCurrentResourceSelection.getFullPath().makeRelative().toString();
            this.fContainerNameField.setText(containerPath);
        }
        this.setPageComplete(this.determinePageCompletion(true));
        this.setErrorMessage(null);
        this.setControl((Control)shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "com.ibm.etools.webtools.filetransfer.wizards.impw0002");
    }

    private Composite createExcludedFolderListGroup(Composite shell) {
        Label domainListLabel = new Label(shell, 0);
        domainListLabel.setText(String.valueOf(ResourceHandler.List_of_folders_to_be_excl_UI_) + " " + ResourceHandler._for_example___software_su_UI_);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = 3;
        domainListLabel.setLayoutData((Object)data);
        this.fEFolderTable = new TableViewer(new Table(shell, 101120));
        TableColumn tc = new TableColumn(this.fEFolderTable.getTable(), 0, 0);
        tc.setText(ResourceHandler.Folder_UI_);
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, false));
        this.fEFolderTable.getTable().setLayout((Layout)tlayout);
        data = new GridData(1808);
        data.heightHint = 40;
        data.verticalSpan = 2;
        data.horizontalSpan = 2;
        this.fEFolderTable.getTable().setLayoutData((Object)data);
        this.fEFolderTable.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object element) {
                if (element instanceof ViewerItemList) {
                    return ((ViewerItemList)element).getArray();
                }
                return new Object[0];
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.fEFolderTable.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                return ((ViewerItem)element).getValue().toString();
            }
        });
        this.fEFolderTable.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)this.fEFolderTable.getTable())});
        this.fEFolderTable.setCellModifier((ICellModifier)new ViewerItemCellModifier(){

            @Override
            public void modify(Object element, String property, Object value) {
                super.modify(element, property, value);
                FTPImportPage1.this.fEFolderTable.refresh();
            }
        });
        this.fEFolderTable.setColumnProperties(new String[]{ResourceHandler.folder_UI_});
        ViewerItemList hostList = new ViewerItemList(this.fEFolderTable);
        this.fEFolderTable.setInput((Object)hostList);
        this.fEFolderTable.addSelectionChangedListener((ISelectionChangedListener)this);
        this.fEFolderTable.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)this.fEFolderTable.getTable())});
        this.fAddButton = new Button(shell, 0x1000008);
        this.fAddButton.setText(ResourceHandler.Add_UI_);
        this.fAddButton.addListener(13, (Listener)this);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        data.grabExcessHorizontalSpace = true;
        this.fAddButton.setLayoutData((Object)data);
        this.fDeleteButton = new Button(shell, 0x1000008);
        this.fDeleteButton.setText(ResourceHandler.Delete_UI_);
        this.fDeleteButton.addListener(13, (Listener)this);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        data.grabExcessHorizontalSpace = true;
        this.fDeleteButton.setLayoutData((Object)data);
        return shell;
    }

    private Group createGroup(Composite parent, int numColumns, String text) {
        Group group = new Group(parent, 16);
        group.setText(text);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.numColumns = numColumns;
        group.setLayout((Layout)layout);
        return group;
    }

    private Label createHorizontalFiller(Composite parent, int horizontalSpan) {
        Label label = new Label(parent, 16384);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = horizontalSpan;
        label.setLayoutData((Object)data);
        return label;
    }

    protected boolean determinePageCompletion(boolean changeFocus) {
        this.setErrorMessage(null);
        if (this.getSeedUrl() == null) {
            if (this.fStartHostField.getText().length() == 0) {
                this.setErrorMessage(ResourceHandler.Specify_FTP_Server_URL__UI_);
            } else {
                this.setErrorMessage(ResourceHandler.Invalid_FTP_Server_URL__UI_);
            }
            if (changeFocus) {
                this.fStartHostField.setFocus();
            }
            return false;
        }
        try {
            CommonUtil.validateDepth(this.fDepthField.getText(), this.fNoDepthLimitRadio.getSelection());
        }
        catch (NumberFormatException numberFormatException) {
            this.setErrorMessage(ResourceHandler.Invalid_Depth_Value__EXC_);
            return false;
        }
        if (this.fUseFirewallCheckbox.getSelection() && (this.fFirewallData == null || this.fFirewallData.getHostname().equals(""))) {
            this.setMessage(ResourceHandler.FTPImportPage1_specify_firewall_hostname, 2);
            return false;
        }
        IResource resource = this.getSpecifiedContainer();
        if (resource != null) {
            IProject targetProject = resource.getProject();
            if (targetProject == null) {
                this.setErrorMessage(ResourceHandler.Specify_a_valid_container__UI_);
                if (changeFocus) {
                    this.fContainerNameField.setFocus();
                }
                return false;
            }
        } else {
            this.setErrorMessage(ResourceHandler.Invalid_container__UI_);
            return false;
        }
        this.setMessage(null);
        return true;
    }

    private boolean ensureParamsAreValid() {
        if (this.getSeedUrl() == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)ResourceHandler.Error_UI_, (String)ResourceHandler.Starting_url_specified_is__ERROR_);
            this.fStartHostField.setFocus();
            return false;
        }
        try {
            CommonUtil.validateDepth(this.fDepthField.getText(), this.fNoDepthLimitRadio.getSelection());
        }
        catch (NumberFormatException numberFormatException) {
            MessageDialog.openError((Shell)this.getShell(), (String)ResourceHandler.Error_UI_, (String)ResourceHandler.Specify_a_valid_depth_valu_ERROR_);
            this.fDepthField.setFocus();
            return false;
        }
        return true;
    }

    private boolean executeImportOperation(FTPImportOperation op, IResource targetResource) {
        String errorMessage;
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)ResourceHandler.Import_Problems_UI_, (String)e.toString());
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        if (this.fCrawlerSession.getNoOfFilesImported() == 0 && (errorMessage = op.getErrorString()) != null && errorMessage.length() > 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)ResourceHandler.Import_Error_UI_, (String)errorMessage);
            return false;
        }
        return true;
    }

    public boolean finish() {
        if (!this.ensureParamsAreValid()) {
            return false;
        }
        if (!this.fImportPage2.populateValues()) {
            return false;
        }
        this.saveWidgetValues();
        this.fImportPage2.saveWidgetValues();
        IResource container = this.getSpecifiedContainer();
        this.fCrawlerSession = new FTPCrawlerSession(container.getProject());
        this.fCrawlerSession.setLocalFolder((IContainer)container);
        FTPConnectionParams ftpParms = new FTPConnectionParams();
        FTPURL ftpUrl = this.getSeedUrl();
        this.fCrawlerSession.setSeedUrl(ftpUrl.getURL().toExternalForm());
        ftpParms.setHostUrl(ftpUrl);
        ftpParms.setUserName(this.fFtpLoginField.getText());
        ftpParms.setPassword(this.fFtpPasswordField.getText());
        ftpParms.setPasvMode(this.fPasvModeCheckBox.getSelection());
        ftpParms.setFirewallData(this.fFirewallData);
        ftpParms.setUseFirewall(this.fUseFirewallCheckbox.getSelection());
        this.fCrawlerSession.setFtpConnectionParams(ftpParms);
        ViewerItemList folders = (ViewerItemList)this.fEFolderTable.getInput();
        String preFix = ftpUrl.getURL().getFile();
        if (preFix != null) {
            if (preFix.endsWith("/")) {
                preFix = preFix.substring(0, preFix.length() - 1);
            }
            if (preFix.length() == 0) {
                preFix = null;
            }
        }
        if (folders != null) {
            Iterator iter = folders.iterator();
            while (iter.hasNext()) {
                String exclude = ((String)((ViewerItem)iter.next()).getValue()).trim();
                if (preFix != null) {
                    exclude = !exclude.startsWith("/") ? String.valueOf(preFix) + '/' + exclude : String.valueOf(preFix) + exclude;
                }
                this.fCrawlerSession.addExcludedFolder(exclude);
            }
        }
        int depth = -1;
        try {
            depth = CommonUtil.validateDepth(this.fDepthField.getText(), this.fNoDepthLimitRadio.getSelection());
        }
        catch (Exception exception) {
            return false;
        }
        this.fCrawlerSession.setDepth(depth);
        this.fCrawlerSession.setPromptWhenOverwritingFile(this.fImportPage2.isPromptForOverwriting());
        this.fCrawlerSession.setFixLinks(this.fImportPage2.isFixLinks());
        this.fCrawlerSession.setLinkStyle(0);
        this.fCrawlerSession.setBuildProject(false);
        this.fCrawlerSession.setCreateCorrespondingContainerStructure(this.fImportPage2.isCreateCorrespondingContainerStructure());
        this.fCrawlerSession.setConnectionTimeout(this.fImportPage2.getConnecionTimeout());
        return this.executeImportOperation(new FTPImportOperation(container, this.fCrawlerSession, this), container);
    }

    private FTPURL getSeedUrl() {
        URL url = null;
        String rawString1 = this.fStartHostField.getText().trim();
        rawString1.trim();
        if (rawString1.length() == 0) {
            return null;
        }
        boolean absolute = false;
        String rawString2 = this.fStartFolderField.getText().trim();
        rawString2.trim();
        if (rawString2.length() > 0 && (rawString2.startsWith("/") || rawString2.startsWith("\\"))) {
            absolute = true;
        }
        if (rawString1.endsWith("/") && rawString2.startsWith("/")) {
            rawString1 = rawString1.substring(0, rawString1.length() - 2);
        }
        if (!rawString1.endsWith("/") && !rawString2.startsWith("/")) {
            rawString1 = String.valueOf(rawString1) + "/";
        }
        String wholeString = String.valueOf(rawString1) + rawString2;
        try {
            url = new URL(wholeString);
        }
        catch (MalformedURLException malformedURLException) {
            wholeString = FTP_PREFIX + wholeString;
            try {
                url = new URL(wholeString);
            }
            catch (MalformedURLException malformedURLException2) {}
        }
        if (url != null) {
            if (url.getProtocol() != null && !url.getProtocol().equalsIgnoreCase(FTP_PROTOCOL)) {
                url = null;
            }
            if (url != null && url.getHost() != null && url.getHost().length() == 0) {
                url = null;
            }
        }
        if (url != null) {
            IURI uri;
            String urlString = url.toExternalForm();
            if (url.getFile() != null && url.getFile().length() == 0) {
                urlString = String.valueOf(urlString) + "/";
            }
            if ((uri = new URI(urlString)).getFileExtension() != null) {
                uri = uri.removeLastPathSegments(1);
                try {
                    url = new URL(uri.toString());
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }
        return new FTPURL(url, absolute);
    }

    private IResource getSpecifiedContainer() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String pathString = this.fContainerNameField.getText().trim();
        IStatus result = workspace.validatePath(pathString = new Path(pathString).makeAbsolute().toString(), 7);
        if (result.isOK()) {
            Path path = new Path(pathString);
            if (workspace.getRoot().exists((IPath)path)) {
                return workspace.getRoot().findMember((IPath)path);
            }
        }
        return null;
    }

    private void handleAddEFolder() {
        this.fEFolderTable.cancelEditing();
        ViewerItemList input = (ViewerItemList)this.fEFolderTable.getInput();
        ViewerItem newItem = new ViewerItem((StructuredViewer)this.fEFolderTable, ResourceHandler.seed_Folder);
        input.add((Object)newItem);
        this.fEFolderTable.getTable().setFocus();
        this.fEFolderTable.editElement((Object)newItem, 0);
    }

    private void handleContainerBrowseButtonPressed() {
        IResource container = this.getSpecifiedContainer();
        if (container != null && container.getType() == 1) {
            container = container.getParent();
        }
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)container, false, ResourceHandler.Select_a_container_to_impo_UI_);
        dialog.setBlockOnOpen(true);
        dialog.create();
        dialog.open();
        Object[] list = dialog.getResult();
        if (list != null && list.length > 0) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IPath path = (IPath)list[0];
            container = workspace.getRoot().findMember(path);
        }
        if (container != null) {
            String containerPath = container.getFullPath().makeRelative().toString();
            this.fContainerNameField.setText(containerPath);
            this.setPageComplete(this.determinePageCompletion(true));
        }
    }

    private void handleDeleteEFolder() {
        this.fEFolderTable.cancelEditing();
        IStructuredSelection selection = (IStructuredSelection)this.fEFolderTable.getSelection();
        ViewerItemList input = (ViewerItemList)this.fEFolderTable.getInput();
        for (Object host : selection) {
            input.remove(host);
        }
    }

    public void handleEvent(Event e) {
        Widget source = e.widget;
        if (source == this.fContainerBrowseButton) {
            this.handleContainerBrowseButtonPressed();
        } else if (source == this.fAddButton) {
            this.handleAddEFolder();
        } else if (source == this.fDeleteButton) {
            this.handleDeleteEFolder();
        } else if (source == this.fLimitToRadio || source == this.fNoDepthLimitRadio) {
            if (this.fLimitToRadio.getSelection()) {
                this.fDepthField.setEnabled(true);
            } else {
                this.fDepthField.setEnabled(false);
            }
        } else if (source.equals(this.fUseFirewallCheckbox)) {
            if (e.type == 13) {
                this.fFirewallSettings.setEnabled(this.fUseFirewallCheckbox.getSelection());
            }
        } else if (source.equals(this.fFirewallSettings) && e.type == 13) {
            this.handleFirewall();
        }
        if (source != this.fAddButton) {
            this.setPageComplete(this.determinePageCompletion(false));
        }
    }

    private void handleFirewall() {
        FirewallDialog firewallDlg = null;
        FtpFirewall tempFirewallData = this.fFirewallData;
        if (tempFirewallData == null) {
            tempFirewallData = new FtpFirewall();
            tempFirewallData.setUseSocks(true);
        }
        firewallDlg = new FirewallDialog(this.getShell(), tempFirewallData);
        firewallDlg.setBlockOnOpen(true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)firewallDlg.getShell(), "com.ibm.etools.webtools.filetransfer.wizards.impw00010");
        int rc = firewallDlg.open();
        if (rc == 0) {
            this.fFirewallData = new FtpFirewall();
            this.fFirewallData.setHostname(firewallDlg.getHostname());
            this.fFirewallData.setType(firewallDlg.getType());
            this.fFirewallData.setPort(firewallDlg.getPort());
            this.fFirewallData.setUserID(firewallDlg.getUserID());
            this.fFirewallData.setPassword(firewallDlg.getPassword());
            this.fFirewallData.setSavePassword(firewallDlg.getSavePassword());
            this.fFirewallData.setUseSocks(firewallDlg.getUseSocks());
            this.fFirewallData.setSocksHostName(firewallDlg.getSocksHostName());
            this.fFirewallData.setSocksPort(firewallDlg.getSocksPort());
        }
    }

    public String queryOverwrite(String pathString) {
        final String[] buttonStrings = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL};
        final String path = pathString;
        final int[] ret = new int[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog dialog = new MessageDialog(FTPImportPage1.this.getShell(), ResourceHandler.Question_UI_, null, NLS.bind((String)ResourceHandler.resource_already_exists_WARN_, (Object[])new Object[]{path}), 3, buttonStrings, 1);
                dialog.setBlockOnOpen(true);
                dialog.create();
                ret[0] = dialog.open();
            }
        });
        return this.delocalize(buttonStrings[ret[0]]);
    }

    protected String delocalize(String localizedStr) {
        if (localizedStr.equals(IDialogConstants.YES_LABEL)) {
            return "YES";
        }
        if (localizedStr.equals(IDialogConstants.NO_LABEL)) {
            return "NO";
        }
        if (localizedStr.equals(IDialogConstants.YES_TO_ALL_LABEL)) {
            return "ALL";
        }
        if (localizedStr.equals(IDialogConstants.CANCEL_LABEL)) {
            return "CANCEL";
        }
        return localizedStr;
    }

    private void restoreIncludedHosts(String[] excludedFolders) {
        ViewerItemList input = (ViewerItemList)this.fEFolderTable.getInput();
        int i = 0;
        while (i < excludedFolders.length) {
            input.add((Object)new ViewerItem((StructuredViewer)this.fEFolderTable, excludedFolders[i]));
            ++i;
        }
        this.fEFolderTable.refresh();
    }

    private void restoreWidgetValues() {
        IDialogSettings store = this.getDialogSettings();
        String[] startingUrls = null;
        if (store != null) {
            startingUrls = store.getArray(idStartingUrl);
        }
        if (startingUrls != null && startingUrls.length > 0) {
            String[] excludedHosts;
            this.fStartHostField.setText(startingUrls[0]);
            int i = 0;
            while (i < startingUrls.length) {
                this.fStartHostField.add(startingUrls[i]);
                ++i;
            }
            String[] folders = store.getArray(idStartingFolder);
            if (folders != null && folders.length > 0) {
                this.fStartFolderField.setText(folders[0]);
                int i2 = 0;
                while (i2 < folders.length) {
                    this.fStartFolderField.add(folders[i2]);
                    ++i2;
                }
            }
            if ((excludedHosts = store.getArray(idExcludedHostNames)) != null && excludedHosts.length > 0) {
                this.restoreIncludedHosts(excludedHosts);
            }
            if (store.getBoolean(idNoDepthLimitRadio)) {
                this.fNoDepthLimitRadio.setSelection(true);
                this.fLimitToRadio.setSelection(false);
            } else {
                this.fLimitToRadio.setSelection(true);
                this.fNoDepthLimitRadio.setSelection(false);
            }
            try {
                this.fDepthField.setText(new Integer(store.get(idDepthValue)).toString());
            }
            catch (NumberFormatException numberFormatException) {}
            this.fPasvModeCheckBox.setSelection(store.getBoolean(idPasvModeCheckBox));
            this.fUseFirewallCheckbox.setSelection(store.getBoolean(idUseFirewallCheckbox));
            this.fFirewallSettings.setEnabled(store.getBoolean(idFirewallSettings));
            try {
                this.fFirewallData = new FtpFirewall();
                if (store.get(idFirewallHostName) != null) {
                    this.fFirewallData.setHostname(store.get(idFirewallHostName));
                }
                this.fFirewallData.setType(store.getInt(idFirewallType));
                this.fFirewallData.setPort(store.getInt(idFirewallPort));
                this.fFirewallData.setUserID(store.get(idFirewallUserID));
                this.fFirewallData.setPassword(PasswordEncrypt.decrypt((String)store.get(idFirewallPassword), (String)PasswordEncrypt.getDefaultKey()));
                this.fFirewallData.setSavePassword(store.getBoolean(idFirewallSavePassword));
                this.fFirewallData.setUseSocks(store.getBoolean(idFirewallUseSocks));
                this.fFirewallData.setSocksHostName(store.get(idFirewallSocksHostName));
                this.fFirewallData.setSocksPort(store.getInt(idFirewallSocksPort));
            }
            catch (NumberFormatException numberFormatException) {}
            this.fFtpLoginField.setText(store.get(idFtpLoginField));
            String password = store.get(idFtpPasswordField);
            if (password != null) {
                this.fFtpPasswordField.setText(PasswordEncrypt.decrypt((String)password, (String)PasswordEncrypt.getDefaultKey()));
            }
        } else {
            this.fStartHostField.setText("");
            this.fNoDepthLimitRadio.setSelection(true);
        }
        if (this.fLimitToRadio.getSelection()) {
            this.fDepthField.setEnabled(true);
        } else {
            this.fDepthField.setEnabled(false);
        }
        this.fDeleteButton.setEnabled(false);
    }

    protected void saveWidgetValues() {
        IDialogSettings store = this.getDialogSettings();
        if (store != null) {
            String[] startingUrls = store.getArray(idStartingUrl);
            if (startingUrls == null) {
                startingUrls = new String[]{};
            }
            startingUrls = this.addToHistory(startingUrls, this.fStartHostField.getText());
            store.put(idStartingUrl, startingUrls);
            String[] startingFolders = store.getArray(idStartingFolder);
            if (startingFolders == null) {
                startingFolders = new String[]{};
            }
            startingFolders = this.addToHistory(startingFolders, this.fStartFolderField.getText());
            store.put(idStartingFolder, startingFolders);
            store.put(idPasvModeCheckBox, this.fPasvModeCheckBox.getSelection());
            store.put(idUseFirewallCheckbox, this.fUseFirewallCheckbox.getSelection());
            store.put(idFirewallSettings, this.fUseFirewallCheckbox.getSelection());
            if (this.fFirewallData != null) {
                store.put(idFirewallUseSocks, this.fFirewallData.getUseSocks());
                store.put(idFirewallSocksHostName, this.fFirewallData.getSocksHostName());
                store.put(idFirewallSocksPort, this.fFirewallData.getSocksPort());
                store.put(idFirewallHostName, this.fFirewallData.getHostname());
                store.put(idFirewallPassword, PasswordEncrypt.encrypt((String)this.fFirewallData.getPassword(), (String)PasswordEncrypt.getDefaultKey()));
                store.put(idFirewallUserID, this.fFirewallData.getUserID());
                store.put(idFirewallSavePassword, this.fFirewallData.getSavePassword());
                store.put(idFirewallPort, this.fFirewallData.getPort());
                store.put(idFirewallType, this.fFirewallData.getType());
            }
            ViewerItemList folders = (ViewerItemList)this.fEFolderTable.getInput();
            String[] folderStrings = new String[folders.size()];
            if (folders != null) {
                int i = 0;
                while (i < folders.size()) {
                    folderStrings[i] = (String)((ViewerItem)folders.get(i)).getValue();
                    ++i;
                }
                store.put(idExcludedHostNames, folderStrings);
            }
            store.put(idNoDepthLimitRadio, this.fNoDepthLimitRadio.getSelection());
            store.put(idDepthValue, this.fDepthField.getText());
            store.put(idFtpLoginField, this.fFtpLoginField.getText());
            String password = PasswordEncrypt.encrypt((String)this.fFtpPasswordField.getText(), (String)PasswordEncrypt.getDefaultKey());
            store.put(idFtpPasswordField, password);
            store.put(idPasvModeCheckBox, this.fPasvModeCheckBox.getSelection());
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection;
        if (event.getSource() == this.fEFolderTable && (selection = (IStructuredSelection)this.fEFolderTable.getSelection()).iterator().hasNext()) {
            this.fDeleteButton.setEnabled(true);
        }
    }

    public void setImportPage2(FTPImportPage2 newImportPage2) {
        this.fImportPage2 = newImportPage2;
    }
}

