/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iwt.crawler.http;

import com.ibm.etools.ftp.core.internal.UserCancelledException;
import com.ibm.etools.webtools.filetransfer.wizards.nls.ResourceHandler;
import com.ibm.iwt.crawler.common.Connection;
import com.ibm.iwt.crawler.http.HTTPCrawler;
import com.ibm.iwt.crawler.http.HTTPOutputStreamGenerator;
import com.ibm.iwt.crawler.http.HttpRequest;
import com.ibm.iwt.crawler.http.HttpResponse;
import com.ibm.iwt.crawler.http.MalformedHeaderException;
import com.ibm.iwt.crawler.http.MalformedStatusLineException;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import org.eclipse.swt.widgets.Display;

public class HttpRetrieverConnection
extends Connection {
    private Socket socket;
    public static final int RETRIEVE_FAILED = 4;
    public static final int REQUEST_SENT = 5;
    public static final int STATUS_RECEIVED = 6;
    public static final int HEADERS_RECEIVED = 7;
    public static final int BODY_RECEIVED = 8;
    public static final int RETRIEVER_STATE_BASE = 8;
    private final int BUFFER_LIMIT = 4096;
    private final int MAX_MEMORY_USAGE = 0x100000;
    protected HttpRequest request;
    protected HttpResponse response;
    private int fConnectionTimeout = 10000;
    private String fTempFolder = "";
    private HTTPOutputStreamGenerator ofsGenerator = null;
    protected int totalSize = 0;

    public HttpRetrieverConnection(Socket socket, HttpRequest request, int timeout) {
        this.socket = socket;
        this.request = request;
    }

    public int getConnectionTimeout() {
        return this.fConnectionTimeout;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public String getTempFolder() {
        return this.fTempFolder;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void perform() throws UserCancelledException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void readResponseBody(InputStream is) throws IOException, UserCancelledException {
        byte[] bytes = new byte[]{};
        boolean storeToTempFile = false;
        FilterOutputStream tempOutput = null;
        try {
            int size = 0;
            byte[] buffer = new byte[4096];
            while ((size = is.read(buffer, 0, 4096)) != -1) {
                if (this.fMonitor.isCanceled()) {
                    if (this.ofsGenerator != null) {
                        this.ofsGenerator.cancelStream(this.response);
                    }
                    if (tempOutput != null) {
                        tempOutput.close();
                    }
                    if (this.response.getOSTempDest() != null) {
                        this.response.getOSTempDest().delete();
                    }
                    throw new UserCancelledException();
                }
                if (!storeToTempFile && bytes.length + size <= 0x100000) {
                    byte[] temp = bytes;
                    bytes = new byte[size + bytes.length];
                    System.arraycopy(temp, 0, bytes, 0, temp.length);
                    System.arraycopy(buffer, 0, bytes, temp.length, size);
                } else {
                    storeToTempFile = true;
                    if (tempOutput == null) {
                        File tempStore = this.response.getOSTempDest();
                        if (tempStore == null) {
                            throw new IOException();
                        }
                        tempOutput = new BufferedOutputStream(new FileOutputStream(tempStore));
                        tempOutput.write(bytes);
                    }
                    ((BufferedOutputStream)tempOutput).write(buffer, 0, size);
                }
                this.totalSize += size;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        int percentage;
                        int length = HttpRetrieverConnection.this.response.getHeaders().getContentLength();
                        int n = percentage = length == 0 ? 100 : HttpRetrieverConnection.this.totalSize * 100 / length;
                        if (percentage < 0) {
                            percentage = 0;
                        } else if (percentage > 100) {
                            percentage = 100;
                        }
                        HttpRetrieverConnection.this.fMonitor.subTask("(" + percentage + "%) " + HttpRetrieverConnection.this.request.getURL().toExternalForm());
                    }
                });
            }
            if (tempOutput != null) {
                ((BufferedOutputStream)tempOutput).flush();
                tempOutput.close();
            }
        }
        catch (IOException e) {
            if (this.ofsGenerator != null) {
                this.ofsGenerator.cancelStream(this.response);
            }
            if (tempOutput != null) {
                try {
                    tempOutput.close();
                }
                catch (IOException iOException) {}
            }
            if (this.response.getOSTempDest() != null) {
                this.response.getOSTempDest().delete();
            }
            throw e;
        }
        if (storeToTempFile) {
            this.response.setBody(null);
        } else {
            this.response.setBody(new ByteArrayInputStream(bytes));
        }
    }

    protected void readResponseHeaders(InputStream is) throws IOException, MalformedHeaderException {
        String oneLine = new String();
        int thebyte = 0;
        boolean atEOL = false;
        while ((thebyte = is.read()) != -1) {
            char theChar = (char)thebyte;
            if (theChar != '\n') {
                oneLine = String.valueOf(oneLine) + theChar;
                if (!atEOL || theChar == '\r') continue;
                atEOL = false;
                continue;
            }
            if (atEOL) break;
            atEOL = true;
            this.response.getHeaders().addHeader(oneLine.trim());
            oneLine = new String();
        }
    }

    protected void readResponseStatusLine(InputStream is) throws IOException, MalformedStatusLineException {
        String statusLine = new String();
        int thebyte = 0;
        while ((thebyte = is.read()) != -1) {
            char theChar = (char)thebyte;
            if (theChar != '\n') {
                statusLine = String.valueOf(statusLine) + theChar;
                continue;
            }
            this.response.setStatus(statusLine.trim());
            break;
        }
        if (this.response.getStatusCode() == 403 || this.response.getStatusCode() == 401) {
            HTTPCrawler.setErrorString(ResourceHandler.The_URL_specified_is_passw_ERROR_);
        }
    }

    public void setConnectionTimeout(int newConnectionTimeout) {
        this.fConnectionTimeout = newConnectionTimeout;
    }

    public void setOSGenerator(HTTPOutputStreamGenerator osg) {
        this.ofsGenerator = osg;
    }

    public void setTempFolder(String newTempFolder) {
        this.fTempFolder = newTempFolder;
    }
}

