/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iwt.crawler.http;

import com.ibm.iwt.crawler.http.HttpHeaders;
import com.ibm.iwt.crawler.http.MalformedStatusLineException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;

public class HttpResponse {
    public static final int HTTP_STATUS_SUCCESS = 200;
    public static final int HTTP_STATUS_UNAUTHORIZED = 401;
    public static final int HTTP_STATUS_FORBIDDEN = 403;
    private int statusCode;
    private HttpHeaders headers = new HttpHeaders();
    private InputStream body = null;
    private FileInputStream bodyFileInputStream = null;
    private IFile finalOSDestination = null;
    private File tempOSDestination = null;
    private boolean abortFlag = false;

    public HttpResponse() {
    }

    public HttpResponse(String statusLine) throws MalformedStatusLineException {
        try {
            StringTokenizer st = new StringTokenizer(statusLine);
            String version = st.nextToken();
            if (!(version.length() == 8 && version.startsWith("HTTP/") && version.charAt(6) == '.' && Character.isDigit(version.charAt(5)) && Character.isDigit(version.charAt(7)))) {
                throw new MalformedStatusLineException(statusLine);
            }
            this.statusCode = Integer.parseInt(st.nextToken());
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new MalformedStatusLineException(statusLine);
        }
        catch (NumberFormatException numberFormatException) {
            throw new MalformedStatusLineException(statusLine);
        }
    }

    public void close() {
        try {
            if (this.body != null) {
                this.body.close();
            }
        }
        catch (IOException iOException) {}
    }

    public InputStream getBody() {
        if (this.body == null) {
            try {
                if (this.bodyFileInputStream != null) {
                    this.bodyFileInputStream.close();
                }
                this.bodyFileInputStream = new FileInputStream(this.tempOSDestination);
                return this.bodyFileInputStream;
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return this.body;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public IFile getOSFinalDest() {
        return this.finalOSDestination;
    }

    public File getOSTempDest() {
        return this.tempOSDestination;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public boolean isAbortFlag() {
        return this.abortFlag;
    }

    public InputStream resetBody() throws IOException {
        if (this.body instanceof ByteArrayInputStream) {
            this.body.reset();
        } else {
            this.body.close();
            this.body = new FileInputStream(this.tempOSDestination);
        }
        return this.body;
    }

    public void setAbortFlag(boolean flag) {
        this.abortFlag = flag;
    }

    public void setBody(InputStream body) {
        this.body = body;
    }

    public void setOSFinalDest(IFile path) {
        this.finalOSDestination = path;
    }

    public void setOSTempDest(File path) {
        this.tempOSDestination = path;
    }

    public void setStatus(String statusLine) throws MalformedStatusLineException {
        try {
            StringTokenizer st = new StringTokenizer(statusLine);
            String version = st.nextToken();
            if (!(version.length() == 8 && version.startsWith("HTTP/") && version.charAt(6) == '.' && Character.isDigit(version.charAt(5)) && Character.isDigit(version.charAt(7)))) {
                throw new MalformedStatusLineException(statusLine);
            }
            this.statusCode = Integer.parseInt(st.nextToken());
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new MalformedStatusLineException(statusLine);
        }
        catch (NumberFormatException numberFormatException) {
            throw new MalformedStatusLineException(statusLine);
        }
    }
}

