/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iwt.crawler.http;

import com.ibm.etools.ftp.core.internal.ResourceElement;
import com.ibm.iwt.crawler.http.HttpHeaders;
import java.net.URL;

public class HttpRequest {
    public static final String HTTP10 = "HTTP/1.0";
    public static final String HTTP11 = "HTTP/1.1";
    public static final String GET = "GET";
    public static final String POST = "POST";
    public static final String HEAD = "HEAD";
    public static final String USER_AGENT = "EC";
    public static final String NEWLINE = "\r\n";
    private ResourceElement url;
    private String protocol = "HTTP/1.0";
    private String method = "GET";
    private HttpHeaders headers = null;
    private byte[] body = null;
    private boolean isProxyRequest = false;
    private boolean fInterrupted;

    public HttpRequest(ResourceElement url) {
        this.url = url;
        this.headers = new HttpHeaders();
        this.headers.addHeader("User-Agent", USER_AGENT);
        this.headers.addHeader("Accept", "*/*");
        this.headers.addHeader("Host", url.getUrl().getHost());
    }

    public HttpRequest(ResourceElement url, HttpHeaders headers) {
        this(url);
        this.headers = headers;
    }

    public HttpRequest(ResourceElement url, HttpHeaders headers, String method, String protocol, byte[] body) {
        this(url, headers);
        this.method = method;
        this.protocol = protocol;
        this.body = body;
    }

    public byte[] getBody() {
        return this.body;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public String getMethod() {
        return this.method;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public byte[] getRequest() {
        byte[] requestLine = this.getRequestLine().getBytes();
        byte[] requestHeaders = this.getRequestHeaders().getBytes();
        byte[] request = new byte[requestLine.length + requestHeaders.length + (this.body != null ? this.body.length : 0)];
        System.arraycopy(requestLine, 0, request, 0, requestLine.length);
        System.arraycopy(requestHeaders, 0, request, requestLine.length, requestHeaders.length);
        if (this.body != null) {
            System.arraycopy(this.body, 0, request, requestLine.length + requestHeaders.length, this.body.length);
        }
        return request;
    }

    public String getRequestHeaders() {
        return this.headers != null ? this.headers.toString() : NEWLINE;
    }

    public String getRequestLine() {
        String requestURI = this.isProxyRequest ? this.url.getUrl().toString() : this.url.getUrl().getFile();
        return new String(String.valueOf(this.method) + " " + requestURI + " " + this.protocol + NEWLINE);
    }

    public ResourceElement getResourceElement() {
        return this.url;
    }

    public URL getURL() {
        return this.url.getUrl();
    }

    public boolean isInterrupted() {
        return this.fInterrupted;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public void setHeaders(HttpHeaders headers) {
        this.headers = headers;
    }

    public void setInterrupted(boolean newInterrupted) {
        this.fInterrupted = newInterrupted;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setUsingProxy() {
        this.isProxyRequest = true;
    }

    public String toString() {
        return this.url.getUrl().toString();
    }
}

