/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iwt.crawler.http;

import com.ibm.iwt.crawler.http.MalformedHeaderException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class HttpHeaders {
    Hashtable headers = new Hashtable();
    Hashtable canonicalHeaders = new Hashtable();

    public void addHeader(String header) throws MalformedHeaderException {
        try {
            int delimiter = header.indexOf(58);
            String name = header.substring(0, delimiter);
            String canonicalName = name.toLowerCase();
            String value = header.substring(delimiter + 1).trim();
            this.headers.put(name, value);
            this.canonicalHeaders.put(canonicalName, value);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new MalformedHeaderException(header);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new MalformedHeaderException(header);
        }
    }

    public void addHeader(String name, String value) {
        this.headers.put(name, value);
        this.canonicalHeaders.put(name.toLowerCase(), value);
    }

    public int getContentLength() {
        int contentLength = -1;
        String strLength = (String)this.canonicalHeaders.get("content-length");
        if (strLength != null && strLength.length() > 0) {
            contentLength = Integer.parseInt(strLength);
        }
        return contentLength;
    }

    public String getContentType() {
        return (String)this.canonicalHeaders.get("content-type");
    }

    public String getCharset() {
        StringTokenizer st;
        String charSetString;
        String contentType = this.getContentType();
        int i = contentType.indexOf(";");
        if (i >= 0 && (charSetString = contentType.substring(i + 1).trim()) != null && (st = new StringTokenizer(charSetString, "=")).nextToken().trim().equalsIgnoreCase("charset")) {
            return st.nextToken().trim();
        }
        return null;
    }

    public String getMimeType() {
        String contentType = this.getContentType();
        int i = contentType.indexOf(";");
        String mimetypeString = null;
        mimetypeString = i >= 0 ? contentType.substring(0, i).trim() : contentType;
        if (mimetypeString != null) {
            return mimetypeString.trim();
        }
        return null;
    }

    public String getHeader(String name) {
        return (String)this.canonicalHeaders.get(name.toLowerCase());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Enumeration e = this.headers.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            sb.append(String.valueOf(key) + ": " + (String)this.headers.get(key) + "\r\n");
        }
        sb.append("\r\n");
        return sb.toString();
    }
}

