/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iwt.crawler.http;

import com.ibm.etools.ftp.core.internal.UserCancelledException;
import com.ibm.etools.webtools.filetransfer.wizards.nls.ResourceHandler;
import com.ibm.iwt.crawler.common.Connection;
import com.ibm.iwt.crawler.common.ConnectionEvent;
import com.ibm.iwt.crawler.common.ConnectionListener;
import com.ibm.iwt.crawler.common.ConnectorFailureException;
import com.ibm.iwt.crawler.common.DebugInfo;
import com.ibm.iwt.crawler.http.ConnectorConnection;
import com.ibm.iwt.crawler.http.HTTPOutputStreamGenerator;
import com.ibm.iwt.crawler.http.HttpBodyListener;
import com.ibm.iwt.crawler.http.HttpHeadersListener;
import com.ibm.iwt.crawler.http.HttpRequest;
import com.ibm.iwt.crawler.http.HttpResponse;
import com.ibm.iwt.crawler.http.HttpRetrieverConnection;
import com.ibm.iwt.crawler.http.ResolverConnection;
import com.ibm.iwt.crawler.http.ResolverFailureException;
import com.ibm.iwt.crawler.http.RetrieverFailureException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.osgi.util.NLS;

public class HttpConnection
extends Connection
implements ConnectionListener {
    public static final int RESOLVER_FAILED = 4;
    public static final int RESOLVER_SUCCEDED = 5;
    public static final int CONNECTOR_FAILED = 6;
    public static final int CONNECTOR_SUCCEDED = 7;
    public static final int RETRIEVER_FAILED = 6;
    public static final int RETRIEVER_SUCCEDED = 7;
    public static final int WEBCRAWLER_STATE_BASE = 7;
    protected HttpRequest request;
    protected HttpRetrieverConnection retriever;
    protected Vector headersListeners;
    protected Vector bodyListeners;
    private boolean retry = false;
    private int numberOfRetries = 0;
    private int fConnectionTimeout = 10000;
    private String fTempFolder = "";
    protected HTTPOutputStreamGenerator ofsGenerator = null;

    public HttpConnection(HttpRequest request) {
        this.request = request;
        this.headersListeners = new Vector();
        this.bodyListeners = new Vector();
    }

    public void addBodyListener(HttpBodyListener l) {
        this.bodyListeners.addElement(l);
    }

    public void addHeadersListener(HttpHeadersListener l) {
        this.headersListeners.addElement(l);
    }

    public void bufferInputData() {
        this.ofsGenerator = null;
    }

    protected Socket connect(InetAddress address, int port) throws ConnectorFailureException {
        ConnectorConnection connector = new ConnectorConnection(address, port);
        connector.addConnectionListener(this);
        connector.perform();
        if (connector.getState() == 4) {
            throw new ConnectorFailureException();
        }
        this.setState(7);
        return connector.getSocket();
    }

    @Override
    public void connectionStateChanged(ConnectionEvent e) {
        Connection connection = (Connection)e.getSource();
        DebugInfo dbg = new DebugInfo(this, "connectionStateChanged()");
        if (connection instanceof ResolverConnection) {
            switch (e.getState()) {
                case 4: {
                    dbg.warningOut(NLS.bind((String)ResourceHandler._9concat_WARN_, (Object[])new Object[]{this.request}));
                    break;
                }
                case 5: {
                    dbg.traceOut(NLS.bind((String)ResourceHandler._10concat_INFO_, (Object[])new Object[]{this.request}));
                }
            }
        } else if (connection instanceof ConnectorConnection) {
            switch (e.getState()) {
                case 4: {
                    dbg.warningOut(NLS.bind((String)ResourceHandler._11concat_WARN_, (Object[])new Object[]{this.request}));
                    break;
                }
                case 5: {
                    dbg.traceOut(NLS.bind((String)ResourceHandler._12concat_INFO_, (Object[])new Object[]{this.request}));
                }
            }
        } else if (connection instanceof HttpRetrieverConnection) {
            switch (e.getState()) {
                case 5: {
                    dbg.traceOut(NLS.bind((String)ResourceHandler._13concat_INFO_, (Object[])new Object[]{this.request}));
                    break;
                }
                case 6: {
                    int statusCode = ((HttpRetrieverConnection)connection).getResponse().getStatusCode();
                    int statusOK = 200;
                    if (statusCode == statusOK) {
                        dbg.traceOut(NLS.bind((String)ResourceHandler._14concat_INFO_, (Object[])new Object[]{this.request}), 5);
                        break;
                    }
                    dbg.traceOut(NLS.bind((String)ResourceHandler._15concat_INFO_, (Object[])new Object[]{Integer.toString(statusCode), this.request}), 1);
                    break;
                }
                case 7: {
                    if (this.shouldStop()) break;
                    Enumeration en = this.headersListeners.elements();
                    while (en.hasMoreElements()) {
                        try {
                            ((HttpHeadersListener)en.nextElement()).headersReceived(this, this.request, ((HttpRetrieverConnection)connection).getResponse());
                        }
                        catch (Exception ex) {
                            dbg.traceOut(NLS.bind((String)ResourceHandler._17concat_EXC_, (Object[])new Object[]{ex}));
                        }
                    }
                    break;
                }
                case 8: {
                    if (this.shouldStop()) break;
                    Enumeration en = this.bodyListeners.elements();
                    while (en.hasMoreElements()) {
                        try {
                            ((HttpBodyListener)en.nextElement()).bodyReceived(this, this.request, ((HttpRetrieverConnection)connection).getResponse());
                        }
                        catch (Exception ex) {
                            dbg.traceOut(NLS.bind((String)ResourceHandler._18concat_EXC_, (Object[])new Object[]{ex}));
                        }
                    }
                    break;
                }
                case 4: {
                    dbg.warningOut(NLS.bind((String)ResourceHandler._19concat_WARN_, (Object[])new Object[]{this.request}));
                }
            }
        }
        if (this.shouldStop()) {
            connection.setStopFlag();
        }
    }

    public void doNotBuffer(HTTPOutputStreamGenerator ofsGenerator) {
        this.ofsGenerator = ofsGenerator;
    }

    protected void fetch(Socket socket) throws RetrieverFailureException, UserCancelledException {
        this.retriever = new HttpRetrieverConnection(socket, this.request, 0);
        this.retriever.setTempFolder(this.getTempFolder());
        this.retriever.setOSGenerator(this.ofsGenerator);
        this.retriever.setConnectionTimeout(this.fConnectionTimeout);
        this.retriever.setProgressMonitor(this.fMonitor);
        this.retriever.addConnectionListener(this);
        this.retriever.perform();
        if (this.retriever.getState() == 4) {
            throw new RetrieverFailureException();
        }
        this.setState(7);
    }

    public int getConnectionTimeout() {
        return this.fConnectionTimeout;
    }

    public String getTempFolder() {
        return this.fTempFolder;
    }

    public HttpResponse getResponse() {
        if (this.retriever != null) {
            return this.retriever.getResponse();
        }
        return null;
    }

    public int numberOfRetries() {
        return this.numberOfRetries;
    }

    @Override
    public void perform() {
        try {
            do {
                InetAddress address = this.resolve();
                if (this.shouldStop()) continue;
                Socket socket = this.connect(address, this.request.getURL().getPort() == -1 ? 80 : this.request.getURL().getPort());
                if (this.shouldStop()) continue;
                try {
                    this.fetch(socket);
                }
                catch (UserCancelledException userCancelledException) {
                    this.setStopFlag();
                }
                if (!this.shouldStop()) continue;
            } while (this.shouldRetry());
        }
        catch (ResolverFailureException resolverFailureException) {
            this.setState(4);
        }
        catch (ConnectorFailureException connectorFailureException) {
            this.setState(6);
        }
        catch (RetrieverFailureException retrieverFailureException) {
            this.setState(6);
        }
    }

    protected InetAddress resolve() throws ResolverFailureException {
        ResolverConnection resolver = new ResolverConnection(this.request.getURL().getHost());
        resolver.addConnectionListener(this);
        resolver.perform();
        if (resolver.getState() == 4) {
            throw new ResolverFailureException();
        }
        this.setState(5);
        return resolver.getAddress();
    }

    public void retry() {
        this.retry = true;
    }

    public void setConnectionTimeout(int newConnectionTimeout) {
        this.fConnectionTimeout = newConnectionTimeout;
    }

    @Override
    public void setStopFlag() {
        super.setStopFlag();
    }

    public void setTempFolder(String newTempFolder) {
        this.fTempFolder = newTempFolder;
    }

    public boolean shouldRetry() {
        if (this.retry) {
            this.retry = false;
            ++this.numberOfRetries;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return this.request.getURL().toString();
    }
}

