/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iwt.crawler.http;

import com.ibm.etools.webtools.filetransfer.wizards.nls.ResourceHandler;
import com.ibm.iwt.crawler.common.DebugInfo;
import com.ibm.iwt.crawler.common.PasswordManager;
import com.ibm.iwt.crawler.http.HttpConnection;
import com.ibm.iwt.crawler.http.HttpHeadersListener;
import com.ibm.iwt.crawler.http.HttpRequest;
import com.ibm.iwt.crawler.http.HttpResponse;

public class HttpAuthenticationHandler
implements HttpHeadersListener {
    private PasswordManager passwords;

    public HttpAuthenticationHandler(PasswordManager passwords) {
        this.passwords = passwords;
    }

    private static String getRealm(String authenticationHeader) {
        int realmIndex = authenticationHeader.indexOf("realm=");
        String realm = authenticationHeader.substring(realmIndex + 6).replace('\"', ' ').trim();
        return realm;
    }

    @Override
    public void headersReceived(HttpConnection connection, HttpRequest request, HttpResponse response) {
        if (response.getStatusCode() != 401) {
            return;
        }
        connection.setStopFlag();
        if (connection.numberOfRetries() > 0) {
            return;
        }
        try {
            String authenticationHeader = response.getHeaders().getHeader("WWW-Authenticate");
            String realm = HttpAuthenticationHandler.getRealm(authenticationHeader);
            String host = request.getURL().getHost();
            String idpass = this.passwords.getEncodedPair(host, realm);
            if (idpass == null) {
                return;
            }
            request.getHeaders().addHeader("Authorization", "Basic " + idpass);
            connection.retry();
        }
        catch (Exception e) {
            DebugInfo dbg = new DebugInfo(this, "headersReceived()");
            dbg.warningOut(String.valueOf(ResourceHandler.Authentication_header_proc_EXC_) + e);
        }
    }
}

