/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iwt.crawler.http;

import com.ibm.etools.ftp.core.internal.ResourceElement;
import com.ibm.etools.webtools.filetransfer.wizards.nls.ResourceHandler;
import com.ibm.iwt.crawler.common.ConnectionEvent;
import com.ibm.iwt.crawler.common.ConnectionFactory;
import com.ibm.iwt.crawler.common.ConnectionManager;
import com.ibm.iwt.crawler.common.PasswordManager;
import com.ibm.iwt.crawler.common.URLFilter;
import com.ibm.iwt.crawler.common.Worker;
import com.ibm.iwt.crawler.http.CrawlerConnectionFactory;
import com.ibm.iwt.crawler.http.HTTPOutputStreamGenerator;
import com.ibm.iwt.crawler.http.HttpAuthenticationHandler;
import com.ibm.iwt.crawler.http.HttpBodyListener;
import com.ibm.iwt.crawler.http.HttpRedirectionHandler;
import com.ibm.iwt.crawler.http.TypeFilter;
import com.ibm.iwt.crawler.wizards.http.HTTPBodySaver;
import com.ibm.iwt.crawler.wizards.http.HTTPCrawlerSession;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;

public class HTTPCrawler
extends ConnectionManager {
    protected long timeLimit;
    private static String fErrorString;
    private HttpBodyListener bodyListener;

    public HTTPCrawler(ConnectionFactory connectionFactory, int numberOfWorkers, long timeLimit) {
        super(connectionFactory, numberOfWorkers);
        this.timeLimit = timeLimit;
    }

    @Override
    public synchronized void connectionStateChanged(ConnectionEvent event) {
        switch (event.getState()) {
            case 4: {
                fErrorString = ResourceHandler.Failed_to_resolve_the_name_ERROR_;
                break;
            }
            case 6: {
                fErrorString = ResourceHandler.Failed_to_connect_to_the_s_ERROR_;
                break;
            }
            default: {
                super.connectionStateChanged(event);
            }
        }
    }

    public static String getErrorString() {
        return fErrorString;
    }

    public static void setErrorString(String newErrorString) {
        fErrorString = newErrorString;
    }

    public static String startCrawling(HTTPCrawlerSession fCrawlerSession, HttpBodyListener saveListner, HTTPOutputStreamGenerator ofsGenerator, IProgressMonitor monitor, String tempFolder, IProject project) {
        try {
            fErrorString = "";
            int depth = fCrawlerSession.getDepth();
            boolean importBackLinks = fCrawlerSession.isFollowBackLinks();
            Enumeration includedDomains = fCrawlerSession.getIncludedDomains();
            URL url = new URL(fCrawlerSession.getSeedUrl());
            ResourceElement seed = new ResourceElement(url);
            CrawlerConnectionFactory connectionFactory = new CrawlerConnectionFactory(seed, fCrawlerSession);
            connectionFactory.setTempFolder(tempFolder);
            connectionFactory.setProgressMonitor(monitor);
            URLFilter filter = new URLFilter(url, depth, !importBackLinks);
            Enumeration enm = includedDomains;
            while (enm.hasMoreElements()) {
                filter.addSiteDomain((String)enm.nextElement());
            }
            connectionFactory.setURLFilter(filter);
            PasswordManager passwords = new PasswordManager();
            connectionFactory.addHeadersListener(new HttpAuthenticationHandler(passwords));
            connectionFactory.addHeadersListener(new HttpRedirectionHandler(connectionFactory));
            connectionFactory.addHeadersListener(new TypeFilter());
            connectionFactory.setOfsGenerator(ofsGenerator);
            saveListner.setConnectionFactory(connectionFactory);
            connectionFactory.addBodyListener(saveListner);
            HTTPCrawler crawler = new HTTPCrawler(connectionFactory, 1, 15000L);
            crawler.setProgressMonitor(monitor);
            crawler.setHttpBodyListener(saveListner);
            crawler.setCrawlerSession(fCrawlerSession);
            crawler.run();
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            fErrorString = ResourceHandler.connection_to_proxy_failed_EXC_;
            return fErrorString;
        }
        catch (Exception e) {
            e.printStackTrace();
            fErrorString = e.getMessage();
            return fErrorString;
        }
        return fErrorString;
    }

    @Override
    public void finishWorkerJobs(Worker worker) {
        if (this.bodyListener instanceof HTTPBodySaver) {
            ((HTTPBodySaver)this.bodyListener).writeOutputFile();
        }
    }

    public HttpBodyListener getHttpBodyListener() {
        return this.bodyListener;
    }

    public void setHttpBodyListener(HttpBodyListener listener) {
        this.bodyListener = listener;
    }
}

