/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iwt.crawler.ftp;

import com.ibm.etools.ftp.core.internal.FTPRequest;
import com.ibm.etools.ftp.core.internal.ResourceElement;
import com.ibm.etools.webtools.filetransfer.wizards.nls.ResourceHandler;
import com.ibm.iwt.crawler.common.Connection;
import com.ibm.iwt.crawler.common.ConnectionFactory;
import com.ibm.iwt.crawler.common.DebugInfo;
import com.ibm.iwt.crawler.common.IURLFilter;
import com.ibm.iwt.crawler.common.ImportException;
import com.ibm.iwt.crawler.common.Link;
import com.ibm.iwt.crawler.common.URLFilter;
import com.ibm.iwt.crawler.ftp.FTPBodyListener;
import com.ibm.iwt.crawler.ftp.FTPConnection;
import com.ibm.iwt.crawler.ftp.FTPConnectionParams;
import com.ibm.iwt.crawler.ftp.FTPCrawler;
import com.ibm.iwt.crawler.ftp.FTPHeadersListener;
import com.ibm.iwt.crawler.ftp.FTPOutputStreamGenerator;
import com.ibm.iwt.crawler.ftp.FTPResourceElement;
import com.ibm.iwt.crawler.ftp.ImportFtpService;
import com.ibm.iwt.crawler.wizards.ftp.FTPCrawlerSession;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class FTPCrawlerConnectionFactory
implements ConnectionFactory {
    private Hashtable visitedUrls = new Hashtable();
    private Vector queue = new Vector();
    private Vector headersListeners = new Vector();
    private Vector bodyListeners = new Vector();
    private IURLFilter filter = new URLFilter();
    private Hashtable fFTPConnections = new Hashtable();
    private FTPOutputStreamGenerator ofsGenerator = null;
    private FTPConnectionParams fConnectionParams = null;
    private IProgressMonitor fMonitor;
    private int fConnectionTimeout = 10000;
    private FTPCrawlerSession fCrawlerSession = null;

    public FTPCrawlerConnectionFactory(ResourceElement[] urls, FTPCrawlerSession crawlerSession) {
        int i = 0;
        while (i < urls.length) {
            this.addUrl(urls[i]);
            this.filter.addSiteHostname(urls[i].getUrl().getHost());
            ++i;
        }
        this.initConnectionParams(crawlerSession);
    }

    public FTPCrawlerConnectionFactory(ResourceElement url, FTPCrawlerSession crawlerSession) {
        this.addUrl(url);
        this.filter.addSiteHostname(url.getUrl().getHost());
        this.initConnectionParams(crawlerSession);
    }

    public void addBodyListener(FTPBodyListener l) {
        this.bodyListeners.addElement(l);
    }

    public void addHeadersListener(FTPHeadersListener l) {
        this.headersListeners.addElement(l);
    }

    @Override
    public ResourceElement addLink(Link link, ResourceElement parent) {
        FTPResourceElement res = null;
        res = new FTPResourceElement(link.getUrl(), parent.getDepth() + 1);
        if (parent instanceof FTPResourceElement) {
            res.setSize(((FTPResourceElement)parent).getSize());
        }
        this.addUrl(res);
        return res;
    }

    public synchronized void addUrl(ResourceElement resource) {
        if (!this.visitedUrls.containsKey(resource.getUrl())) {
            this.visitedUrls.put(resource.getUrl(), resource);
            this.queue.addElement(resource);
        }
    }

    @Override
    public void addVisitedUrl(URL url) {
        this.visitedUrls.put(url, url);
    }

    private ImportFtpService getCachedFTPConnection(URL url) {
        String host = String.valueOf(url.getHost()) + url.getPort();
        ImportFtpService ftp = (ImportFtpService)((Object)this.fFTPConnections.get(host));
        if (ftp == null && (ftp = this.openFTPConnection(url)) != null) {
            this.fFTPConnections.put(host, ftp);
        }
        return ftp;
    }

    public FTPConnectionParams getConnectionParams() {
        return this.fConnectionParams;
    }

    public int getConnectionTimeout() {
        return this.fConnectionTimeout;
    }

    protected FTPConnection getFTPConnection(ResourceElement url) {
        FTPRequest request = new FTPRequest(url);
        ImportFtpService ftpHandle = this.getCachedFTPConnection(url.getUrl());
        if (ftpHandle != null) {
            return new FTPConnection(request, ftpHandle, this);
        }
        return null;
    }

    @Override
    public Connection getNewConnection() {
        DebugInfo dbg = new DebugInfo(this, "getNewConnection()");
        while (!this.queue.isEmpty()) {
            ResourceElement resource = (ResourceElement)this.queue.elementAt(0);
            URL url = resource.getUrl();
            this.queue.removeElementAt(0);
            if (this.filter.shouldCrawl(resource)) {
                String protocol = url.getProtocol();
                if (!protocol.equals("ftp")) continue;
                FTPConnection connection = this.getFTPConnection(resource);
                if (connection != null) {
                    Enumeration e = this.headersListeners.elements();
                    while (e.hasMoreElements()) {
                        connection.addHeadersListener((FTPHeadersListener)e.nextElement());
                    }
                    e = this.bodyListeners.elements();
                    while (e.hasMoreElements()) {
                        connection.addBodyListener((FTPBodyListener)e.nextElement());
                    }
                }
                this.fMonitor.setTaskName(NLS.bind((String)ResourceHandler.Importing_file___UI_, (Object)new Integer(this.fCrawlerSession.getNoOfFilesImported() + 1).toString()));
                return connection;
            }
            dbg.traceOut(NLS.bind((String)ResourceHandler._34concat_INFO_, (Object)url.toString()));
        }
        return null;
    }

    public IProgressMonitor getProgressMonitor() {
        return this.fMonitor;
    }

    public FTPOutputStreamGenerator getOfsGenerator() {
        return this.ofsGenerator;
    }

    @Override
    public IURLFilter getURLFilter() {
        return this.filter;
    }

    private ImportFtpService openFTPConnection(URL url) {
        ImportFtpService ftp = null;
        try {
            int ftpPort = url.getPort();
            if (ftpPort == -1) {
                ftpPort = 21;
            }
            SubProgressMonitor subMonitor = new SubProgressMonitor(this.fMonitor, 1);
            ftp = new ImportFtpService(url.getHost(), ftpPort, this.fConnectionParams, !this.fConnectionParams.getHostUrl().isAbsolute(), (IProgressMonitor)subMonitor);
            ftp.setConnectionTimeout(this.fConnectionTimeout);
            ftp.setup();
        }
        catch (ImportException ioe) {
            ftp = null;
            FTPCrawler.setErrorString(ioe.getMessage());
        }
        return ftp;
    }

    public void setOfsGenerator(FTPOutputStreamGenerator ofsGenerator) {
        this.ofsGenerator = ofsGenerator;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.fMonitor = monitor;
    }

    public void setURLFilter(IURLFilter filter) {
        this.filter = filter;
    }

    private void initConnectionParams(FTPCrawlerSession cs) {
        this.fCrawlerSession = cs;
        this.fConnectionParams = cs.getFtpConnectionParams();
        this.fConnectionTimeout = cs.getConnectionTimeout();
    }
}

