/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iwt.crawler.ftp;

import com.ibm.etools.ftp.core.IDirectoryItem;
import com.ibm.etools.ftp.core.internal.FTPRequest;
import com.ibm.etools.ftp.core.internal.FTPResponse;
import com.ibm.etools.ftp.core.internal.ResourceElement;
import com.ibm.etools.ftp.core.internal.UserCancelledException;
import com.ibm.etools.webtools.filetransfer.wizards.nls.ResourceHandler;
import com.ibm.iwt.crawler.common.Connection;
import com.ibm.iwt.crawler.common.ConnectionEvent;
import com.ibm.iwt.crawler.common.ConnectionFactory;
import com.ibm.iwt.crawler.common.ConnectionListener;
import com.ibm.iwt.crawler.common.ConnectorFailureException;
import com.ibm.iwt.crawler.common.DebugInfo;
import com.ibm.iwt.crawler.common.ImportException;
import com.ibm.iwt.crawler.common.Link;
import com.ibm.iwt.crawler.ftp.FTPBodyListener;
import com.ibm.iwt.crawler.ftp.FTPCrawler;
import com.ibm.iwt.crawler.ftp.FTPCrawlerConnectionFactory;
import com.ibm.iwt.crawler.ftp.FTPHeadersListener;
import com.ibm.iwt.crawler.ftp.FTPResourceElement;
import com.ibm.iwt.crawler.ftp.ImportFtpService;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.osgi.util.NLS;

public class FTPConnection
extends Connection
implements ConnectionListener {
    private FTPRequest request;
    private FTPResponse fResponse = null;
    private ImportFtpService fFtpHandle;
    private Vector headersListeners;
    private Vector bodyListeners;
    private ConnectionFactory fConnectionFactory;
    private boolean retry = false;
    private int numberOfRetries = 0;
    public static final int BODY_RECEIVED = 4;
    public static final int HEADERS_RECEIVED = 5;
    public static final int RETRIEVE_FAILED = 6;
    public static final int DEFAULT_FTP_PORT = 21;
    public static final String CURRENT_DIRECTORY = ".";
    public static final String PARENT_DIRECTORY = "..";

    public FTPConnection(FTPRequest request, ImportFtpService handle, ConnectionFactory connectionFactory) {
        this.request = request;
        this.fFtpHandle = handle;
        this.headersListeners = new Vector();
        this.bodyListeners = new Vector();
        this.fConnectionFactory = connectionFactory;
    }

    public void addBodyListener(FTPBodyListener l) {
        this.bodyListeners.addElement(l);
    }

    public void addHeadersListener(FTPHeadersListener l) {
        this.headersListeners.addElement(l);
    }

    private String appendUrls(String url1, String url2) {
        if (!url1.endsWith("/")) {
            url1 = String.valueOf(url1) + "/";
        }
        return String.valueOf(url1) + url2;
    }

    protected Socket connect(InetAddress address, int port) throws ConnectorFailureException {
        return null;
    }

    @Override
    public void connectionStateChanged(ConnectionEvent e) {
        Connection connection = (Connection)e.getSource();
        if (connection instanceof FTPConnection) {
            DebugInfo dbg = new DebugInfo(this, "connectionStateChanged()");
            switch (e.getState()) {
                case 6: {
                    dbg.warningOut(NLS.bind((String)ResourceHandler._2concat_WARN_, (Object)this.request));
                    break;
                }
                case 4: {
                    if (this.shouldStop()) break;
                    Enumeration en = this.bodyListeners.elements();
                    while (en.hasMoreElements()) {
                        try {
                            ((FTPBodyListener)en.nextElement()).bodyReceived(this, this.request, ((FTPConnection)connection).getResponse());
                        }
                        catch (Exception exception) {
                            dbg.errorOut(ResourceHandler.error_calling_and_FTPBodyL_EXC_);
                        }
                    }
                    break;
                }
            }
        }
        if (this.shouldStop()) {
            connection.setStopFlag();
        }
    }

    private void fetchDirectoryContent() throws ImportException {
        if (this.request.getResourceElement().isDirectory()) {
            URL url = this.request.getResourceElement().getUrl();
            Vector directoryList = this.fFtpHandle.list(url.getFile());
            DebugInfo dbg = new DebugInfo(this, "fetchDirectoryContent()");
            dbg.traceOut(url.toString());
            Enumeration enm = directoryList.elements();
            while (enm.hasMoreElements()) {
                IDirectoryItem item = (IDirectoryItem)enm.nextElement();
                if (item.getName().equals(CURRENT_DIRECTORY) || item.getName().equals(PARENT_DIRECTORY)) continue;
                String newUrl = this.appendUrls(url.toExternalForm(), item.getName());
                dbg.traceOut(NLS.bind((String)ResourceHandler._1concat_INFO_, (Object)newUrl));
                try {
                    FTPResourceElement ftpRE = new FTPResourceElement(this.request.getResourceElement());
                    ftpRE.setSize(item.getSize());
                    ResourceElement res = this.fConnectionFactory.addLink(new Link(new URL(newUrl), 1), ftpRE);
                    res.setDirectory(item.isDirectory());
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }
    }

    private void fetchFile() throws ImportException, UserCancelledException {
        if (!this.request.getResourceElement().isDirectory()) {
            URL url = this.request.getResourceElement().getUrl();
            try {
                ((FTPCrawlerConnectionFactory)this.fConnectionFactory).getOfsGenerator().getOutputStream(url, this.fResponse);
            }
            catch (IOException ioe) {
                throw new ImportException(ioe.toString());
            }
            this.fFtpHandle.getFile(this.request, this.fResponse);
            this.addConnectionListener(this);
            this.setState(4);
        }
    }

    public FTPResponse getResponse() {
        return this.fResponse;
    }

    public int numberOfRetries() {
        return this.numberOfRetries;
    }

    @Override
    public void perform() {
        try {
            do {
                this.fResponse = new FTPResponse();
                if (this.shouldStop()) continue;
                this.fetchDirectoryContent();
                if (this.shouldStop()) continue;
                try {
                    this.fetchFile();
                }
                catch (UserCancelledException userCancelledException) {
                    this.setStopFlag();
                }
                if (!this.shouldStop()) continue;
            } while (this.shouldRetry());
        }
        catch (ImportException ie) {
            this.setState(6);
            FTPCrawler.setErrorString(ie.getMessage());
        }
    }

    protected InetAddress resolve() {
        return null;
    }

    public void retry() {
        this.retry = true;
    }

    @Override
    public void setStopFlag() {
        super.setStopFlag();
    }

    public boolean shouldRetry() {
        if (this.retry) {
            this.retry = false;
            ++this.numberOfRetries;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return this.request.getURL().toString();
    }
}

