/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iwt.crawler.common;

import com.ibm.iwt.crawler.common.Worker;
import java.util.Stack;

public class WorkerPool {
    Worker[] workers;
    Stack stack;

    public WorkerPool(int numberOfWorkers) {
        this.workers = new Worker[numberOfWorkers];
        this.stack = new Stack();
        int i = 0;
        while (i < numberOfWorkers) {
            Worker worker;
            this.workers[i] = worker = new Worker(this);
            this.stack.push(worker);
            new Thread(worker).start();
            ++i;
        }
    }

    public void finish() {
        int i = 0;
        while (i < this.workers.length) {
            this.workers[i].finish();
            ++i;
        }
    }

    public synchronized Worker grabWorker() throws InterruptedException {
        while (this.stack.empty()) {
            this.wait();
        }
        return (Worker)this.stack.pop();
    }

    public synchronized void returnWorker(Worker worker) {
        this.stack.push(worker);
        if (this.stack.size() == 1) {
            this.notify();
        }
    }
}

