/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iwt.crawler.common;

import com.ibm.etools.webtools.filetransfer.wizards.nls.ResourceHandler;
import com.ibm.iwt.crawler.common.Connection;
import com.ibm.iwt.crawler.common.DebugInfo;
import com.ibm.iwt.crawler.common.WorkerPool;

public class Worker
implements Runnable {
    private WorkerPool pool;
    private Connection connection = null;
    private Thread workerThread = null;
    private volatile boolean cont = true;

    public Worker(WorkerPool pool) {
        this.pool = pool;
    }

    public synchronized void assignConnection(Connection connection) {
        this.connection = connection;
        this.notify();
    }

    public void finish() {
        this.cont = false;
        if (this.connection != null) {
            this.connection.setStopFlag();
        }
        if (this.workerThread != null) {
            this.workerThread.interrupt();
        }
    }

    @Override
    public void run() {
        this.workerThread = Thread.currentThread();
        while (this.cont) {
            DebugInfo dbg;
            try {
                this.waitForConnection();
                try {
                    this.connection.perform();
                }
                catch (Exception exception) {
                    dbg = new DebugInfo(this, "run()");
                    dbg.traceOut(ResourceHandler.Ended_abnormally__EXC_, 1);
                }
                this.connection.setState(2);
                this.connection = null;
                this.pool.returnWorker(this);
            }
            catch (InterruptedException interruptedException) {
                dbg = new DebugInfo(this, "run()");
                dbg.traceOut(ResourceHandler.Finished_Interrupted__EXC_);
                break;
            }
        }
    }

    private synchronized void waitForConnection() throws InterruptedException {
        while (this.connection == null) {
            this.wait();
        }
    }
}

