/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iwt.crawler.common;

import com.ibm.iwt.crawler.common.CrawlerSession;
import com.ibm.iwt.crawler.common.IDefaultPageProvider;
import com.ibm.iwt.crawler.common.IURI;
import com.ibm.iwt.crawler.common.URI;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class PhysicalLocationManager {
    public static final String QUERY_CHAR = "?";
    public static final String URL_SEPARATOR = "/";
    public static final char FORWARD_SHASH = '/';
    public static final char BACK_SHASH = '\\';
    protected IDefaultPageProvider fDefaultPageProvider;
    protected CrawlerSession fCrawlerSession;
    private IPath fContainerStructure1 = null;
    private IProject fProject = null;

    public PhysicalLocationManager() {
    }

    public PhysicalLocationManager(CrawlerSession crawlerSession, IDefaultPageProvider defaultPageProvider, IProject project) {
        this.fCrawlerSession = crawlerSession;
        this.fDefaultPageProvider = defaultPageProvider;
        this.fProject = project;
    }

    protected static String addPaths(String path1, String path2) {
        path1 = PhysicalLocationManager.switchToPathSeparator(path1);
        path2 = PhysicalLocationManager.switchToPathSeparator(path2);
        path2 = PhysicalLocationManager.removeLeadingChar(path2, File.separatorChar);
        File f1 = new File(path1, path2);
        return f1.getPath();
    }

    protected static void createFolders(String filePath) {
        filePath = PhysicalLocationManager.getFolderPath(filePath);
        File fle = new File(filePath);
        fle.mkdirs();
    }

    public IDefaultPageProvider getDefaultPageProvider() {
        return this.fDefaultPageProvider;
    }

    protected static String getFolderPath(String path) {
        String ret = path;
        if (!path.endsWith(File.separator)) {
            int index = path.lastIndexOf(File.separator);
            ret = path.substring(0, index);
        }
        return ret;
    }

    public IProject getProject() {
        return this.fProject;
    }

    protected static String getQueryString(String string) {
        String ret = null;
        int index = string.indexOf(QUERY_CHAR);
        if (index >= 0) {
            ret = string.substring(index);
        }
        return ret;
    }

    public IFile localFilePath(URL url, boolean bCreateCorrespondingContainerStructure, boolean dummy) {
        String filePath;
        if (this.fContainerStructure1 == null) {
            URI tempuri = new URI(this.fCrawlerSession.getSeedUrl());
            this.fContainerStructure1 = tempuri.getPath();
            if (this.fContainerStructure1.getFileExtension() != null) {
                this.fContainerStructure1 = this.fContainerStructure1.removeLastSegments(1);
            }
        }
        if ((filePath = url.getFile()).length() > 0) {
            if ((filePath = PhysicalLocationManager.stripQueryString(filePath)).endsWith(URL_SEPARATOR)) {
                filePath = String.valueOf(filePath) + this.fDefaultPageProvider.getDefaultPage(url);
            }
            Path pathFilePath = new Path(filePath);
            if (!bCreateCorrespondingContainerStructure && this.fContainerStructure1.isPrefixOf((IPath)pathFilePath)) {
                pathFilePath = pathFilePath.removeFirstSegments(this.fContainerStructure1.segmentCount());
            }
            return this.fCrawlerSession.getLocalFolder().getFile((IPath)pathFilePath);
        }
        return null;
    }

    public URL makeAbsoluteUrl(URL url) {
        URL newUrl = url;
        IURI uri = new URI(url.toExternalForm());
        IPath path = uri.getPath();
        if (path.hasTrailingSeparator() || path.isRoot()) {
            uri = uri.appendPath(this.fDefaultPageProvider.getDefaultPage(url));
            try {
                newUrl = new URL(uri.toString());
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return newUrl;
    }

    protected static String removeLeadingChar(String string, char chatToRemove) {
        if (string.equals("")) {
            return string;
        }
        if (string.charAt(0) == chatToRemove) {
            return string.substring(1);
        }
        return string;
    }

    protected static String removeTrailingChar(String string, char chatToRemove) {
        if (string.charAt(string.length() - 1) == chatToRemove) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    public void setDefaultPageProvider(IDefaultPageProvider newDefaultPageProvider) {
        this.fDefaultPageProvider = newDefaultPageProvider;
    }

    public static String stripQueryString(String string) {
        String ret = string;
        int index = string.indexOf(QUERY_CHAR);
        if (index >= 0) {
            ret = string.substring(0, index);
        }
        return ret;
    }

    protected static String switchToPathSeparator(String string) {
        string = string.replace('/', File.separatorChar);
        string = string.replace('\\', File.separatorChar);
        return string;
    }
}

