/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iwt.crawler.common;

import java.util.Hashtable;

public class PasswordManager {
    private Hashtable hosts = new Hashtable();

    public void addPassword(String host, String userid, String password) {
        HostInfo hostInfo = (HostInfo)this.hosts.get(host);
        if (hostInfo == null) {
            hostInfo = new HostInfo();
            this.hosts.put(host, hostInfo);
        }
        hostInfo.defaultPair = new UseridPassword(userid, password);
    }

    public void addPassword(String host, String realm, String userid, String password) {
        HostInfo hostInfo = (HostInfo)this.hosts.get(host);
        if (hostInfo == null) {
            hostInfo = new HostInfo();
            this.hosts.put(host, hostInfo);
        }
        hostInfo.realms.put(realm, new UseridPassword(userid, password));
    }

    public String getEncodedPair(String host, String realm) {
        HostInfo hostInfo = (HostInfo)this.hosts.get(host);
        if (hostInfo == null) {
            return null;
        }
        UseridPassword pair = (UseridPassword)hostInfo.realms.get(realm);
        return pair != null ? pair.encoding : (hostInfo.defaultPair != null ? hostInfo.defaultPair.encoding : null);
    }

    static class HostInfo {
        UseridPassword defaultPair = null;
        Hashtable realms = new Hashtable();

        HostInfo() {
        }
    }

    static class UseridPassword {
        String userid;
        String password;
        String encoding;
        static char[] vec = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

        UseridPassword(String userid, String password) {
            this.userid = userid;
            this.password = password;
            this.encoding = UseridPassword.encodeBase64(new String(String.valueOf(userid) + ":" + password).getBytes());
        }

        private static final String encodeBase64(byte[] input) {
            long val;
            int i = 0;
            int j = 0;
            char[] output = new char[76];
            int bytesLeft = input.length;
            while (bytesLeft > 2) {
                val = 0L;
                val |= (long)(input[i++] << 16);
                val |= (long)(input[i++] << 8);
                output[j++] = vec[(int)((val |= (long)input[i++]) >> 18 & 0x3FL)];
                output[j++] = vec[(int)(val >> 12 & 0x3FL)];
                output[j++] = vec[(int)(val >> 6 & 0x3FL)];
                output[j++] = vec[(int)(val & 0x3FL)];
                bytesLeft -= 3;
            }
            if (bytesLeft == 1) {
                val = 0L;
                output[j++] = vec[(int)((val |= (long)(input[i++] << 16)) >> 18 & 0x3FL)];
                output[j++] = vec[(int)(val >> 12 & 0x3FL)];
                output[j++] = 61;
                output[j++] = 61;
            }
            if (bytesLeft == 2) {
                val = 0L;
                val |= (long)(input[i++] << 16);
                output[j++] = vec[(int)((val |= (long)(input[i++] << 8)) >> 18 & 0x3FL)];
                output[j++] = vec[(int)(val >> 12 & 0x3FL)];
                output[j++] = vec[(int)(val >> 6 & 0x3FL)];
                output[j++] = 61;
            }
            return new String(output, 0, j);
        }
    }
}

