/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iwt.crawler.common;

import java.io.InputStream;
import java.util.Hashtable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.SWTException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.IOverwriteQuery;

public class InternetImportOperation
extends WorkspaceModifyOperation {
    protected IResource fTargetResource;
    private Hashtable fErrorTable = new Hashtable(9);
    protected boolean fOverwriteResourcesNowOnwards = false;
    protected boolean fOverwriteResourcesUserChoice = false;
    protected IOverwriteQuery fOverwriteCallback;
    protected IProgressMonitor fMonitor;
    protected String fErrorString = "";

    public InternetImportOperation(IResource container, IOverwriteQuery overwriteImplementor) {
        this.fTargetResource = container;
        this.fOverwriteCallback = overwriteImplementor;
    }

    public IFile addFile(IFile file, InputStream fileData) {
        return this.importFile(file, fileData);
    }

    protected void execute(IProgressMonitor monitor) throws CoreException {
    }

    public String getErrorString() {
        return this.fErrorString;
    }

    public Hashtable getResult() {
        return this.fErrorTable;
    }

    public IResource getTargetResource() {
        return this.fTargetResource;
    }

    protected IFile importFile(IFile targetResource, InputStream fileData) {
        if (targetResource.exists() && !this.fOverwriteResourcesNowOnwards && this.fOverwriteResourcesUserChoice) {
            String overwriteAnswer;
            block10: {
                block9: {
                    try {
                        overwriteAnswer = this.fOverwriteCallback.queryOverwrite(targetResource.getFullPath().toOSString());
                        if (!overwriteAnswer.equals("CANCEL")) break block9;
                        this.fMonitor.setCanceled(true);
                        if (!this.fMonitor.isCanceled()) break block9;
                        return null;
                    }
                    catch (SWTException sWTException) {}
                }
                if (!overwriteAnswer.equals("NO")) break block10;
                this.fMonitor.worked(1);
                return null;
            }
            if (overwriteAnswer.equals("ALL")) {
                this.fOverwriteResourcesNowOnwards = true;
            }
        }
        if (fileData != null) {
            try {
                targetResource.setContents(fileData, true, true, this.fMonitor);
            }
            catch (CoreException coreException) {}
            return null;
        }
        return targetResource;
    }

    public boolean isOverwriteResourcesUserChoice() {
        return this.fOverwriteResourcesUserChoice;
    }

    public void setErrorString(String newErrorString) {
        this.fErrorString = newErrorString;
    }

    public void setOverwriteResourcesUserChoice(boolean newOverwriteResourcesUserChoice) {
        this.fOverwriteResourcesUserChoice = newOverwriteResourcesUserChoice;
    }

    public void setTargetResource(IResource newTargetResource) {
        this.fTargetResource = newTargetResource;
    }
}

