/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iwt.crawler.common;

import com.ibm.iwt.crawler.common.CrawlerSession;
import com.ibm.iwt.crawler.common.LinkManager;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class CrawlerLinkManager {
    private IProject fProject;
    private IVirtualComponent fComponent;
    private IResource fTargetResource;
    private CrawlerSession fCrawlerSession;
    private IPath fWebRoot;
    private IPath fDocRoot;
    private IPath fServletRoot;
    private boolean fTargetIsWebFolder = false;
    private boolean fTargetIsServletFolder = false;
    private IPath fDocRootPrefix;
    private IPath fServletPrefix;

    public CrawlerLinkManager(IResource targetResource, CrawlerSession session) {
        this.fCrawlerSession = session;
        this.fTargetResource = targetResource;
        this.fProject = targetResource.getProject();
        if (targetResource.getType() != 4) {
            this.fComponent = ComponentUtilities.findComponent((IResource)this.fTargetResource);
        }
        this.initialize();
    }

    public String fixLink(String basePath, String link, int style, IPath pathBasePath) {
        String fixedLink = link;
        if (style == 0 && this.fCrawlerSession.isAUrlWithSpecialPreix(link)) {
            style = 1;
        }
        if (style == 0) {
            try {
                URL baseUrl = new URL(basePath);
                URL linkUrl = new URL(link);
                String baseFile = baseUrl.getFile();
                String linkFile = linkUrl.getFile();
                fixedLink = LinkManager.toRelative(baseFile, linkFile);
            }
            catch (MalformedURLException malformedURLException) {}
        } else {
            try {
                URL tempUrl = new URL(link);
                IPath targetResourcePath = this.fTargetResource.getFullPath();
                IProject targetProject = this.fTargetResource.getProject();
                IPath targetDocRoot = targetProject.getFullPath();
                targetDocRoot = this.getDocumentRoot();
                int matchingSegments = targetResourcePath.matchingFirstSegments(targetDocRoot);
                IPath prefixPath = targetResourcePath.removeFirstSegments(matchingSegments);
                prefixPath = prefixPath.makeAbsolute();
                fixedLink = tempUrl.getFile();
                if (!this.isAWASWebAppUri(fixedLink) || !this.isTargetFolderAWASFolder()) {
                    if (!this.fCrawlerSession.isCreateCorrespondingContainerStructure()) {
                        IPath seedBasePath = pathBasePath;
                        Path linkPath = new Path(fixedLink);
                        matchingSegments = linkPath.matchingFirstSegments(seedBasePath);
                        linkPath = linkPath.removeFirstSegments(matchingSegments);
                        fixedLink = linkPath.toString();
                    }
                    if (this.isTargetFolderAWASFolder()) {
                        prefixPath = this.getPrefxUri().append(prefixPath);
                    }
                    prefixPath = prefixPath.append(fixedLink);
                    fixedLink = prefixPath.toString();
                }
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return fixedLink;
    }

    IPath getDocumentRoot() {
        return this.fDocRoot;
    }

    IPath getPrefxUri() {
        if (this.fTargetIsServletFolder) {
            return this.fServletPrefix;
        }
        return this.fDocRootPrefix;
    }

    void initialize() {
        if (this.fComponent != null) {
            IPath projectPath = this.fProject.getFullPath();
            this.fWebRoot = this.fComponent.getRootFolder().getWorkspaceRelativePath();
            this.fServletRoot = JemProjectUtilities.getJavaProjectOutputLocation((IProject)this.fProject);
            this.fDocRootPrefix = this.fWebRoot;
            this.fServletPrefix = this.fServletRoot;
            this.fDocRoot = projectPath;
            this.fTargetIsWebFolder = false;
            this.fTargetIsServletFolder = false;
            if (this.fWebRoot.isPrefixOf(this.fTargetResource.getFullPath())) {
                this.fDocRoot = this.fWebRoot;
                this.fTargetIsWebFolder = true;
            } else if (this.fServletRoot.isPrefixOf(this.fTargetResource.getFullPath())) {
                this.fTargetIsServletFolder = true;
                this.fDocRoot = this.fServletRoot;
            }
        } else {
            this.fWebRoot = this.fProject.getFullPath();
        }
    }

    boolean isADocRootFolder() {
        boolean bRet = false;
        if (this.fComponent != null) {
            this.fWebRoot = this.fComponent.getRootFolder().getWorkspaceRelativePath();
            if (this.fWebRoot.isPrefixOf(this.fTargetResource.getFullPath())) {
                bRet = true;
            }
        } else {
            this.fWebRoot = this.fProject.getFullPath();
        }
        return bRet;
    }

    boolean isAWASWebAppUri(String uri) {
        boolean bRet = false;
        if (this.fComponent != null) {
            Path sourcePath = new Path(uri);
            IPath webUri = this.fComponent.getRootFolder().getWorkspaceRelativePath();
            IPath servletUri = JemProjectUtilities.getJavaProjectOutputLocation((IProject)this.fProject);
            if (webUri.isPrefixOf((IPath)sourcePath)) {
                return true;
            }
            if (servletUri.isPrefixOf((IPath)sourcePath)) {
                return true;
            }
        }
        return bRet;
    }

    boolean isTargetFolderAWASFolder() {
        return this.fTargetIsWebFolder || this.fTargetIsServletFolder;
    }
}

