/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.dojo.ui.internal;

import com.ibm.etools.webtools.dojo.core.DojoVersion;
import com.ibm.etools.webtools.dojo.core.internal.DojoCoreUtil;
import com.ibm.etools.webtools.dojo.core.internal.DojoInspector;
import com.ibm.etools.webtools.dojo.ui.internal.Messages;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;

public class DojoUIUtil {
    public static final String EXCEPTION_KEY = "ver.exception";

    public static void retrieveVersion(final Link verText, final Text sourceText, final String source) {
        verText.setText(Messages.getString("DojoFacetInstallWizardPage.evaluating"));
        Job job = new Job(Messages.getString("DojoFacetInstallWizardPage.jobname")){

            protected IStatus run(IProgressMonitor monitor) {
                if (DojoCoreUtil.isValidDojoSource((String)source)) {
                    final DojoVersion[] ver = new DojoVersion[1];
                    if (source.startsWith("http:")) {
                        try {
                            ver[0] = DojoInspector.getRemoteDojoVersion((URL)new URL(source));
                        }
                        catch (MalformedURLException e) {
                            return DojoUIUtil.handleVersionError(verText, sourceText, source, e);
                        }
                        catch (CoreException e) {
                            return DojoUIUtil.handleVersionError(verText, sourceText, source, (Exception)((Object)e));
                        }
                        catch (RuntimeException e) {
                            return DojoUIUtil.handleVersionError(verText, sourceText, source, e);
                        }
                    }
                    Path path = new Path(source);
                    try {
                        ver[0] = ResourcesPlugin.getWorkspace().getRoot().exists((IPath)path) ? DojoInspector.getWorkspaceDojoVersion((IPath)path) : DojoInspector.getLocalFileDojoVersion((IPath)path);
                    }
                    catch (CoreException e) {
                        return DojoUIUtil.handleVersionError(verText, sourceText, source, (Exception)((Object)e));
                    }
                    if (!verText.isDisposed()) {
                        verText.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (DojoUIUtil.sourceIsCurrent(sourceText, source)) {
                                    verText.setText(ver[0].toString());
                                }
                            }
                        });
                    }
                    return Status.OK_STATUS;
                }
                return DojoUIUtil.handleVersionError(verText, sourceText, source, new RuntimeException(Messages.getString("DojoFacetInstallWizardPage.invalidSource")));
            }
        };
        job.setPriority(50);
        job.setSystem(true);
        job.schedule();
    }

    private static IStatus handleVersionError(final Link verText, final Text sourceText, final String source, final Exception e) {
        if (verText != null && !verText.isDisposed()) {
            verText.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (DojoUIUtil.sourceIsCurrent(sourceText, source)) {
                        verText.setText(Messages.getString("DojoFacetInstallWizardPage.failedVersion"));
                        verText.setData(DojoUIUtil.EXCEPTION_KEY, (Object)e);
                    }
                }
            });
        }
        return Status.OK_STATUS;
    }

    private static boolean sourceIsCurrent(Text sourceText, String source) {
        return sourceText != null && !sourceText.isDisposed() && sourceText.getText().equals(source);
    }
}

