/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.dojo.ui.internal;

import com.ibm.etools.webtools.dojo.core.DojoSettings;
import com.ibm.etools.webtools.dojo.core.facet.DojoFacetInstallModelProvider;
import com.ibm.etools.webtools.dojo.core.internal.DojoSettingsWriter;
import com.ibm.etools.webtools.dojo.core.internal.refactoring.DojoRootPropertyChangeDescriptor;
import com.ibm.etools.webtools.dojo.core.internal.refactoring.DojoRootRenameProcessor;
import com.ibm.etools.webtools.dojo.ui.internal.DojoContainerViewFilter;
import com.ibm.etools.webtools.dojo.ui.internal.DojoUIUtil;
import com.ibm.etools.webtools.dojo.ui.internal.Messages;
import com.ibm.etools.webtools.dojo.ui.internal.ProgressMonitorPropertyPage;
import com.ibm.etools.webtools.dojo.ui.internal.refactoring.DojoRootRefactoringWizard;
import java.net.MalformedURLException;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class DojoSettingsPropertiesPage
extends ProgressMonitorPropertyPage
implements IWorkbenchPropertyPage,
Listener,
IDataModelListener {
    private IProject project;
    private Text dojorootText;
    private Button browseSource;
    private Text bsText;
    private Text dojoCssText;
    private Text dijitCssText;
    private Combo themeCssCombo;
    private Link verText;
    private IDataModel _model = DataModelFactory.createDataModel((IDataModelProvider)new DojoFacetInstallModelProvider());
    private boolean validRoot = true;
    private DojoRootPropertyChangeDescriptor rootChangeDescriptor;
    private Button refactor;

    @Override
    protected Control createBody(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo(composite);
        Label rootLabel = new Label(composite, 0);
        rootLabel.setText(Messages.getString("DojoSettingsPropertiesPage.DojoRoot"));
        this.dojorootText = new Text(composite, 2048);
        this.dojorootText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DojoSettingsPropertiesPage.this.rootChangeDescriptor.setNewRoot(DojoSettingsPropertiesPage.this.dojorootText.getText());
                DojoSettingsPropertiesPage.this.verText.setText("");
                DojoUIUtil.retrieveVersion(DojoSettingsPropertiesPage.this.verText, DojoSettingsPropertiesPage.this.dojorootText, DojoSettingsPropertiesPage.this.rootChangeDescriptor.getNewRoot());
                String theme = DojoSettingsPropertiesPage.this.themeCssCombo.getText();
                String newRoot = DojoSettingsPropertiesPage.this.rootChangeDescriptor.getNewRoot();
                if (newRoot != null && newRoot.startsWith("http")) {
                    DojoSettingsPropertiesPage.this._model.addListener((IDataModelListener)DojoSettingsPropertiesPage.this);
                }
                DojoSettingsPropertiesPage.this.populateThemeCSS(newRoot);
                if (theme != null && !theme.equals("")) {
                    DojoSettingsPropertiesPage.this.themeCssCombo.setText(theme);
                }
                DojoSettingsPropertiesPage.this.validateOptionalValues();
                DojoSettingsPropertiesPage.this.updateRefactorButton();
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.dojorootText);
        this.browseSource = new Button(composite, 0);
        GridDataFactory.defaultsFor((Control)this.browseSource).applyTo((Control)this.browseSource);
        this.browseSource.setText(Messages.getString("DojoSettingsPropertiesPage.Browse"));
        this.browseSource.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object element;
                DojoContainerViewFilter filter = new DojoContainerViewFilter();
                WorkbenchContentProvider contentProvider = new WorkbenchContentProvider();
                DecoratingLabelProvider labelProvider = new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(DojoSettingsPropertiesPage.this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
                dialog.setTitle(Messages.getString("DojoFacetInstallWizardPage.WorkspaceDialogTitle"));
                dialog.setMessage(Messages.getString("DojoFacetInstallWizardPage.WorkspaceDialogMsg"));
                dialog.addFilter((ViewerFilter)filter);
                dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                if (dialog.open() == 0 && (element = dialog.getFirstResult()) instanceof IContainer) {
                    IContainer container = (IContainer)element;
                    String newContainerPathString = container.getFullPath().toString();
                    DojoSettingsPropertiesPage.this.dojorootText.setText(newContainerPathString);
                }
            }
        });
        Label verLabel = new Label(composite, 0);
        verLabel.setText(Messages.getString("DojoSettingsPropertiesPage.Version"));
        this.verText = new Link(composite, 0);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.verText);
        this.verText.addListener(13, (Listener)this);
        new Label(composite, 0);
        this.refactor = new Button(composite, 32);
        this.refactor.setText(Messages.getString("DojoSettingsPropertiesPage.refactor_existing_links"));
        this.refactor.setEnabled(false);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.refactor);
        Label bsLabel = new Label(composite, 0);
        bsLabel.setText(Messages.getString("DojoSettingsPropertiesPage.LoaderJS"));
        this.bsText = new Text(composite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.bsText);
        this.bsText.addListener(24, (Listener)this);
        Label dojoCssLabel = new Label(composite, 0);
        dojoCssLabel.setText(Messages.getString("DojoSettingsPropertiesPage.DojoCSS"));
        this.dojoCssText = new Text(composite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.dojoCssText);
        this.dojoCssText.addListener(24, (Listener)this);
        Label dijitCssLabel = new Label(composite, 0);
        dijitCssLabel.setText(Messages.getString("DojoSettingsPropertiesPage.DijitCSS"));
        this.dijitCssText = new Text(composite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.dijitCssText);
        this.dijitCssText.addListener(24, (Listener)this);
        Label themeCssLabel = new Label(composite, 0);
        themeCssLabel.setText(Messages.getString("DojoSettingsPropertiesPage.ThemeCSS"));
        this.themeCssCombo = new Combo(composite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.themeCssCombo);
        this.themeCssCombo.addListener(24, (Listener)this);
        this.initializeContents();
        return composite;
    }

    protected void performDefaults() {
        this.initializeContents();
        super.performDefaults();
    }

    private void initializeContents() {
        if (this.getProject() != null) {
            try {
                String oldDojoRoot = DojoSettings.getDojoRoot((IProject)this.getProject()).toString();
                this.rootChangeDescriptor = new DojoRootPropertyChangeDescriptor(this.getProject(), oldDojoRoot, oldDojoRoot);
                this.dojorootText.setText(this.rootChangeDescriptor.getNewRoot());
                this.bsText.setText(DojoSettings.getDojoLoaderJS((IProject)this.getProject()));
                this.dojoCssText.setText(DojoSettings.getDojoCSS((IProject)this.getProject()));
                this.dijitCssText.setText(DojoSettings.getDijitCSS((IProject)this.getProject()));
                this.populateThemeCSS(oldDojoRoot);
                this.themeCssCombo.setText(DojoSettings.getThemeCSS((IProject)this.getProject()));
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            DojoUIUtil.retrieveVersion(this.verText, this.dojorootText, this.rootChangeDescriptor.getNewRoot());
        }
    }

    private void populateThemeCSS(String root) {
        this.themeCssCombo.removeAll();
        this._model.setStringProperty("IDojoFacetInstallDataModelProperties.source", root);
        DataModelPropertyDescriptor[] themeCSS = this._model.getValidPropertyDescriptors("IDojoFacetInstallDataModelProperties.theme.css");
        if (themeCSS != null && themeCSS.length > 0) {
            DataModelPropertyDescriptor[] dataModelPropertyDescriptorArray = themeCSS;
            int n = themeCSS.length;
            int n2 = 0;
            while (n2 < n) {
                DataModelPropertyDescriptor desc = dataModelPropertyDescriptorArray[n2];
                this.themeCssCombo.add((String)desc.getPropertyValue());
                ++n2;
            }
        }
    }

    private IProject getProject() {
        if (this.project == null) {
            Object p;
            IAdaptable element = this.getElement();
            if (element == null) {
                return null;
            }
            if (element instanceof IProject) {
                this.project = (IProject)element;
                return this.project;
            }
            if (element instanceof IAdaptable && (p = element.getAdapter(IProject.class)) != null) {
                return (IProject)p;
            }
            return null;
        }
        return this.project;
    }

    public void performApply() {
        super.performApply();
        this.initializeContents();
    }

    public boolean performOk() {
        if (this.refactor.getSelection()) {
            RenameRefactoring refactoring = new RenameRefactoring((RenameProcessor)new DojoRootRenameProcessor(this.rootChangeDescriptor));
            DojoRootRefactoringWizard wizard = new DojoRootRefactoringWizard((Refactoring)refactoring, this.rootChangeDescriptor);
            RefactoringWizardOpenOperation operation = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
            try {
                int result = operation.run(this.getShell(), "");
                if (result == 1 || result == 1025) {
                    return false;
                }
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        Properties properties = this.getPropertiesFromForm();
        try {
            DojoSettingsWriter.persistDojoSettings((IProject)this.getProject(), (Properties)properties);
        }
        catch (CoreException e) {
            StatusAdapter adapter = new StatusAdapter(e.getStatus());
            StatusManager.getManager().handle(adapter);
            return false;
        }
        return super.performOk();
    }

    private Properties getPropertiesFromForm() {
        Properties properties = new Properties();
        this.addProperty(properties, this.rootChangeDescriptor.getNewRoot(), "dojo-root");
        this.addProperty(properties, this.bsText.getText(), "dojo-bootstrap-js");
        this.addProperty(properties, this.dojoCssText.getText(), "dojo-css");
        this.addProperty(properties, this.dijitCssText.getText(), "dojo-dijit-css");
        this.addProperty(properties, this.themeCssCombo.getText(), "dojo-theme-css");
        return properties;
    }

    private void addProperty(Properties properties, String value, String key) {
        if (value == null) {
            value = "";
        }
        properties.put(key, value);
    }

    public void handleEvent(Event event) {
        Exception e;
        if (event.widget == this.bsText) {
            if (this.validRoot) {
                this.setValid(this.validateOptionalValues());
            }
        } else if (event.widget == this.dijitCssText) {
            if (this.validRoot) {
                this.setValid(this.validateOptionalValues());
            }
        } else if (event.widget == this.dojoCssText) {
            if (this.validRoot) {
                this.setValid(this.validateOptionalValues());
            }
        } else if (event.widget == this.themeCssCombo) {
            if (this.validRoot) {
                this.setValid(this.validateOptionalValues());
            }
        } else if (event.widget.equals(this.verText) && event.type == 13 && (e = (Exception)this.verText.getData("ver.exception")) != null) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("DojoFacetInstallWizardPage.error"), (String)e.getMessage());
        }
    }

    private void updateRefactorButton() {
        if (this.rootChangeDescriptor.hasRootChanged()) {
            this.refactor.setEnabled(true);
            this.refactor.setSelection(true);
        } else {
            this.refactor.setEnabled(false);
            this.refactor.setSelection(false);
        }
    }

    private boolean validateOptionalValues() {
        boolean valid = this.validatePath(this.bsText.getText(), Messages.getString("DojoSettingsPropertiesPage.loader.js.invalid"));
        if (valid && (valid = this.validatePath(this.dojoCssText.getText(), Messages.getString("DojoSettingsPropertiesPage.dojo.css.invalid"))) && (valid = this.validatePath(this.dijitCssText.getText(), Messages.getString("DojoSettingsPropertiesPage.dijit.css.invalid")))) {
            valid = this.validatePath(this.themeCssCombo.getText(), Messages.getString("DojoSettingsPropertiesPage.theme.css.invalid"));
        }
        return valid;
    }

    public boolean okToLeave() {
        return this.getErrorMessage() == null;
    }

    public boolean isValid() {
        return super.isValid();
    }

    public void setValid(boolean b) {
        super.setValid(b);
    }

    public void setErrorMessage(String newMessage) {
        super.setErrorMessage(newMessage);
        this.setValid(newMessage == null);
    }

    private boolean validatePath(String location, String errorMessage) {
        IFile resource;
        if (location == null || location.equals("")) {
            this.setErrorMessage(null);
            return true;
        }
        String error = null;
        String root = this.rootChangeDescriptor.getNewRoot();
        error = this.rootChangeDescriptor.isNewRootLocal() ? (!(resource = this.getProject().getWorkspace().getRoot().getFile(new Path(root).append(location))).exists() ? errorMessage : null) : null;
        this.setErrorMessage(error);
        return error == null;
    }

    public void propertyChanged(DataModelEvent event) {
        if (event.getPropertyName() != null && event.getPropertyName().equals("IDojoFacetInstallDataModelProperties.theme.css") && event.getFlag() == 4) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    String[] items;
                    if (DojoSettingsPropertiesPage.this.themeCssCombo.isDisposed()) {
                        return;
                    }
                    String theme = DojoSettingsPropertiesPage.this.themeCssCombo.getText();
                    DojoSettingsPropertiesPage.this.populateThemeCSS(DojoSettingsPropertiesPage.this.rootChangeDescriptor.getNewRoot());
                    String[] stringArray = items = DojoSettingsPropertiesPage.this.themeCssCombo.getItems();
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String item = stringArray[n2];
                        if (item.equals(theme)) {
                            DojoSettingsPropertiesPage.this.themeCssCombo.setText(item);
                            break;
                        }
                        ++n2;
                    }
                    if (DojoSettingsPropertiesPage.this.themeCssCombo.getText().equals("") && DojoSettingsPropertiesPage.this.themeCssCombo.getItemCount() > 0) {
                        DojoSettingsPropertiesPage.this.themeCssCombo.setText(DojoSettingsPropertiesPage.this.themeCssCombo.getItem(0));
                    }
                }
            });
        }
    }
}

