/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.sdo.jdbc.ui.validators;

import com.ibm.etools.sdo.jdbc.ui.internal.data.ConnectionData;
import com.ibm.etools.sdo.jdbc.ui.internal.data.IConnectionData;
import com.ibm.etools.sdo.jdbc.ui.internal.util.RSCConnectionsHelper;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.Connection;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.DevelopmentConnection;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.RscImportedDatabase;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.RscLiveConnection;
import com.ibm.etools.webtools.deploy.jdbc.internal.DeployJDBCPlugin;
import com.ibm.etools.webtools.deploy.jdbc.internal.nls.ResourceHandler;
import com.ibm.etools.webtools.sdo.jdbc.ui.validators.ConnectionsValidatorParser;
import com.ibm.icu.util.StringTokenizer;
import java.io.File;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.validation.internal.operations.LocalizedMessage;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public class ValidateConnectionUtil {
    protected static IMessage createMessage(IConnectionData connectionData, String messageString, int severity, int lineNumer) {
        LocalizedMessage message = new LocalizedMessage(severity, messageString, (Object)connectionData.getConnectionObject());
        if (lineNumer <= 0) {
            message.setLineNo(1);
            message.setLength(0);
            message.setOffset(0);
        }
        return message;
    }

    private static ConnectionsValidatorParser.LineInfo getDevelopmentLineInfo(ConnectionsValidatorParser parser, IConnectionData connectionData) {
        return parser.getLineInfo(connectionData.getConnectionObject().getDevelopment().getId());
    }

    private static ConnectionsValidatorParser.LineInfo getRuntimeLineInfo(ConnectionsValidatorParser parser, IConnectionData connectionData) {
        return parser.getLineInfo(connectionData.getConnectionObject().getRuntime().getId());
    }

    public static String parseServerName(String url) {
        boolean foundHostName;
        String serverName = null;
        int start = url != null ? url.indexOf("//") + 2 : -1;
        boolean bl = foundHostName = start != 1;
        if (!foundHostName) {
            start = url != null ? url.indexOf("@") + 1 : -1;
            boolean bl2 = foundHostName = start != 0;
        }
        if (!foundHostName) {
            start = url != null ? url.indexOf("Tds:") + 4 : -1;
            boolean bl3 = foundHostName = start != 3;
        }
        if (foundHostName && start > 1 && url.length() > start) {
            int end;
            String subString = url.substring(start);
            int n = end = subString != null ? subString.indexOf(":") : -1;
            if (end != -1) {
                serverName = subString.substring(0, end);
            }
        }
        return serverName;
    }

    private static void validateConnection(ConnectionsValidatorParser parser, IProject project, Vector messages, Connection connection) {
        IMessage[] result;
        ConnectionData data = new ConnectionData();
        data.setProject(project);
        data.setConnect(false);
        try {
            data.setSetInitialConnectionObjectDefaults(false);
            data.setConnectionObject(connection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        IMessage[] iMessageArray = result = ValidateConnectionUtil.validateConnectionData(parser, data);
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            IMessage element = iMessageArray[n2];
            messages.add(element);
            ++n2;
        }
    }

    public static IMessage[] validateConnectionData(ConnectionsValidatorParser parser, IConnectionData connectionData) {
        IMessage message;
        DevelopmentConnection developmentConnection;
        Vector<IMessage> messages = new Vector<IMessage>();
        if (connectionData.isExistingConnection() && (developmentConnection = connectionData.getConnectionObject().getDevelopment()) instanceof RscLiveConnection) {
            IConnectionProfile[] profiles;
            RscLiveConnection liveConnection = (RscLiveConnection)developmentConnection;
            String connectionName = liveConnection.getName();
            boolean found = false;
            IConnectionProfile[] iConnectionProfileArray = profiles = ProfileManager.getInstance().getProfiles();
            int n = profiles.length;
            int n2 = 0;
            while (n2 < n) {
                IConnectionProfile connectionProfile = iConnectionProfileArray[n2];
                if (connectionProfile.getName() != null & connectionProfile.getName().equals(connectionName)) {
                    found = true;
                    break;
                }
                ++n2;
            }
            if (!found) {
                message = ValidateConnectionUtil.createMessage(connectionData, NLS.bind((String)ResourceHandler.Live_Connection_Does_Not_Exist, (Object[])new String[]{connectionName, connectionData.getConnectionObject().getId()}), 2, ValidateConnectionUtil.getDevelopmentLineInfo((ConnectionsValidatorParser)parser, (IConnectionData)connectionData).lineNumber);
                messages.add(message);
            }
        }
        if (connectionData.isImportedDatabase() && (developmentConnection = connectionData.getConnectionObject().getDevelopment()) instanceof RscImportedDatabase) {
            RscImportedDatabase importedConnection = (RscImportedDatabase)developmentConnection;
            String dbXmiLocation = importedConnection.getXmiLocation();
            Path path = new Path(dbXmiLocation);
            path = path.makeRelative();
            IResource res = DeployJDBCPlugin.getWorkspace().getRoot().findMember((IPath)path);
            if (res == null || !res.exists() || res.getType() != 1) {
                message = ValidateConnectionUtil.createMessage(connectionData, NLS.bind((String)ResourceHandler.Imported_Connection_Does_Not_Exist, (Object[])new String[]{dbXmiLocation, connectionData.getConnectionObject().getId()}), 2, ValidateConnectionUtil.getDevelopmentLineInfo((ConnectionsValidatorParser)parser, (IConnectionData)connectionData).lineNumber);
                messages.add(message);
            }
        }
        if (connectionData.isDriverManager()) {
            ValidateConnectionUtil.validateDriverManagedRuntimeConnection(parser, connectionData, messages);
        } else if (connectionData.isDataSource()) {
            ValidateConnectionUtil.validateDataSourceRuntimeConnection(parser, connectionData, messages);
        }
        return messages.toArray(new IMessage[messages.size()]);
    }

    public static IMessage[] validateConnections(ConnectionsValidatorParser parser, IProject project, List connections) {
        Vector messages = new Vector();
        int i = 0;
        while (i < connections.size()) {
            Connection connection = (Connection)connections.get(i);
            ValidateConnectionUtil.validateConnection(parser, project, messages, connection);
            ++i;
        }
        return messages.toArray(new IMessage[messages.size()]);
    }

    private static void validateDataSourceRuntimeConnection(ConnectionsValidatorParser parser, IConnectionData connectionData, Vector messages) {
        IMessage message;
        if (RSCConnectionsHelper.needsJ2CCJar(connectionData) && !RSCConnectionsHelper.hasJ2CCJar(connectionData)) {
            message = ValidateConnectionUtil.createMessage(connectionData, ResourceHandler.ConnectionPage_db2jcc_error, 1, ValidateConnectionUtil.getRuntimeLineInfo((ConnectionsValidatorParser)parser, (IConnectionData)connectionData).lineNumber);
            messages.add(message);
        }
        if (connectionData.getResourceRefName() == null || connectionData.getResourceRefName().equals("")) {
            message = ValidateConnectionUtil.createMessage(connectionData, ResourceHandler.Data_Source_name_can_not_be_null_18, 1, ValidateConnectionUtil.getRuntimeLineInfo((ConnectionsValidatorParser)parser, (IConnectionData)connectionData).lineNumber);
            messages.add(message);
        }
        if (connectionData.isAutoDeploy()) {
            if (connectionData.getDataSourceClassName() == null || connectionData.getDataSourceClassName().equals("")) {
                message = ValidateConnectionUtil.createMessage(connectionData, ResourceHandler.RuntimeConnectionPage_Data_Source_not_be_null_13, 1, ValidateConnectionUtil.getRuntimeLineInfo((ConnectionsValidatorParser)parser, (IConnectionData)connectionData).lineNumber);
                messages.add(message);
            }
            if (connectionData.getDatabaseName() == null || connectionData.getDatabaseName().equals("")) {
                message = ValidateConnectionUtil.createMessage(connectionData, ResourceHandler.RuntimeConnectionPage_Database_name_not_be_null_14, 1, ValidateConnectionUtil.getRuntimeLineInfo((ConnectionsValidatorParser)parser, (IConnectionData)connectionData).lineNumber);
                messages.add(message);
            }
            if (connectionData.getClassLocation() == null || connectionData.getClassLocation().equals("")) {
                message = ValidateConnectionUtil.createMessage(connectionData, ResourceHandler.RuntimeConnectionPage_Database_driver_not_be_null_12, 1, ValidateConnectionUtil.getRuntimeLineInfo((ConnectionsValidatorParser)parser, (IConnectionData)connectionData).lineNumber);
                messages.add(message);
            } else {
                StringTokenizer toker = new StringTokenizer(connectionData.getClassLocation(), ";");
                if (toker.countTokens() <= 1) {
                    toker = new StringTokenizer(connectionData.getClassLocation(), File.pathSeparator);
                }
                while (toker.hasMoreTokens()) {
                    File file;
                    String path = toker.nextToken();
                    int index = path.indexOf("${");
                    if (index != -1 && (index = path.indexOf(125, index)) != -1 || (file = new File(path)).exists()) continue;
                    IMessage message2 = ValidateConnectionUtil.createMessage(connectionData, NLS.bind((String)ResourceHandler.Database_Driver_Path_Could_Not_Be_Found, (Object[])new String[]{path}), 2, ValidateConnectionUtil.getRuntimeLineInfo((ConnectionsValidatorParser)parser, (IConnectionData)connectionData).lineNumber);
                    messages.add(message2);
                }
            }
            String serverName = connectionData.getServerName();
            if (serverName.equals("localhost")) {
                serverName = ValidateConnectionUtil.parseServerName(connectionData.getURL());
            }
            if (serverName != null) {
                connectionData.getPortNumber();
            }
            if (RSCConnectionsHelper.needsJ2CCJar(connectionData) && (connectionData.getUserName() == null || connectionData.getUserName().equals(""))) {
                IMessage message3 = ValidateConnectionUtil.createMessage(connectionData, ResourceHandler.Userid_and_password_must_be_set, 1, ValidateConnectionUtil.getRuntimeLineInfo((ConnectionsValidatorParser)parser, (IConnectionData)connectionData).lineNumber);
                messages.add(message3);
            }
        }
    }

    private static void validateDriverManagedRuntimeConnection(ConnectionsValidatorParser parser, IConnectionData connectionData, Vector messages) {
        IMessage message;
        if (connectionData.getURL() == null || connectionData.getURL().equals("")) {
            message = ValidateConnectionUtil.createMessage(connectionData, ResourceHandler.URL_can_not_be_null_16, 1, ValidateConnectionUtil.getRuntimeLineInfo((ConnectionsValidatorParser)parser, (IConnectionData)connectionData).lineNumber);
            messages.add(message);
        }
        if (connectionData.getDriver() == null || connectionData.getDriver().equals("")) {
            message = ValidateConnectionUtil.createMessage(connectionData, ResourceHandler.Driver_name_can_not_be_null_17, 1, ValidateConnectionUtil.getRuntimeLineInfo((ConnectionsValidatorParser)parser, (IConnectionData)connectionData).lineNumber);
            messages.add(message);
        }
        if (connectionData.getClassLocation() == null || connectionData.getClassLocation().equals("")) {
            message = ValidateConnectionUtil.createMessage(connectionData, ResourceHandler.RuntimeConnectionPage_Database_driver_not_be_null_12, 1, ValidateConnectionUtil.getRuntimeLineInfo((ConnectionsValidatorParser)parser, (IConnectionData)connectionData).lineNumber);
            messages.add(message);
        } else {
            StringTokenizer toker = new StringTokenizer(connectionData.getClassLocation(), ";");
            if (toker.countTokens() <= 1) {
                toker = new StringTokenizer(connectionData.getClassLocation(), File.pathSeparator);
            }
            while (toker.hasMoreTokens()) {
                String path = toker.nextToken();
                File file = new File(path);
                int index = path.indexOf("${");
                if (index != -1 && (index = path.indexOf(125, index)) != -1 || file.exists()) continue;
                IMessage message2 = ValidateConnectionUtil.createMessage(connectionData, NLS.bind((String)ResourceHandler.Database_Driver_Path_Could_Not_Be_Found, (Object[])new String[]{path}), 2, ValidateConnectionUtil.getRuntimeLineInfo((ConnectionsValidatorParser)parser, (IConnectionData)connectionData).lineNumber);
                messages.add(message2);
            }
        }
    }
}

