/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.sdo.jdbc.ui.validators;

import com.ibm.etools.webtools.deploy.jdbc.internal.DeployJDBCPlugin;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IProfileListener;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.common.frameworks.internal.operations.IHeadlessRunnableWithProgress;
import org.eclipse.wst.common.frameworks.internal.ui.RunnableWithProgressWrapper;
import org.eclipse.wst.validation.internal.operations.OneValidatorOperation;

public class JDBCMediatorConnectionFileValidatorListener
implements IProfileListener {
    public static final String MARKER_ID = "com.ibm.etools.webtools.deploy.jdbc.JDBCMediatorConnectionValidatorMarker";
    public static final String CONNECTIONS_VALIDATOR_ID = "com.ibm.etools.webtools.sdo.jdbc.ui.validators.JDBCMediatorConnectionFileValidator";

    public void profileAdded(IConnectionProfile profile) {
        this.validateConnectionCreated();
    }

    public void profileChanged(IConnectionProfile profile) {
    }

    public void profileDeleted(IConnectionProfile profile) {
        this.validateConnectionRemoved();
    }

    private void validateConnectionCreated() {
        IWorkspace workspace = DeployJDBCPlugin.getWorkspace();
        IProject[] projects = workspace.getRoot().getProjects();
        try {
            int i = 0;
            while (i < projects.length) {
                IMarker[] connectionValidationMarkers = projects[i].findMarkers(MARKER_ID, false, 2);
                if (connectionValidationMarkers.length > 0) {
                    try {
                        OneValidatorOperation op = new OneValidatorOperation(projects[i], CONNECTIONS_VALIDATOR_ID, false, true);
                        RunnableWithProgressWrapper runnable = new RunnableWithProgressWrapper((IHeadlessRunnableWithProgress)op);
                        runnable.run((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (InterruptedException ie) {
                        Logger.getLogger().logError((Throwable)ie);
                    }
                    catch (InvocationTargetException ite) {
                        Logger.getLogger().logError((Throwable)ite);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
    }

    private void validateConnectionRemoved() {
        IWorkspace workspace = DeployJDBCPlugin.getWorkspace();
        IProject[] projects = workspace.getRoot().getProjects();
        try {
            int i = 0;
            while (i < projects.length) {
                IFile file = projects[i].getFile(".wdo-connections");
                if (file != null && file.exists()) {
                    try {
                        OneValidatorOperation op = new OneValidatorOperation(projects[i], CONNECTIONS_VALIDATOR_ID, false, true);
                        RunnableWithProgressWrapper runnable = new RunnableWithProgressWrapper((IHeadlessRunnableWithProgress)op);
                        runnable.run((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (InterruptedException ie) {
                        Logger.getLogger().logError((Throwable)ie);
                    }
                    catch (InvocationTargetException ite) {
                        Logger.getLogger().logError((Throwable)ite);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
        }
        catch (Exception exception) {}
    }
}

