/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.sdo.jdbc.ui.validators;

import com.ibm.etools.sdo.jdbc.ui.internal.deploy.JDBCUiUtil;
import com.ibm.etools.sdo.jdbc.ui.internal.util.ConnectionsHelper;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.Connection;
import com.ibm.etools.webtools.deploy.jdbc.internal.nls.ResourceHandler;
import com.ibm.etools.webtools.sdo.jdbc.ui.validators.ConnectionManager;
import com.ibm.etools.webtools.sdo.jdbc.ui.validators.ConnectionsValidatorParser;
import com.ibm.etools.webtools.sdo.jdbc.ui.validators.ValidateConnectionUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.EnvEntry;
import org.eclipse.jst.j2ee.common.ResourceRef;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.IWorkbenchContext;
import org.eclipse.wst.validation.internal.operations.LocalizedMessage;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.validation.internal.provisional.core.IValidatorJob;

public class JDBCMediatorConnectionFileValidator
implements IValidatorJob {
    public void cleanup(IReporter reporter) {
    }

    public ISchedulingRule getSchedulingRule(IValidationContext helper) {
        return null;
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
    }

    private void validateFile(IReporter reporter, IFile file) {
        try {
            IMessage[] messages;
            ConnectionManager connectionManager = ConnectionManager.getInstance(file.getLocation().toString(), true);
            EList connections = connectionManager.getConnections();
            ConnectionsValidatorParser parser = new ConnectionsValidatorParser();
            reporter.removeAllMessages((IValidator)this, (Object)file);
            IMessage[] iMessageArray = messages = ValidateConnectionUtil.validateConnections(parser, file.getProject(), (List)connections);
            int n = messages.length;
            int n2 = 0;
            while (n2 < n) {
                IMessage element = iMessageArray[n2];
                element.setTargetObject((Object)file);
                reporter.addMessage((IValidator)this, element);
                ++n2;
            }
        }
        catch (Exception exception) {}
    }

    public IStatus validateInJob(IValidationContext helper, IReporter reporter) throws ValidationException {
        try {
            if (helper == null) {
                return OK_STATUS;
            }
            if (reporter != null && reporter.isCancelled()) {
                return OK_STATUS;
            }
            if (ConnectionsHelper.hasConnectionsFile(((IWorkbenchContext)helper).getProject())) {
                String[] fileUris = helper.getURIs();
                if (fileUris == null || fileUris.length == 0) {
                    IFile file;
                    IProject project;
                    if (helper instanceof IWorkbenchContext && (project = ((IWorkbenchContext)helper).getProject()) != null && (file = project.getFile(".wdo-connections")) != null && file.exists()) {
                        this.validateFile(reporter, file);
                    }
                } else {
                    int i = 0;
                    while (i < fileUris.length && !reporter.isCancelled()) {
                        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(fileUris[i]));
                        if (file.getFullPath().lastSegment().endsWith(".wdo-connections")) {
                            this.validateFile(reporter, file);
                        }
                        ++i;
                    }
                }
                this.validateResourceRefsAndEnvEntries(((IWorkbenchContext)helper).getProject(), reporter);
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        return OK_STATUS;
    }

    private void validateResourceRefsAndEnvEntries(IProject project, IReporter reporter) {
        EList connectionsList = null;
        try {
            connectionsList = ConnectionsHelper.getConnections(project);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        if (connectionsList != null) {
            IVirtualComponent comp = ComponentCore.createComponent((IProject)project);
            ArrayList<LocalizedMessage> messages = new ArrayList<LocalizedMessage>();
            WebArtifactEdit webEdit = WebArtifactEdit.getWebArtifactEditForRead((IVirtualComponent)comp);
            if (webEdit != null) {
                IPath webxmlPath = webEdit.getDeploymentDescriptorPath();
                IFile webxmlfile = null;
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                if (webxmlPath != null && root != null) {
                    webxmlfile = webxmlPath.toFile().exists() ? root.getFileForLocation(webxmlPath) : root.getFile(webxmlPath);
                }
                if (webxmlfile != null) {
                    reporter.removeAllMessages((IValidator)this, webxmlfile);
                }
                try {
                    try {
                        WebApp app = webEdit.getWebApp();
                        EList resourceRefs = app.getResourceRefs();
                        int resourceRefsLength = resourceRefs.size();
                        int i = resourceRefsLength - 1;
                        while (i >= 0) {
                            ResourceRef resourceRef = (ResourceRef)resourceRefs.get(i);
                            boolean existsInSDOConnections = false;
                            List list = JDBCUiUtil.getAllDescriptions(resourceRef);
                            int j = 0;
                            while (j < list.size() && !existsInSDOConnections) {
                                String description = (String)list.get(j);
                                if (JDBCUiUtil.isGeneratedBySDO(description)) {
                                    for (Connection connection : connectionsList) {
                                        if (!JDBCUiUtil.resourceRefMatchesConnection(resourceRef, connection)) continue;
                                        existsInSDOConnections = true;
                                        break;
                                    }
                                    if (!existsInSDOConnections) {
                                        LocalizedMessage message = new LocalizedMessage(2, NLS.bind((String)ResourceHandler.NoMatchingResourceRefForJDBConnection, (Object[])new String[]{resourceRef.getName()}), (Object)resourceRef);
                                        messages.add(message);
                                    }
                                }
                                ++j;
                            }
                            --i;
                        }
                        EList envEntries = app.getEnvironmentProperties();
                        int envEntriesLength = envEntries.size();
                        int i2 = envEntriesLength - 1;
                        while (i2 >= 0) {
                            EnvEntry envEntry = (EnvEntry)envEntries.get(i2);
                            boolean existsInSDOConnections = false;
                            List descriptions = JDBCUiUtil.getAllDescriptions(envEntry);
                            int j = 0;
                            while (j < descriptions.size() && !existsInSDOConnections) {
                                String description = (String)descriptions.get(j);
                                if (JDBCUiUtil.isGeneratedBySDO(description)) {
                                    for (Connection connection : connectionsList) {
                                        if (envEntry.getName() == null || !envEntry.getName().equals(connection.getId())) continue;
                                        existsInSDOConnections = true;
                                        break;
                                    }
                                    if (!existsInSDOConnections) {
                                        LocalizedMessage message = new LocalizedMessage(2, NLS.bind((String)ResourceHandler.NoMatchingEnvEntryForJDBConnection, (Object[])new String[]{envEntry.getName()}), (Object)envEntry);
                                        messages.add(message);
                                    }
                                }
                                ++j;
                            }
                            --i2;
                        }
                        if (webxmlfile == null || !webxmlfile.exists()) {
                            webxmlfile = null;
                        }
                        for (IMessage iMessage : messages) {
                            iMessage.setTargetObject((Object)webxmlfile);
                            reporter.addMessage((IValidator)this, iMessage);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (webEdit != null) {
                            webEdit.dispose();
                        }
                    }
                }
                finally {
                    if (webEdit != null) {
                        webEdit.dispose();
                    }
                }
            }
        }
    }
}

