/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.sdo.jdbc.ui.validators;

import com.ibm.etools.sdo.jdbc.ui.internal.connections.util.ConnectionsResourceFactoryImpl;
import com.ibm.etools.sdo.jdbc.ui.internal.connections.util.ConnectionsResourceImpl;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.Connection;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.Connections;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.ConnectionsPackage;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.DevelopmentConnection;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.DocumentRoot;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.RuntimeConnection;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;

public class ConnectionManager {
    private Connections fConnections;
    private String fContext;
    ConnectionsPackage init = ConnectionsPackage.eINSTANCE;
    private static final Map fInstances = new HashMap();

    protected ConnectionManager(String context) {
        this.fContext = context;
        this.load(context);
    }

    public static synchronized ConnectionManager getInstance(String context) {
        return ConnectionManager.getInstance(context, false);
    }

    public static synchronized ConnectionManager getInstance(String context, boolean forceLoad) {
        ConnectionManager ret = null;
        if (context != null && ConnectionManager.getInstanceMap().get(context) != null) {
            ret = (ConnectionManager)ConnectionManager.getInstanceMap().get(context);
            if (forceLoad) {
                ret.load(context);
            }
        } else if (context != null) {
            ret = new ConnectionManager(context);
            ConnectionManager.getInstanceMap().put(context, ret);
        }
        return ret;
    }

    private static Map getInstanceMap() {
        return fInstances;
    }

    public Connection getConnection(String connectionId) {
        Connection ret = null;
        EList connections = this.getConnections();
        int i = 0;
        while (i < connections.size()) {
            Connection connection = (Connection)connections.get(i);
            if (connection.getId().equals(connectionId)) {
                ret = connection;
                break;
            }
            ++i;
        }
        return ret;
    }

    public EList getConnections() {
        return this.fConnections != null ? this.fConnections.getConnection() : new BasicEList();
    }

    public String getContext() {
        return this.fContext;
    }

    public DevelopmentConnection getDevelopmentConnection(String connectionId) {
        Connection connection = this.getConnection(connectionId);
        return connection != null ? connection.getDevelopment() : null;
    }

    public RuntimeConnection getRuntimeConnection(String connectionId) {
        Connection connection = this.getConnection(connectionId);
        return connection != null ? connection.getRuntime() : null;
    }

    private void load(String connectionsRealPath) {
        ConnectionsResourceFactoryImpl factory = new ConnectionsResourceFactoryImpl();
        URI uri = URI.createFileURI((String)connectionsRealPath);
        ConnectionsResourceImpl resource = (ConnectionsResourceImpl)factory.createResource(uri);
        try {
            resource.load(resource.getDefaultLoadOptions());
            Object rawConnections = resource.getContents().get(0);
            if (rawConnections instanceof Connections) {
                this.fConnections = (Connections)rawConnections;
            } else if (rawConnections instanceof DocumentRoot) {
                this.fConnections = ((DocumentRoot)rawConnections).getConnections();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setContext(String fString) {
        this.fContext = fString;
    }
}

