/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.sdo.ui.internal.waslocator;

import com.ibm.etools.sdo.jdbc.ui.internal.util.RegistryReader;
import com.ibm.etools.sdo.ui.internal.waslocator.WASRuntimeLocator;
import com.ibm.etools.webtools.deploy.jdbc.internal.DeployJDBCPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class WASRuntimeLocatorRegistryReader
extends RegistryReader {
    private static final String WAS_RUNTIME_LOCATOR_EXT_PNT_ID = "WASRuntimeLocator";
    private static final String LOCATOR = "locator";
    private static final String RUNTIMEID_ID = "runtimeId";
    private static final String CLASS_ATT = "class";
    private static WASRuntimeLocatorRegistryReader fServerSetupRegistryReader;
    private Map fElements = new HashMap();

    protected WASRuntimeLocatorRegistryReader() {
    }

    public static List createWASRuntimeLocator(String serverId) {
        fServerSetupRegistryReader = new WASRuntimeLocatorRegistryReader();
        fServerSetupRegistryReader.parseServerSetups();
        ArrayList<WASRuntimeLocator> locators = new ArrayList<WASRuntimeLocator>();
        if (WASRuntimeLocatorRegistryReader.fServerSetupRegistryReader.fElements != null && WASRuntimeLocatorRegistryReader.fServerSetupRegistryReader.fElements.get(serverId) instanceof List) {
            List elements = (List)WASRuntimeLocatorRegistryReader.fServerSetupRegistryReader.fElements.get(serverId);
            int i = 0;
            while (i < elements.size()) {
                WASRuntimeLocator locator = fServerSetupRegistryReader.createWASRuntimeLocator((IConfigurationElement)elements.get(i));
                if (locator != null) {
                    locators.add(locator);
                }
                ++i;
            }
        }
        return locators;
    }

    public static WASRuntimeLocator getFirstWASRuntimeLocator(String serverId) {
        List locators = WASRuntimeLocatorRegistryReader.createWASRuntimeLocator(serverId);
        WASRuntimeLocator locator = null;
        if (locators.size() > 0 && locators.get(0) instanceof WASRuntimeLocator) {
            locator = (WASRuntimeLocator)locators.get(0);
        }
        return locator;
    }

    private WASRuntimeLocator createWASRuntimeLocator(IConfigurationElement element) {
        String serverSetupClass = element.getAttribute(CLASS_ATT);
        WASRuntimeLocator ret = null;
        if (serverSetupClass != null) {
            Object classObject = null;
            try {
                classObject = element.createExecutableExtension(CLASS_ATT);
                if (classObject instanceof WASRuntimeLocator) {
                    ret = (WASRuntimeLocator)classObject;
                }
            }
            catch (CoreException ce) {
                this.logError(element, ce.getLocalizedMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    private void parseServerSetups() {
        this.readRegistry(Platform.getExtensionRegistry(), DeployJDBCPlugin.getDefault().getBundle().getSymbolicName(), WAS_RUNTIME_LOCATOR_EXT_PNT_ID);
    }

    @Override
    protected boolean readElement(IConfigurationElement element) {
        if (element.getName().equalsIgnoreCase(LOCATOR)) {
            String id = element.getAttribute(RUNTIMEID_ID);
            if (!this.fElements.containsKey(id)) {
                ArrayList<IConfigurationElement> list = new ArrayList<IConfigurationElement>();
                list.add(element);
                this.fElements.put(id, list);
            } else {
                Object listObject = this.fElements.get(id);
                if (listObject instanceof List) {
                    List list = (List)listObject;
                    list.add(element);
                } else {
                    ArrayList<IConfigurationElement> list = new ArrayList<IConfigurationElement>();
                    list.add(element);
                    this.fElements.put(id, list);
                }
            }
        } else {
            return false;
        }
        return true;
    }
}

