/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.sdo.ui.internal;

import com.ibm.etools.webtools.deploy.jdbc.internal.DeployJDBCPlugin;
import com.ibm.icu.util.StringTokenizer;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;

public class Status
extends org.eclipse.core.runtime.Status {
    private static final String MESSAGE_IS_NULL = "null";
    private String fMessage = null;
    protected int priority = 0;

    public Status() {
        this(0, MESSAGE_IS_NULL);
    }

    public Status(int severity) {
        this(severity, MESSAGE_IS_NULL);
    }

    public Status(int severity, String message) {
        this(severity, message, null);
    }

    public Status(int severity, String message, Throwable exception) {
        super(severity, DeployJDBCPlugin.class.getName(), severity, message, exception);
        this.fMessage = message;
    }

    public static int getMessageProviderSeverity(int severity) {
        int sev = 0;
        switch (severity) {
            case 4: {
                sev = 3;
                break;
            }
            case 2: {
                sev = 2;
                break;
            }
            case 1: {
                sev = 1;
                break;
            }
        }
        return sev;
    }

    public static String getStackTraceAsString(Throwable exception) {
        StringWriter sw = new StringWriter();
        exception.printStackTrace(new PrintWriter(sw));
        String st = sw.toString();
        if (st == null || st == "") {
            exception.fillInStackTrace();
            exception.printStackTrace(new PrintWriter(sw));
            st = sw.toString();
        }
        return st;
    }

    public String getMessage() {
        return this.fMessage;
    }

    public int getMessageProviderSeverity() {
        return Status.getMessageProviderSeverity(this.getSeverity());
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isError() {
        return this.getSeverity() == 4;
    }

    public boolean isWarning() {
        return this.getSeverity() == 2;
    }

    public MultiStatus makeMultiStatusFromThowable() {
        StringTokenizer tokenizer = new StringTokenizer(Status.getStackTraceAsString(this.getException()), System.getProperty("line.separator"));
        String line = tokenizer.nextToken();
        MultiStatus status = new MultiStatus(this.getPlugin(), this.getSeverity(), this.getException().getLocalizedMessage() != null ? this.getException().getLocalizedMessage() : "Null Pointer Exception", this.getException());
        Status inner = null;
        while (tokenizer.hasMoreElements()) {
            line = tokenizer.nextToken();
            line = line.replace('\t', ' ');
            inner = new Status(4, "    " + line);
            status.add((IStatus)inner);
        }
        return status;
    }

    public void setError(String message) {
        this.setSeverity(4);
        this.setMessage(message);
    }

    public void setInfo(String message) {
        this.setSeverity(0);
        this.setMessage(message);
    }

    protected void setMessage(String message) {
        super.setMessage(message != null ? message : MESSAGE_IS_NULL);
        this.fMessage = message;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setWarning(String message) {
        this.setSeverity(2);
        this.setMessage(message);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Status ");
        if (this.getSeverity() == 0) {
            buf.append("OK");
        } else if (this.getSeverity() == 4) {
            buf.append("ERROR");
        } else if (this.getSeverity() == 2) {
            buf.append("WARNING");
        } else if (this.getSeverity() == 1) {
            buf.append("INFO");
        } else if (this.getSeverity() == 8) {
            buf.append("CANCEL");
        } else {
            buf.append("severity=");
            buf.append(this.getSeverity());
        }
        buf.append(": ");
        buf.append(this.getPlugin());
        buf.append(" code=");
        buf.append(this.getCode());
        buf.append(' ');
        buf.append(this.getMessage());
        buf.append(' ');
        buf.append(this.getException());
        return buf.toString();
    }
}

