/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.sdo.jdbc.ui.internal.util;

import com.ibm.etools.webtools.deploy.jdbc.internal.DeployJDBCPlugin;
import com.ibm.etools.webtools.deploy.jdbc.internal.consts.UIConstants;
import com.ibm.etools.webtools.deploy.jdbc.internal.nls.ResourceHandler;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.j2ee.common.ResourceRef;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class ResourceRefSelectionDialog
extends SelectionStatusDialog
implements ISelectionChangedListener {
    protected WebArtifactEdit fWebArtifactEdit;
    protected IStructuredContentProvider fContentProvider;
    protected ILabelProvider fLabelProvider;
    protected TableViewer fTable;
    protected ResourceRef fResourceRef;
    protected int fSelectedIndex;
    protected WebApp fWebApp;
    private List fTypeFilters;

    public ResourceRefSelectionDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setTitle(ResourceHandler.ResourceRefSelectionDialog_Choose_Recource_Reference_1);
        this.setStatusLineAboveButtons(true);
    }

    protected void cancelPressed() {
        this.setResult(new Vector(0));
        this.fWebArtifactEdit.dispose();
        super.cancelPressed();
    }

    protected void computeResult() {
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        this.fTable = new TableViewer(contents, 2820);
        this.fTable.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.fTable.setContentProvider((IContentProvider)this.getContentProvider());
        try {
            this.fTable.setInput((Object)this.getWebApp());
        }
        catch (Exception exception) {
            this.fTable.setInput(null);
        }
        this.fTable.addSelectionChangedListener((ISelectionChangedListener)this);
        GridData gd = new GridData(1808);
        gd.widthHint = 180;
        gd.heightHint = 180;
        this.fTable.getControl().setLayoutData((Object)gd);
        this.updateDialogStatus();
        return this.fTable.getControl();
    }

    protected IStructuredContentProvider getContentProvider() {
        if (this.fContentProvider == null) {
            this.fContentProvider = this.initContentProvider();
        }
        return this.fContentProvider;
    }

    protected ILabelProvider getLabelProvider() {
        if (this.fLabelProvider == null) {
            this.fLabelProvider = this.initLabelProvider();
        }
        return this.fLabelProvider;
    }

    public ResourceRef getResourceRef() {
        return this.fResourceRef;
    }

    public WebApp getWebApp() throws Exception {
        if (this.fWebApp == null) {
            this.fWebApp = this.fWebArtifactEdit.getWebApp();
        }
        return this.fWebApp;
    }

    public WebArtifactEdit getWebArtifactEdit() {
        return this.fWebArtifactEdit;
    }

    protected IStructuredContentProvider initContentProvider() {
        return new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                Object[] ret = null;
                if (inputElement instanceof WebApp) {
                    EList resources = ((WebApp)inputElement).getResourceRefs();
                    if (ResourceRefSelectionDialog.this.fTypeFilters != null) {
                        int i = resources.size() - 1;
                        while (i >= 0) {
                            ResourceRef ref = (ResourceRef)resources.get(i);
                            if (!ResourceRefSelectionDialog.this.fTypeFilters.contains(ref.getType())) {
                                resources.remove(i);
                            }
                            --i;
                        }
                    }
                    ret = resources.toArray((Object[])new ResourceRef[resources.size()]);
                }
                return ret;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    protected ILabelProvider initLabelProvider() {
        return new LabelProvider(){

            public Image getImage(Object element) {
                Image ret = UIConstants.RESOURCE_REF_IMAGE;
                return ret;
            }

            public String getText(Object element) {
                String ret = "";
                if (element != null && element instanceof ResourceRef) {
                    ResourceRef resourceRef = (ResourceRef)element;
                    ret = resourceRef.getName();
                }
                return ret;
            }
        };
    }

    protected void okPressed() {
        this.selectionChanged(this.fTable.getSelection());
        if (this.fWebArtifactEdit != null) {
            this.fWebArtifactEdit.dispose();
        }
        super.okPressed();
    }

    protected void selectionChanged(ISelection selection) {
        Iterator iter;
        Object o;
        if (selection != null && !selection.isEmpty() && (o = (iter = ((IStructuredSelection)selection).iterator()).next()) instanceof ResourceRef) {
            this.fResourceRef = null;
            this.fSelectedIndex = this.fTable.getTable().getSelectionIndex();
            this.setResult((ResourceRef)o);
            this.getOkButton().setEnabled(true);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event != null) {
            ISelection selection = event.getSelection();
            this.selectionChanged(selection);
            this.updateDialogStatus();
        }
    }

    protected void setResult(ResourceRef resourceRef) {
        Vector<ResourceRef> v = new Vector<ResourceRef>(1);
        if (resourceRef != null) {
            v.add(resourceRef);
            this.setResult(v);
            this.fResourceRef = resourceRef;
        }
    }

    public void setTypeFilters(List types) {
        this.fTypeFilters = types;
    }

    public void setWebArtifactEdit(WebArtifactEdit newWebNature) {
        this.fWebArtifactEdit = newWebNature;
    }

    protected void updateDialogStatus() {
        Status myStatusInfo = new Status(0, DeployJDBCPlugin.getDefault().getBundle().getSymbolicName(), 0, "", null);
        if (this.fTable.getTable().getItemCount() == 0) {
            myStatusInfo = new Status(4, DeployJDBCPlugin.getDefault().getBundle().getSymbolicName(), 0, ResourceHandler.No_entries_available, null);
        } else if (this.fTable.getSelection().isEmpty()) {
            myStatusInfo = new Status(4, DeployJDBCPlugin.getDefault().getBundle().getSymbolicName(), 0, ResourceHandler.Please_select_an_entry, null);
        }
        this.updateStatus((IStatus)myStatusInfo);
    }
}

