/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.sdo.jdbc.ui.internal.util;

import com.ibm.etools.sdo.jdbc.ui.internal.data.IConnectionData;
import com.ibm.etools.sdo.jdbc.ui.internal.util.DataAccessHelper;
import com.ibm.etools.sdo.jdbc.ui.internal.util.DatasourceConnectionWrapper;
import com.ibm.etools.sdo.jdbc.ui.internal.util.DriverManagerConnectionWrapper;
import com.ibm.etools.sdo.jdbc.ui.internal.util.RSCSQLVendorType;
import com.ibm.etools.sdo.jdbc.ui.internal.util.RuntimeConnectionWrapper;
import com.ibm.etools.sdo.jdbc.ui.internal.util.RuntimeUtil;
import com.ibm.etools.sdo.jdbc.ui.internal.util.WebAppUtil;
import com.ibm.etools.webtools.deploy.jdbc.internal.nls.ResourceHandler;
import com.ibm.icu.util.StringTokenizer;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.drivers.DriverManager;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileProvider;
import org.eclipse.datatools.connectivity.sqm.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.core.connection.DatabaseConnectionRegistry;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class RSCConnectionsHelper {
    private static final String DERBY_JAR = "derby.jar";
    private static final String CLASSPATH_DELIMITER = ";";
    private static final String DERBY_LIB_VARIABLE = "${DERBY_JDBC_DRIVER_PATH}";
    public static final String DRIVER_DEFINITION_PROP_ID = "org.eclipse.datatools.connectivity.driverDefinitionID";
    private static String CLOUDSCAPE_PREFIX = "cloudscape";
    private static String DERBY_PREFIX = "derby";

    public static IStatus connectWithPromptIfNeeded(IConnectionProfile profile, boolean reprompt, Shell shell) {
        IStatus connectionStatus = null;
        if (profile != null) {
            if (shell == null) {
                connectionStatus = profile.connect();
            } else {
                connectionStatus = profile.connectWithoutJob();
                if (reprompt) {
                    while (profile.getConnectionState() != 1 && connectionStatus.getCode() != 0) {
                        String title = NLS.bind((String)ResourceHandler.ConnectionPage_3, (Object[])new Object[]{profile.getName()});
                        MessageDialog.openInformation((Shell)shell, (String)title, (String)connectionStatus.getChildren()[0].getException().getLocalizedMessage());
                        PropertyDialogAction propertyDialogAction = new PropertyDialogAction((IShellProvider)new SameShellProvider((Control)shell), (ISelectionProvider)new ConnectionPropertiesWizardSelectionProvider(profile));
                        StructuredSelection selection = new StructuredSelection((Object)profile);
                        propertyDialogAction.selectionChanged((IStructuredSelection)selection);
                        if (!propertyDialogAction.isApplicableForSelection()) continue;
                        PreferenceDialog dialog = propertyDialogAction.createDialog();
                        String initialPage = ((ConnectionProfileProvider)profile.getProvider()).getPropertiesPersistenceHook().getConnectionPropertiesPageID();
                        if (initialPage != null) {
                            ((IWorkbenchPreferenceContainer)dialog).openPage(initialPage, null);
                        }
                        if (dialog.open() == 1) break;
                        connectionStatus = profile.connectWithoutJob();
                    }
                }
            }
        }
        return connectionStatus;
    }

    public static ConnectionInfo getConnectionInfoFromDatabase(Database db) {
        if (db != null) {
            ConnectionInfo connectionForDatabase = DatabaseConnectionRegistry.getConnectionForDatabase((Database)db);
            return connectionForDatabase;
        }
        return null;
    }

    private static Database getDatabase(String profileName, boolean connect, boolean reprompt, Shell shell) {
        block6: {
            IConnection ic;
            block8: {
                IManagedConnection mc;
                block7: {
                    IConnectionProfile profile = ProfileManager.getInstance().getProfileByName(profileName);
                    if (profile == null) break block6;
                    if (connect) {
                        RSCConnectionsHelper.connectWithPromptIfNeeded(profile, reprompt, shell);
                    }
                    if ((mc = profile.getManagedConnection(ConnectionInfo.class.getName())) == null) break block6;
                    ic = mc.getConnection();
                    if (ic != null) break block7;
                    return null;
                }
                if (mc.isConnected() || connect) break block8;
                return null;
            }
            try {
                Object rawConn = ic.getRawConnection();
                if (rawConn instanceof ConnectionInfo) {
                    ConnectionInfo ci = (ConnectionInfo)rawConn;
                    return ci.getSharedDatabase();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static Database getDatabaseAndInitializeConnection(IConnectionProfile profile, String connectionName, boolean repromptIfConnectionFails, Shell shell, IProgressMonitor monitor) throws Exception {
        String profilePassword;
        String userid;
        String relm;
        if (profile == null && connectionName == null) {
            return null;
        }
        Database rdbDatabase = null;
        if (profile == null) {
            profile = ProfileManager.getInstance().getProfileByName(connectionName);
        }
        if (profile == null) {
            throw new InstantiationException(NLS.bind((String)ResourceHandler.RSCConnectionsHelper_1, (Object)connectionName));
        }
        if (profile.getConnectionState() != 1) {
            relm = RSCConnectionsHelper.getRealm(profile);
            userid = ProfileUtil.getUserName((IConnectionProfile)profile);
            profilePassword = ProfileUtil.getPassword((IConnectionProfile)profile);
            String password = DataAccessHelper.recvData(relm, userid);
            if ((profilePassword == null || profilePassword.length() == 0) && password != null) {
                Properties baseProperties = profile.getBaseProperties();
                baseProperties.setProperty("org.eclipse.datatools.connectivity.db.password", password);
                profile.setBaseProperties(baseProperties);
            }
        }
        rdbDatabase = RSCConnectionsHelper.getDatabaseForProfile(profile, repromptIfConnectionFails, shell);
        relm = RSCConnectionsHelper.getRealm(profile);
        userid = ProfileUtil.getUserName((IConnectionProfile)profile);
        if (profile.getConnectionState() == 1) {
            profilePassword = ProfileUtil.getPassword((IConnectionProfile)profile);
            if (profilePassword != null) {
                DataAccessHelper.sendData(relm, userid, profilePassword);
            }
        } else {
            try {
                DataAccessHelper.sendData(relm, userid, null);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return rdbDatabase;
    }

    public static Database getDatabaseForProfile(IConnectionProfile connectionProfile, boolean reprompt, Shell shell) {
        return RSCConnectionsHelper.getDatabase(connectionProfile.getName(), true, reprompt, shell);
    }

    public static String getDatabaseName(IConnectionProfile profile) {
        return profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.databaseName");
    }

    public static String getDataSourceClassForMSSQLDriver(String driver) {
        String ret = "com.ddtek.jdbcx.sqlserver.SQLServerDataSource";
        if (driver != null) {
            if ("com.ddtek.jdbc.sqlserver.SQLServerDriver".equals(driver)) {
                ret = "com.ddtek.jdbcx.sqlserver.SQLServerDataSource";
            } else if ("com.merant.sequelink.jdbc.SequeLinkDriver".equals(driver)) {
                ret = "com.merant.sequelink.jdbcx.datasource.SequeLinkDataSource";
            } else if ("com.ddtek.jdbc.sequelink.SequeLinkDriver".equals(driver)) {
                ret = "com.ddtek.jdbcx.sequelink.SequeLinkDataSource";
            } else if ("com.microsoft.jdbc.sqlserver.SQLServerDriver".equals(driver)) {
                ret = "com.microsoft.jdbcx.sqlserver.SQLServerDataSource";
            } else if ("com.microsoft.sqlserver.jdbc.SQLServerDriver".equals(driver)) {
                ret = "com.microsoft.sqlserver.jdbc.SQLServerConnectionPoolDataSource";
            } else if ("com.ibm.websphere.jdbc.sqlserver.SQLServerDriver".equals(driver)) {
                ret = "com.ibm.websphere.jdbcx.sqlserver.SQLServerDataSource";
            }
        }
        return ret;
    }

    public static String getDataSourceHelperClassForMSSQLDataSource(String dataSource) {
        String ret = "com.ibm.websphere.rsadapter.ConnectJDBCDataStoreHelper";
        if (dataSource != null) {
            if ("com.ddtek.jdbcx.sqlserver.SQLServerDataSource".equals(dataSource)) {
                ret = "com.ibm.websphere.rsadapter.WSConnectJDBCDataStoreHelper";
            } else if ("com.ddtek.jdbcx.sequelink.SequeLinkDataSource".equals(dataSource)) {
                ret = "com.ibm.websphere.rsadapter.WSConnectJDBCDataStoreHelper";
            } else if ("com.ibm.websphere.jdbcx.sqlserver.SQLServerDataSource".equals(dataSource)) {
                ret = "com.ibm.websphere.rsadapter.WSConnectJDBCDataStoreHelper";
            }
        }
        return ret;
    }

    public static String getPasswordFromStore(IConnectionProfile profile, IConnectionData data) {
        String password = DataAccessHelper.recvData(RSCConnectionsHelper.getRealm(data), data.getUserName());
        if (password == null && profile != null) {
            password = profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.password");
            DataAccessHelper.sendData(RSCConnectionsHelper.getRealm(data), data.getUserName(), password);
        }
        return password;
    }

    public static String getRealm(IConnectionData connectionData) {
        String realm = connectionData.getServerName();
        int sqlVendorType = 0;
        RSCSQLVendorType vendorType = connectionData.getSQLVendorType();
        if (vendorType != null) {
            sqlVendorType = vendorType.getValue();
        }
        if (sqlVendorType < 0 && connectionData.getConnectionProfile() == null && connectionData.getURL() != null) {
            realm = RSCConnectionsHelper.getRealm(connectionData.getURL());
        } else {
            RSCSQLVendorType type;
            if (sqlVendorType < 0 && connectionData.getConnectionProfile() != null && (type = RSCConnectionsHelper.getSQLVendorType(connectionData.getConnectionProfile())) != null) {
                connectionData.setSQLVendorType(type);
            }
            String productName = connectionData.getProductName();
            realm = RSCConnectionsHelper.getRealmFromProductName(realm, productName);
        }
        return realm;
    }

    public static String getRealm(IConnectionProfile profile) {
        String realm = null;
        if (profile != null) {
            String url = profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.URL");
            realm = RSCConnectionsHelper.getRealm(url);
        }
        return realm;
    }

    public static String getRealm(RuntimeConnectionWrapper rcw) {
        String realm = null;
        if (rcw instanceof DatasourceConnectionWrapper) {
            DatasourceConnectionWrapper dcw = (DatasourceConnectionWrapper)rcw;
            realm = dcw.getServerName();
            RSCSQLVendorType type = RSCSQLVendorType.get(dcw.getSqlVendorType());
            String productName = type != null ? type.getProductName() : "";
            realm = RSCConnectionsHelper.getRealmFromProductName(realm, productName);
        } else if (rcw instanceof DriverManagerConnectionWrapper) {
            realm = RSCConnectionsHelper.getRealm(((DriverManagerConnectionWrapper)rcw).getUrl());
        }
        return realm;
    }

    public static String getRealm(String url) {
        int end;
        int start;
        String realm = RSCConnectionsHelper.parseServerNameDefaultToLocalhost(url);
        if (url != null && (start = url.indexOf(":") + 1) > 0 && (end = url.substring(start).indexOf(":") + start) > -1) {
            String productName = url.substring(start, end);
            realm = RSCConnectionsHelper.getRealmFromProductName(realm, productName);
        }
        return realm;
    }

    private static String getRealmFromProductName(String realm, String productName) {
        if (RSCConnectionsHelper.isCloudDatabase(productName)) {
            realm = RSCConnectionsHelper.getVendorSpecificRealm(CLOUDSCAPE_PREFIX, realm);
        } else if (RSCConnectionsHelper.isDerbyDatabase(productName)) {
            realm = RSCConnectionsHelper.getVendorSpecificRealm(DERBY_PREFIX, realm);
        }
        return realm;
    }

    public static RSCSQLVendorType getSQLVendorType(IConnectionProfile profile) {
        if (profile == null) {
            return RSCSQLVendorType.get("", "");
        }
        String product = profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.vendor");
        String version = profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.version");
        RSCSQLVendorType type = RSCSQLVendorType.get(product, version);
        return type;
    }

    private static String getVendorSpecificRealm(String vendorid, String serverName) {
        return String.valueOf(vendorid) + ":" + serverName;
    }

    public static boolean hasJ2CCJar(IConnectionData data) {
        return RSCConnectionsHelper.hasJ2CCJar(data.getClassLocation());
    }

    public static boolean hasJ2CCJar(String classLocation) {
        boolean ret = false;
        if (classLocation != null && classLocation.indexOf("db2jcc.jar") != -1) {
            ret = true;
        }
        return ret;
    }

    public static boolean isCloud10Database(String productName) {
        return "Cloudscape".equals(productName) && productName.indexOf("8.2") != -1;
    }

    public static boolean isCloudDatabase(String productName) {
        return "Cloudscape".equalsIgnoreCase(productName);
    }

    public static boolean isDB2Database(String productName) {
        return productName.startsWith("DB2 UDB");
    }

    public static boolean isDB2DatabaseForAS400(String productName) {
        return "DB2 UDB iSeries".equals(productName);
    }

    public static boolean isDebryClientDriver(String driverClass) {
        boolean ret = false;
        if (driverClass != null && driverClass.indexOf("org.apache.derby.jdbc.Client") != -1) {
            ret = true;
        }
        return ret;
    }

    public static boolean isDerbyDatabase(String productName) {
        return "Derby".equalsIgnoreCase(productName);
    }

    public static boolean isInformixDatabase(String productName) {
        return "Informix".equals(productName);
    }

    public static boolean isMSSQLDatabase(String productName) {
        return "SQL Server".equals(productName);
    }

    public static boolean isOracleDatabase(String productName) {
        return "Oracle".equals(productName);
    }

    public static boolean isSybaseDatabase(String productName) {
        return "Sybase".equals(productName);
    }

    public static Database loadRDBDatabase(ConnectionInfo rdbConnection, Shell shell, IProgressMonitor monitor) {
        Database rdbDatabase = null;
        if (monitor != null) {
            monitor.done();
        }
        return rdbDatabase;
    }

    private static Database loadRDBDatabase(IResource res, IProgressMonitor monitor, String ext) {
        Database rdbDatabase = null;
        if (monitor != null) {
            monitor.beginTask(ResourceHandler.RSCConnectionsHelper_Load_Imported_Database_1, 3);
        }
        if (monitor != null) {
            monitor.done();
        }
        return rdbDatabase;
    }

    public static Database loadRDBDatabase(IResource res, Shell shell, IProgressMonitor monitor) {
        Database rdbDatabase = null;
        String ext = res.getFileExtension();
        rdbDatabase = shell != null && !shell.isDisposed() ? RSCConnectionsHelper.loadRDBDatabase(res, monitor, ext) : RSCConnectionsHelper.loadRDBDatabase(res, monitor, ext);
        return rdbDatabase;
    }

    public static boolean needsJ2CCJar(IConnectionData data) {
        boolean ret = false;
        IConnectionProfile connectionProfile = data.getConnectionProfile();
        if (connectionProfile != null) {
            String productName = connectionProfile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.vendor");
            if (productName == null && data.getRDBDatabase() != null) {
                productName = data.getRDBDatabase().getVendor();
            }
            if ("DB2 UDB".equals(productName) && data.isDataSource() && data.getPortNumber() != -1 && data.getPortNumber() != 0) {
                ret = true;
            }
        }
        return ret;
    }

    public static boolean needsServerName(IConnectionData data) {
        return RSCConnectionsHelper.needsJ2CCJar(data);
    }

    public static int parsePortNumber(IConnectionProfile profile) {
        String url;
        int portNum;
        block9: {
            if (profile == null) {
                return -1;
            }
            portNum = -1;
            url = profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.URL");
            try {
                int i;
                int n = i = url != null ? url.indexOf(":") : -1;
                if (i != -1) {
                    while (i < url.length()) {
                        if (url.charAt(i) == ':') {
                            int index = i + 1;
                            StringBuffer portBuffer = new StringBuffer("");
                            while (index < url.length()) {
                                if (!Character.isDigit(url.charAt(index))) break;
                                portBuffer.append(url.charAt(index));
                                ++index;
                            }
                            if (portBuffer.toString().length() > 0) {
                                portNum = Integer.parseInt(portBuffer.toString());
                                break block9;
                            }
                        }
                        ++i;
                    }
                    break block9;
                }
                portNum = -1;
            }
            catch (NumberFormatException numberFormatException) {
                portNum = -1;
            }
        }
        String DB2_URL_START = "jdbc:db2:";
        if (portNum == -1 && url != null && url.startsWith(DB2_URL_START)) {
            portNum = 50000;
        }
        return portNum;
    }

    public static String parseServerName(String url) {
        boolean foundHostName;
        String serverName = null;
        int start = url != null ? url.indexOf("//") + 2 : -1;
        boolean bl = foundHostName = start != 1;
        if (!foundHostName) {
            start = url != null ? url.indexOf("@") + 1 : -1;
            boolean bl2 = foundHostName = start != 0;
        }
        if (!foundHostName) {
            start = url != null ? url.indexOf("Tds:") + 4 : -1;
            boolean bl3 = foundHostName = start != 3;
        }
        if (!foundHostName) {
            int n = start = url != null ? url.indexOf("as400:") + 6 : -1;
            if (url != null && start != -1 && start < url.length()) {
                String subString = url.substring(start);
                int end = subString.indexOf(CLASSPATH_DELIMITER);
                serverName = end != -1 ? subString.substring(0, end) : subString.substring(0, subString.length());
                return serverName;
            }
        }
        if (foundHostName && start > 1 && url.length() > start) {
            int end;
            String subString = url.substring(start);
            int n = end = subString != null ? subString.indexOf(":") : -1;
            if (end != -1) {
                serverName = subString.substring(0, end);
            }
        }
        return serverName;
    }

    public static String parseServerNameDefaultToLocalhost(String url) {
        String serverName = RSCConnectionsHelper.parseServerName(url);
        if (serverName == null) {
            serverName = "localhost";
        }
        return serverName;
    }

    private static void setCloudscapeDBLocation(IConnectionData data) {
        int index = -1;
        index = data.getURL().indexOf(":");
        if (index != -1 && (index = data.getURL().indexOf(":", index + 1)) != -1) {
            int end = data.getURL().substring(index + 1).lastIndexOf(CLASSPATH_DELIMITER);
            if (end > index) {
                data.setDatabaseLocation(data.getURL().substring(index + 1, end + (index + 1)));
            } else {
                data.setDatabaseLocation(data.getURL().substring(index + 1));
            }
        }
    }

    private static void setInformixDBLocation(IConnectionData data) {
        int indexOfServer;
        String url = data.getURL();
        if (url != null && (indexOfServer = url.indexOf("INFORMIXSERVER=")) != -1) {
            StringBuffer serverBuffer = new StringBuffer("");
            int i = indexOfServer += 15;
            while (i < url.length()) {
                if (url.charAt(i) == ';') break;
                serverBuffer.append(url.charAt(i));
                ++i;
            }
            if (serverBuffer.toString().length() > 0) {
                data.setDatabaseLocation(serverBuffer.toString());
            }
        }
    }

    public static void setRuntimeDefaults(IConnectionProfile profile, IConnectionData data) {
        String driverName = "";
        String url = "";
        String userName = "";
        if (profile != null) {
            String profiledriverName = profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.driverClass");
            driverName = profiledriverName != null ? profiledriverName : "";
            userName = profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.username");
            String profileUrl = profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.URL");
            url = profileUrl != null ? profileUrl : "";
            data.setDriver(driverName);
            data.setUserName(userName);
            data.setURL(url);
            String driverDefinitionId = profile.getBaseProperties().getProperty(DRIVER_DEFINITION_PROP_ID);
            String jarList = null;
            if (driverDefinitionId != null) {
                DriverInstance driverInstanceByID = DriverManager.getInstance().getDriverInstanceByID(driverDefinitionId);
                if (driverInstanceByID != null && (jarList = driverInstanceByID.getJarList()) != null) {
                    jarList = jarList.replace(',', ';');
                }
                data.setClassLocation(jarList);
            }
            if (data.getConnectionId() != null && data.getConnectionId().length() > 0) {
                data.setResourceRefName(data.getConnectionId());
            } else {
                data.setResourceRefName(profile.getName());
            }
            data.setDatabaseName(profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.databaseName"));
            data.setServerName(RSCConnectionsHelper.parseServerNameDefaultToLocalhost(profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.URL")));
            RSCConnectionsHelper.getPasswordFromStore(profile, data);
            data.setPassword(null);
            data.setJNDIName("jdbc/" + data.getConnectionId());
            try {
                RSCSQLVendorType type = RSCConnectionsHelper.getSQLVendorType(profile);
                if (type != null) {
                    IFacetedProject facetedProject;
                    data.setSQLVendorType(type);
                    IProject project = data.getProject();
                    boolean useDataSource = false;
                    IRuntime runtime = null;
                    if (WebAppUtil.isWebProject(project) || WebAppUtil.isEJBProject(project) || WebAppUtil.isUtilityProject(project)) {
                        facetedProject = ProjectFacetsManager.create((IProject)project);
                        runtime = facetedProject.getPrimaryRuntime();
                        boolean targetedAtSupportedSDORuntime = false;
                        if (runtime != null && (targetedAtSupportedSDORuntime = RuntimeUtil.isTargetedAtSupportedSDORuntime(runtime))) {
                            useDataSource = true;
                        }
                    }
                    if (RSCConnectionsHelper.isDB2Database(data.getProductName()) || RSCConnectionsHelper.isCloudDatabase(data.getProductName()) || RSCConnectionsHelper.isDerbyDatabase(data.getProductName()) || RSCConnectionsHelper.isOracleDatabase(data.getProductName()) || RSCConnectionsHelper.isInformixDatabase(data.getProductName()) || RSCConnectionsHelper.isSybaseDatabase(data.getProductName()) || RSCConnectionsHelper.isMSSQLDatabase(data.getProductName())) {
                        data.setIsDataSource(useDataSource);
                        if (RSCConnectionsHelper.isDB2Database(data.getProductName())) {
                            if (RSCConnectionsHelper.hasJ2CCJar(data)) {
                                data.setDataSourceClassName("com.ibm.db2.jcc.DB2ConnectionPoolDataSource");
                            } else if (RSCConnectionsHelper.isDB2DatabaseForAS400(data.getProductName())) {
                                data.setDataSourceClassName("com.ibm.as400.access.AS400JDBCConnectionPoolDataSource");
                            } else {
                                data.setDataSourceClassName("COM.ibm.db2.jdbc.DB2ConnectionPoolDataSource");
                            }
                        } else if (RSCConnectionsHelper.isDerbyDatabase(data.getProductName())) {
                            if (RSCConnectionsHelper.hasJ2CCJar(data)) {
                                data.setDataSourceClassName("com.ibm.db2.jcc.DB2ConnectionPoolDataSource");
                            } else if (RSCConnectionsHelper.isDebryClientDriver(data.getDriver())) {
                                data.setDataSourceClassName("org.apache.derby.jdbc.ClientConnectionPoolDataSource");
                            } else {
                                RSCConnectionsHelper.setCloudscapeDBLocation(data);
                                if (runtime == null) {
                                    facetedProject = ProjectFacetsManager.create((IProject)project);
                                    runtime = facetedProject.getPrimaryRuntime();
                                }
                                if (runtime != null && RuntimeUtil.isTargetedAtWASV61(runtime) || RuntimeUtil.isTargetedAtWASV70(runtime)) {
                                    String classLocation = data.getClassLocation();
                                    String newClassLocation = "";
                                    if (classLocation.contains(DERBY_JAR)) {
                                        StringTokenizer toker = new StringTokenizer(classLocation, CLASSPATH_DELIMITER);
                                        while (toker.hasMoreTokens()) {
                                            String nextToken = toker.nextToken();
                                            if (nextToken.contains(DERBY_JAR)) {
                                                nextToken = "${DERBY_JDBC_DRIVER_PATH}/derby.jar";
                                            }
                                            newClassLocation = String.valueOf(newClassLocation) + nextToken;
                                            if (!toker.hasMoreTokens()) continue;
                                            newClassLocation = String.valueOf(newClassLocation) + CLASSPATH_DELIMITER;
                                        }
                                    }
                                    if (newClassLocation.length() > 0) {
                                        data.setClassLocation(newClassLocation);
                                    }
                                }
                                data.setDataSourceClassName("org.apache.derby.jdbc.EmbeddedConnectionPoolDataSource");
                            }
                        } else if (RSCConnectionsHelper.isCloudDatabase(data.getProductName())) {
                            RSCConnectionsHelper.setCloudscapeDBLocation(data);
                            if (RSCConnectionsHelper.isCloud10Database(data.getProductName())) {
                                data.setDataSourceClassName("org.apache.derby.jdbc.EmbeddedConnectionPoolDataSource");
                            } else {
                                data.setDataSourceClassName("com.ibm.db2j.jdbc.DB2jConnectionPoolDataSource");
                            }
                        } else if (RSCConnectionsHelper.isOracleDatabase(data.getProductName())) {
                            data.setDataSourceClassName("oracle.jdbc.pool.OracleConnectionPoolDataSource");
                        } else if (RSCConnectionsHelper.isMSSQLDatabase(data.getProductName())) {
                            data.setDataSourceClassName(RSCConnectionsHelper.getDataSourceClassForMSSQLDriver(data.getDriver()));
                        } else if (RSCConnectionsHelper.isInformixDatabase(data.getProductName())) {
                            StringBuffer classPath = new StringBuffer(data.getClassLocation());
                            if (classPath.indexOf("ifxjdbcx.jar") == -1 && classPath.indexOf("ifxjdbc.jar") != -1) {
                                StringTokenizer toker = new StringTokenizer(data.getClassLocation(), CLASSPATH_DELIMITER);
                                while (toker.hasMoreTokens()) {
                                    Path path = new Path(toker.nextToken());
                                    if (path.lastSegment().equals("ifxjdbc.jar")) {
                                        path = path.removeLastSegments(1);
                                        path = path.append("ifxjdbcx.jar");
                                        classPath.insert(0, String.valueOf(path.toOSString()) + CLASSPATH_DELIMITER);
                                    }
                                    data.setClassLocation(classPath.toString());
                                }
                            }
                            RSCConnectionsHelper.setInformixDBLocation(data);
                            data.setDataSourceClassName("com.informix.jdbcx.IfxConnectionPoolDataSource");
                        } else if (RSCConnectionsHelper.isSybaseDatabase(data.getProductName())) {
                            data.setDataSourceClassName("com.sybase.jdbc2.jdbc.SybConnectionPoolDataSource");
                        }
                    }
                    data.setPortNumber(RSCConnectionsHelper.parsePortNumber(profile));
                }
            }
            catch (Throwable throwable) {}
        }
    }

    private static final class ConnectionPropertiesWizardSelectionProvider
    implements ISelectionProvider {
        private IStructuredSelection selection;

        public ConnectionPropertiesWizardSelectionProvider(IConnectionProfile connectionProfile) {
            this.selection = new StructuredSelection((Object)connectionProfile);
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public ISelection getSelection() {
            return this.selection;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public void setSelection(ISelection selection) {
        }
    }
}

