/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.sdo.jdbc.ui.internal.util;

import com.ibm.etools.sdo.jdbc.ui.internal.util.RSCConnectionsHelper;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.datatools.connectivity.sqm.internal.core.util.CatalogUtil;
import org.eclipse.datatools.modelbase.sql.constraints.ForeignKey;
import org.eclipse.datatools.modelbase.sql.constraints.Index;
import org.eclipse.datatools.modelbase.sql.constraints.UniqueConstraint;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.PrimitiveType;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class RDBUtil {
    private static int fPercentComplete = 0;

    public static int compareIdentifiers(Database database, String identifier, String lookupName) {
        int compResult = -1;
        String delimiter = "\"";
        if (lookupName.startsWith(delimiter)) {
            if (identifier.startsWith(delimiter)) {
                compResult = identifier.compareTo(lookupName);
            } else if (lookupName.endsWith(delimiter)) {
                String lookupNameContent = lookupName.substring(1, lookupName.length() - 1);
                compResult = identifier.compareTo(lookupNameContent);
            }
        } else {
            compResult = identifier.compareToIgnoreCase(lookupName);
        }
        return compResult;
    }

    public static List getDependentBaseTables(BaseTable table, IProgressMonitor monitor) {
        ArrayList<BaseTable> ret = new ArrayList<BaseTable>();
        RDBUtil.setPercentComplete(0);
        double innerCount = 0.0;
        double outerCount = 0.0;
        int increment = 10;
        EList schemas = table.getSchema().getDatabase().getSchemas();
        SubProgressMonitor loadSchemaMonitor = new SubProgressMonitor(monitor, increment, 4);
        loadSchemaMonitor.beginTask(table.getSchema().getDatabase().getName(), table.getSchema().getDatabase().getSchemas().size() * increment);
        double outerParts = schemas.size() * increment;
        double innerSubInc = 100.0 / (outerParts / (double)increment);
        CatalogUtil catalogUtil = new CatalogUtil();
        int i = 0;
        while (i < schemas.size()) {
            if (monitor.isCanceled()) break;
            Schema schema = (Schema)schemas.get(i);
            EList tables = schema.getTables();
            SubProgressMonitor spm = new SubProgressMonitor((IProgressMonitor)loadSchemaMonitor, increment, 4);
            double innerParts = tables.size();
            innerCount = 0.0;
            spm.beginTask(schema.getName(), (int)innerParts * increment);
            int size = tables.size();
            int j = 0;
            while (j < size) {
                Table element = (Table)tables.get(j);
                spm.subTask(element.getName());
                if (element instanceof BaseTable) {
                    if (monitor.isCanceled()) break;
                    try {
                        catalogUtil.load((EObject)element, (IProgressMonitor)spm, increment);
                    }
                    catch (RuntimeException e) {
                        e.printStackTrace();
                    }
                }
                double innerPercent = (innerCount += 1.0) / innerParts * innerSubInc;
                double percent = outerCount / outerParts * 100.0 + innerPercent;
                RDBUtil.setPercentComplete((int)percent);
                ++j;
            }
            loadSchemaMonitor.worked(increment);
            double percent = (outerCount += (double)increment) / outerParts * 100.0;
            RDBUtil.setPercentComplete((int)percent);
            ++i;
        }
        EList keys = table.getReferencingForeignKeys();
        int i2 = 0;
        while (i2 < keys.size()) {
            ret.add(((ForeignKey)keys.get(i2)).getBaseTable());
            ++i2;
        }
        if (table.getPrimaryKey() != null) {
            keys = table.getPrimaryKey().getForeignKey();
            i2 = 0;
            while (i2 < keys.size()) {
                BaseTable refTable = ((ForeignKey)keys.get(i2)).getBaseTable();
                if (!ret.contains(refTable)) {
                    ret.add(refTable);
                }
                ++i2;
            }
        }
        return ret;
    }

    public static BaseTable getForeignKeyParentTable(ForeignKey foreignKey) {
        UniqueConstraint uniqueConstraint = foreignKey.getUniqueConstraint();
        Index index = foreignKey.getUniqueIndex();
        BaseTable parentTable = null;
        if (uniqueConstraint != null) {
            parentTable = uniqueConstraint.getBaseTable();
        } else if (index != null) {
            parentTable = (BaseTable)index.getTable();
        }
        return parentTable;
    }

    public static int getJDBCType(DataType dataType) {
        int ret = 2000;
        if (dataType instanceof PredefinedDataType) {
            PredefinedDataType primType = (PredefinedDataType)dataType;
            ret = RDBUtil.getJDBCType(primType);
        }
        return ret;
    }

    public static int getJDBCType(PredefinedDataType type) {
        return RDBUtil.getJDBCType(type.getPrimitiveType());
    }

    public static int getJDBCType(PrimitiveType type) {
        switch (type.getValue()) {
            case 13: {
                return -5;
            }
            case 6: {
                return -2;
            }
            case 8: {
                return 2004;
            }
            case 7: {
                return -3;
            }
            case 17: {
                return 16;
            }
            case 0: {
                return 1;
            }
            case 2: {
                return 2005;
            }
            case 1: {
                return 12;
            }
            case 22: {
                return 70;
            }
            case 18: {
                return 91;
            }
            case 10: {
                return 3;
            }
            case 16: {
                return 8;
            }
            case 14: {
                return 6;
            }
            case 12: {
                return 4;
            }
            case 21: {
                return 1111;
            }
            case 3: {
                return 1;
            }
            case 5: {
                return 2005;
            }
            case 4: {
                return 12;
            }
            case 9: {
                return 2;
            }
            case 15: {
                return 7;
            }
            case 11: {
                return 5;
            }
            case 19: {
                return 92;
            }
            case 20: {
                return 93;
            }
            case 23: {
                return 1111;
            }
        }
        return 1111;
    }

    public static synchronized int getPercentComplete() {
        return fPercentComplete;
    }

    public static String getQualifiedName(Table table) {
        if (table == null) {
            return "";
        }
        StringBuffer name = new StringBuffer(table.getName());
        if (table.getSchema() != null && table.getSchema().getName() != null && table.getSchema().getName().length() > 0) {
            name.insert(0, ".");
            name.insert(0, table.getSchema().getName());
        }
        return name.toString();
    }

    public static boolean isColumnSupported(Column column) {
        Schema schema;
        Table table;
        boolean ret = true;
        if (column != null && (table = column.getTable()) != null && (schema = table.getSchema()) != null) {
            Database database = schema.getDatabase();
            if (database != null) {
                String vendor = database.getVendor();
                if (vendor != null && RSCConnectionsHelper.isOracleDatabase(vendor)) {
                    ret = RDBUtil.isOracleColumnSupported(column);
                }
            } else {
                Catalog catalog = schema.getCatalog();
                if (catalog != null) {
                    database = catalog.getDatabase();
                    ret = RDBUtil.isOracleColumnSupported(column);
                }
            }
        }
        return ret;
    }

    public static boolean isOracleColumnSupported(Column column) {
        boolean ret = true;
        DataType type = column.getDataType();
        if (type == null) {
            return ret;
        }
        if ("BFILE".equals(type.getName())) {
            ret = false;
        } else if ("LONG".equals(type.getName())) {
            ret = false;
        } else if ("NCHAR".equals(type.getName())) {
            ret = false;
        } else if ("NCLOB".equals(type.getName())) {
            ret = false;
        } else if ("NVARCHAR2".equals(type.getName())) {
            ret = false;
        } else if ("RAW".equals(type.getName())) {
            ret = false;
        } else if ("LONG RAW".equals(type.getName())) {
            ret = false;
        }
        return ret;
    }

    public static synchronized void setPercentComplete(int percentComplete) {
        fPercentComplete = percentComplete;
    }
}

