/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.sdo.jdbc.ui.internal.util;

import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class DialogUtil {
    public static final int BEGINNING = 1;
    public static final int CENTER = 2;
    public static final int END = 3;
    public static final int FILL = 4;
    public static final int LEFT = 1;
    public static final int RIGHT = 3;
    public static final int TOP = 1;
    public static final int MIDDLE = 2;
    public static final int BOTTOM = 3;
    public static final int INDENT_SIZE = 6;
    public static final int HYPERLINK_FIRE_EVENT = 666;

    public static Button createButton(Composite parent, String text, int style, GridData gridData) {
        if (parent == null) {
            return null;
        }
        Button button = new Button(parent, style);
        if (text != null) {
            button.setText(text);
        }
        if (gridData != null) {
            button.setLayoutData((Object)gridData);
        }
        return button;
    }

    public static Canvas createCanvas(Composite parent) {
        Canvas canvas = new Canvas(parent, 2048);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        canvas.setLayoutData((Object)data);
        return canvas;
    }

    public static CCombo createCCombo(Composite parent, int style) {
        CCombo l = new CCombo(parent, style);
        GridData data = new GridData(256);
        data.grabExcessHorizontalSpace = true;
        l.setLayoutData((Object)data);
        return l;
    }

    public static Button createCheckBox(Composite group, String label) {
        return DialogUtil.createCheckBox(group, label, null);
    }

    public static Button createCheckBox(Composite group, String label, SelectionListener slistener) {
        Button button = new Button(group, 16416);
        button.setText(label);
        if (slistener != null) {
            button.addSelectionListener(slistener);
        }
        GridData data = new GridData();
        button.setLayoutData((Object)data);
        return button;
    }

    public static Combo createCombo(Composite parent, int style) {
        GridData data = new GridData(256);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = false;
        Combo l = DialogUtil.createCombo(parent, null, style, data);
        return l;
    }

    public static Combo createCombo(Composite parent, String[] items, int style, GridData gridData) {
        if (parent == null) {
            return null;
        }
        Combo combo = new Combo(parent, style);
        if (items != null) {
            combo.setItems(items);
            combo.select(0);
        }
        if (gridData != null) {
            combo.setLayoutData((Object)gridData);
        }
        return combo;
    }

    public static Composite createComposite(Composite parent, int numColumns) {
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        Composite composite = DialogUtil.createComposite(parent, 0, layout, data);
        return composite;
    }

    public static Composite createComposite(Composite parent, int style, GridLayout gridLayout, GridData gridData) {
        Composite composite = new Composite(parent, style);
        if (gridLayout != null) {
            composite.setLayout((Layout)gridLayout);
        }
        if (gridData != null) {
            composite.setLayoutData((Object)gridData);
        }
        return composite;
    }

    public static Composite createComposite(Composite parent, int numColumns, int align, int valign) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = numColumns;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 3;
        gridLayout.verticalSpacing = 3;
        GridData gridData = new GridData();
        if (align == 2) {
            gridData.horizontalAlignment = 2;
            gridData.grabExcessHorizontalSpace = true;
        } else if (align == 3) {
            gridData.horizontalAlignment = 3;
            gridData.grabExcessHorizontalSpace = true;
        } else if (align == 4) {
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
        }
        if (valign == 2) {
            gridData.verticalAlignment = 2;
            gridData.grabExcessVerticalSpace = true;
        } else if (valign == 3) {
            gridData.verticalAlignment = 3;
            gridData.grabExcessVerticalSpace = true;
        } else if (valign == 4) {
            gridData.verticalAlignment = 4;
            gridData.grabExcessVerticalSpace = true;
        }
        return DialogUtil.createComposite(parent, 0, gridLayout, gridData);
    }

    public static Group createGroup(Composite parent, int numColumns) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.horizontalSpacing = 2;
        group.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)data);
        return group;
    }

    public static Hyperlink createHyperLink(Composite parent, String label) {
        final FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        toolkit.setBackground(parent.getBackground());
        Hyperlink ret = toolkit.createHyperlink(parent, label, 64);
        GridData data = new GridData(32);
        ret.setLayoutData((Object)data);
        ret.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                toolkit.dispose();
            }
        });
        return ret;
    }

    public static Label createLabel(Composite parent, String text) {
        GridData data = new GridData(256);
        Label label = DialogUtil.createLabel(parent, text, 16448, data);
        return label;
    }

    public static Label createLabel(Composite parent, String text, int style, GridData gridData) {
        if (parent == null) {
            return null;
        }
        Label label = new Label(parent, style);
        if (text != null) {
            label.setText(text);
        }
        if (gridData != null) {
            label.setLayoutData((Object)gridData);
        }
        return label;
    }

    public static Link createLink(Composite parent, String label) {
        Link newLink = new Link(parent, 64);
        newLink.setText(label);
        GridData gd = new GridData(4, 4, true, true);
        newLink.setLayoutData((Object)gd);
        return newLink;
    }

    public static Table createList(Composite parent, int iStyle) {
        Table t = new Table(parent, 2052);
        GridData data = new GridData();
        data.heightHint = t.getItemHeight() * 3;
        data.horizontalAlignment = 4;
        t.setLayoutData((Object)data);
        return t;
    }

    public static List createListBox(Composite parent) {
        List l = new List(parent, 2052);
        GridData data = new GridData();
        data.heightHint = l.getItemHeight() * 3;
        data.horizontalAlignment = 4;
        l.setLayoutData((Object)data);
        return l;
    }

    public static Button createMultiMenuButton(Composite parent, String label, MenuManager menuMgr) {
        Button button = new Button(parent, 8);
        button.setText(label);
        Display display = button.getDisplay();
        Font font = button.getFont();
        GC gc = new GC((Drawable)display);
        gc.setFont(font);
        Point size = gc.textExtent(String.valueOf(label) + "....");
        size.x += 10;
        size.y = size.y < 9 ? 9 : size.y;
        gc.dispose();
        Color fg = display.getSystemColor(21);
        Color bg = display.getSystemColor(22);
        RGB[] colormap = new RGB[]{bg.getRGB(), fg.getRGB()};
        ImageData imageData = new ImageData(size.x, size.y, 8, new PaletteData(colormap));
        Image image = new Image((Device)display, imageData);
        image.setBackground(bg);
        gc = new GC((Drawable)image);
        gc.setFont(font);
        gc.setBackground(bg);
        gc.setForeground(fg);
        gc.fillRectangle(0, 0, size.x, size.y);
        gc.drawText(String.valueOf(label) + "...", 0, 0);
        gc.setBackground(fg);
        int[] triangle = new int[]{size.x - 10, size.y - 7, size.x - 3, size.y - 7, size.x - 7, size.y - 3};
        gc.fillPolygon(triangle);
        gc.dispose();
        button.setImage(image);
        button.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Image img;
                if (e.widget instanceof Button && (img = ((Button)e.widget).getImage()) != null) {
                    img.dispose();
                }
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)button);
        button.setMenu(menu);
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                Widget w = e.widget;
                if (w instanceof Control) {
                    Control control = (Control)w;
                    Point p = control.getLocation();
                    Rectangle r = control.getBounds();
                    p.y += r.height;
                    p = control.getParent().toDisplay(p);
                    control.getMenu().setLocation(p.x, p.y);
                    control.getMenu().setVisible(true);
                }
            }
        });
        return button;
    }

    public static Button createPushButton(Composite parent, String label) {
        Button button = new Button(parent, 8);
        button.setText(label);
        GridData data = new GridData(256);
        button.setLayoutData((Object)data);
        return button;
    }

    public static Button createRadioButton(Composite group, String label) {
        return DialogUtil.createRadioButton(group, label, 16384);
    }

    public static Button createRadioButton(Composite group, String label, int style) {
        Button button = new Button(group, 0x10 | style);
        button.setText(label);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        button.setLayoutData((Object)data);
        return button;
    }

    public static ScrolledComposite createScrolledComposite(Composite parent) {
        ScrolledComposite composite = new ScrolledComposite(parent, 776);
        composite.setExpandHorizontal(true);
        composite.setExpandVertical(true);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        return composite;
    }

    public static Label createSeparator(Composite parent, int horizontalSpan) {
        GridData data = new GridData(256);
        data.horizontalSpan = horizontalSpan;
        Label label = new Label(parent, 258);
        label.setLayoutData((Object)data);
        return label;
    }

    public static Text createText(Composite parent, int style, GridData gridData) {
        if (parent == null) {
            return null;
        }
        Text text = new Text(parent, style);
        if (gridData != null) {
            text.setLayoutData((Object)gridData);
        }
        return text;
    }

    public static Text createTextArea(Composite parent) {
        Text text = new Text(parent, 2882);
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        text.setLayoutData((Object)data);
        return text;
    }

    public static Text createTextField(Composite parent) {
        Text text = new Text(parent, 2052);
        GridData data = new GridData(256);
        data.grabExcessHorizontalSpace = true;
        text.setLayoutData((Object)data);
        return text;
    }
}

