/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.sdo.jdbc.ui.internal.util;

import com.ibm.etools.sdo.jdbc.ui.internal.util.RSCConnectionsHelper;
import com.ibm.etools.sdo.jdbc.ui.internal.util.RSCSQLVendorType;
import com.ibm.etools.sdo.jdbc.ui.internal.util.RuntimeConnectionWrapper;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.DatasourceConnection;

public class DatasourceConnectionWrapper
extends RuntimeConnectionWrapper {
    private DatasourceConnection fDatasourceConnection;

    public DatasourceConnectionWrapper(DatasourceConnection runtimeConnection) {
        super(runtimeConnection);
        this.fDatasourceConnection = runtimeConnection;
    }

    public String getClassname() {
        return this.fDatasourceConnection.getClassname();
    }

    public String getConnectionString() {
        return this.fDatasourceConnection.getConnectionString();
    }

    public String getDatabaseLocation() {
        return this.fDatasourceConnection.getDatabaseLocation();
    }

    public String getDatabaseName() {
        return this.fDatasourceConnection.getDatabaseName();
    }

    public String getJndiName() {
        return this.fDatasourceConnection.getJndiName();
    }

    public String getPassword() {
        return this.fDatasourceConnection.getPassword();
    }

    public int getPortNumber() {
        return this.fDatasourceConnection.getPortNumber();
    }

    public String getResourceReferenceName() {
        return this.fDatasourceConnection.getResourceReferenceName();
    }

    public String getServerName() {
        return this.fDatasourceConnection.getServerName();
    }

    public int getSqlVendorType() {
        return this.fDatasourceConnection.getSqlVendorType();
    }

    public String getURL() {
        String ret = null;
        if (RSCConnectionsHelper.isOracleDatabase(RSCSQLVendorType.get(this.getSqlVendorType()).getProductName())) {
            ret = "jdbc:oracle:thin:@" + this.getServerName() + ":" + this.getPortNumber() + ":" + this.getDatabaseName();
        } else if (RSCConnectionsHelper.isMSSQLDatabase(RSCSQLVendorType.get(this.getSqlVendorType()).getProductName())) {
            ret = "jdbc:ibm:sqlserver://" + this.getServerName() + ":" + this.getPortNumber() + ";" + "DatabaseName=" + this.getDatabaseName();
        }
        return ret;
    }

    public String getUserid() {
        return this.fDatasourceConnection.getUserid();
    }

    public boolean isSetAutoDeploy() {
        return this.fDatasourceConnection.isSetAutoDeploy();
    }

    public boolean isSetPortNumber() {
        return this.fDatasourceConnection.isSetPortNumber();
    }

    public boolean isSetSqlVendorType() {
        return this.fDatasourceConnection.isSetSqlVendorType();
    }

    public void setClassname(String classname) {
        this.fDatasourceConnection.setClassname(classname);
    }

    public void setDatabaseLocation(String arg0) {
        this.fDatasourceConnection.setDatabaseLocation(arg0);
    }

    public void setDatabaseName(String value) {
        this.fDatasourceConnection.setDatabaseName(value);
    }

    public void setJndiName(String value) {
        this.fDatasourceConnection.setJndiName(value);
    }

    public void setPassword(String value) {
        this.fDatasourceConnection.setPassword(value);
    }

    public void setPortNumber(int value) {
        this.fDatasourceConnection.setPortNumber(value);
    }

    public void setResourceReferenceName(String value) {
        this.fDatasourceConnection.setResourceReferenceName(value);
    }

    public void setServerName(String value) {
        this.fDatasourceConnection.setServerName(value);
    }

    public void setSqlVendorType(int value) {
        this.fDatasourceConnection.setSqlVendorType(value);
    }

    public void setUserid(String value) {
        this.fDatasourceConnection.setUserid(value);
    }

    public void unsetAutoDeploy() {
        this.fDatasourceConnection.unsetAutoDeploy();
    }

    public void unsetPortNumber() {
        this.fDatasourceConnection.unsetPortNumber();
    }

    public void unsetSqlVendorType() {
        this.fDatasourceConnection.unsetSqlVendorType();
    }
}

