/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.sdo.jdbc.ui.internal.util;

import com.ibm.etools.sdo.jdbc.ui.internal.actions.ConnectionOperation;
import com.ibm.etools.sdo.jdbc.ui.internal.data.ConnectionData;
import com.ibm.etools.sdo.jdbc.ui.internal.data.IConnectionData;
import com.ibm.etools.sdo.jdbc.ui.internal.deploy.JDBCUiUtil;
import com.ibm.etools.sdo.jdbc.ui.internal.propertypages.JDBCConnectionsPropertyPage;
import com.ibm.etools.sdo.jdbc.ui.internal.util.ConnectionProfileUtil;
import com.ibm.etools.sdo.jdbc.ui.internal.util.ConnectionsHelper;
import com.ibm.etools.sdo.jdbc.ui.internal.util.WebAppUtil;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.Connection;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.DatasourceConnection;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.RuntimeConnection;
import com.ibm.etools.webtools.deploy.jdbc.internal.nls.ResourceHandler;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jst.j2ee.common.ResourceRef;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class ConnectionsUIUtil {
    public static void addConnection(IProject project, Shell shell, IConnectionData data) throws InvocationTargetException, InterruptedException {
        if (data != null) {
            ConnectionOperation op = new ConnectionOperation(project, data.getConnectionObject(), shell);
            op.setOperationCode(0);
            op.run((IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static ConnectionData createConnectionData(IConnectionProfile connection, String connectionName, IProject project) {
        ConnectionData connectionData = null;
        if (connectionData == null) {
            connectionData = new ConnectionData();
            connectionData.setProject(project);
            connectionData.setIsExistingConnection(false);
        }
        if (connection != null) {
            connectionData.setConnectionProfile(connection);
            connectionData.setConnectionId(connection.getName());
            connectionData.setRuntimeOptions(connection);
        }
        return connectionData;
    }

    public static IConnectionData createConnectionDataForProfile(String connectionProfileName, IProject project, boolean isDataSource) {
        IConnectionProfile profile;
        ConnectionData connectionData = null;
        if (connectionProfileName != null && (profile = ProfileManager.getInstance().getProfileByName(connectionProfileName)) != null) {
            connectionData = ConnectionsUIUtil.createConnectionData(profile, connectionProfileName, project);
            if (!isDataSource) {
                connectionData.setIsDriverManager(true);
            }
        }
        return connectionData;
    }

    public static IConnectionData createConnectionForProfile(IProject project, Shell shell, IConnectionProfile selectedProfile, String connectionProfileName) throws InvocationTargetException, InterruptedException {
        ConnectionData data = ConnectionsUIUtil.createConnectionData(selectedProfile, connectionProfileName, project);
        ConnectionsUIUtil.addConnection(project, shell, data);
        return data;
    }

    public static IConnectionData createNewConnection(IProject project, Shell shell) {
        IConnectionData ret = null;
        IConnectionProfile selectedProfile = null;
        String connectionProfileName = null;
        IConnectionProfile[] profiles = ProfileManager.getInstance().getProfiles();
        if (profiles.length == 0) {
            selectedProfile = ConnectionProfileUtil.createNewProfile();
            if (selectedProfile != null) {
                connectionProfileName = selectedProfile.getName();
            }
        } else {
            selectedProfile = ConnectionProfileUtil.openSelectExistingConnectionDialog();
        }
        if (selectedProfile != null) {
            shell.setCursor(new Cursor((Device)shell.getDisplay(), 1));
            try {
                try {
                    ret = ConnectionsUIUtil.createConnectionForProfile(project, shell, selectedProfile, connectionProfileName);
                    ret.setShell(shell);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    shell.setCursor(new Cursor((Device)shell.getDisplay(), 0));
                }
            }
            finally {
                shell.setCursor(new Cursor((Device)shell.getDisplay(), 0));
            }
        }
        return ret;
    }

    public static void deployJDBCConnection(IProject project, Shell shell, IConnectionData connectionData) {
        try {
            JDBCConnectionsPropertyPage.addSDOBuilderToBuildSpec(null, project);
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        List connections = ConnectionData.getConnections(project);
        int size = connections.size();
        boolean existingConnection = false;
        int j = 0;
        while (j < size && !existingConnection) {
            Connection con = (Connection)connections.get(j);
            if (connectionData.getConnectionId().equals(con.getId())) {
                existingConnection = true;
            }
            ++j;
        }
        try {
            if (existingConnection) {
                ConnectionsUIUtil.editConnection(project, shell, connectionData);
            } else {
                ConnectionsUIUtil.addConnection(project, shell, connectionData);
            }
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void editConnection(IProject project, Shell shell, IConnectionData data) throws InvocationTargetException, InterruptedException {
        if (data != null) {
            ConnectionOperation op = new ConnectionOperation(project, data.getConnectionObject(), shell);
            op.setOperationCode(1);
            op.run((IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static void openJDBCConnectionsPreferencePageForProject(IProject project, Shell shell) {
        PreferenceDialog pd = PreferencesUtil.createPropertyDialogOn((Shell)shell, (IAdaptable)project, (String)"com.ibm.etools.sdo.jdbc.ui.propertypages.JDBCConnectionsPropertyPage", (String[])new String[0], null);
        pd.open();
    }

    public static void updateConnection(IProject project, Shell shell, IConnectionData origData) {
        ConnectionData clonedConnectionData = (ConnectionData)origData.clone();
        String classLocation = clonedConnectionData.getClassLocation();
        StringTokenizer tokenzier = new StringTokenizer(classLocation, ";");
        while (tokenzier.hasMoreTokens()) {
            File file = new File(tokenzier.nextToken());
            if (file.exists()) continue;
            clonedConnectionData.setClassLocation(null);
            break;
        }
        IConnectionProfile createNewProfile = null;
        String connectionProfileName = null;
        IConnectionProfile[] profiles = ProfileManager.getInstance().getProfiles();
        if (profiles.length == 0) {
            createNewProfile = ConnectionProfileUtil.createNewProfile();
            if (createNewProfile != null) {
                connectionProfileName = createNewProfile.getName();
            }
        } else {
            createNewProfile = ConnectionProfileUtil.openSelectExistingConnectionDialog();
        }
        if (createNewProfile != null) {
            shell.setCursor(new Cursor((Device)shell.getDisplay(), 1));
            try {
                ConnectionData data = ConnectionsUIUtil.createConnectionData(createNewProfile, connectionProfileName, project);
                boolean originallyDriverManager = origData.isDriverManager();
                if (originallyDriverManager) {
                    data.setIsDataSource(false);
                    data.setIsDriverManager(true);
                }
                MessageBox prompt = new MessageBox(shell, 448);
                prompt.setMessage(ResourceHandler.ConnectionUpdate_prompt_message);
                prompt.setText(ResourceHandler.ConnectionUpdate_prompt_title);
                Connection connectionToUse = null;
                int rc2 = prompt.open();
                switch (rc2) {
                    case 64: {
                        connectionToUse = data.getConnectionObject();
                        break;
                    }
                    case 128: {
                        connectionToUse = origData.getConnectionObject();
                        break;
                    }
                    case 256: {
                        return;
                    }
                }
                ConnectionsHelper.setDevConnectionName(connectionToUse, connectionProfileName);
                connectionToUse.setId(origData.getConnectionId());
                RuntimeConnection c = connectionToUse.getRuntime();
                if (c instanceof DatasourceConnection) {
                    String id = origData.getConnectionId();
                    String currentResourceRefName = origData.getResourceRefName();
                    boolean refSet = false;
                    if (id != null && currentResourceRefName != null && !id.equals(currentResourceRefName)) {
                        ResourceRef[] resourceRefs = WebAppUtil.getResourceRefs(project);
                        int i = 0;
                        while (i < resourceRefs.length && !refSet) {
                            String resRefName = resourceRefs[i].getName();
                            if (resRefName.equals(id)) {
                                ((DatasourceConnection)c).setResourceReferenceName(resRefName);
                                refSet = true;
                            }
                            ++i;
                        }
                    }
                    if (!refSet) {
                        ((DatasourceConnection)c).setResourceReferenceName(origData.getResourceRefName());
                    }
                    IVirtualComponent component = ComponentCore.createComponent((IProject)project);
                    JDBCUiUtil.createResourceReference(connectionToUse, component, (IProgressMonitor)new NullProgressMonitor(), true);
                }
                shell.setCursor(new Cursor((Device)shell.getDisplay(), 1));
                try {
                    try {
                        ConnectionsHelper.editConnection(project, connectionToUse, shell);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        shell.setCursor(new Cursor((Device)shell.getDisplay(), 0));
                    }
                }
                finally {
                    shell.setCursor(new Cursor((Device)shell.getDisplay(), 0));
                }
            }
            catch (Exception exception) {}
        }
    }
}

