/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.sdo.jdbc.ui.internal.deploy;

import com.ibm.etools.sdo.jdbc.ui.internal.deploy.ServerSetup;
import com.ibm.etools.sdo.jdbc.ui.internal.deploy.ServerSetupRegistryReader;
import com.ibm.etools.sdo.jdbc.ui.internal.util.ConnectionsHelper;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.Connection;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;

public class SDODeployUtil {
    public static final boolean dissconnectAllCloudscapeConnections() {
        boolean ret = false;
        return ret;
    }

    public static ServerSetup[] getServerSetups(IRuntime wstRuntime) throws CoreException, IOException {
        ServerSetup[] ret = new ServerSetup[]{};
        String runtimeID = wstRuntime.getRuntimeType().getId();
        List setUps = ServerSetupRegistryReader.createServerSetups(runtimeID);
        ret = setUps.toArray(new ServerSetup[setUps.size()]);
        return ret;
    }

    public static final boolean hasDataSourceConnections(IModule deployable) {
        boolean ret = SDODeployUtil.isSDOProject(deployable);
        if (ret) {
            ret = false;
            try {
                int connection_count = ConnectionsHelper.getConnectionCount(deployable.getProject());
                int i = 0;
                while (i < connection_count) {
                    if (ConnectionsHelper.isDatasourceConnection(deployable.getProject(), i)) {
                        ret = true;
                        break;
                    }
                    ++i;
                }
            }
            catch (IOException e) {
                ret = false;
                e.printStackTrace();
            }
        }
        return ret;
    }

    public static final boolean isAutoDeployChecked(IModule deployable) {
        boolean ret = SDODeployUtil.isSDOProject(deployable);
        if (ret) {
            try {
                EList connections = ConnectionsHelper.getConnections(deployable.getProject());
                ret = false;
                int i = 0;
                while (i < connections.size()) {
                    Connection connection;
                    if (connections.get(i) instanceof Connection && (connection = (Connection)connections.get(i)).getRuntime().isAutoDeploy()) {
                        ret = true;
                        break;
                    }
                    ++i;
                }
            }
            catch (IOException e) {
                ret = false;
                e.printStackTrace();
            }
        }
        return ret;
    }

    public static final boolean isEnterpriseApplication(IModule deployable) {
        return !SDODeployUtil.isWebDeployable(deployable);
    }

    public static final boolean isSDOProject(IModule deployable) {
        boolean ret = false;
        IProject project = deployable.getProject();
        if (project != null) {
            ret = ConnectionsHelper.isConnectionsFileExist(project);
        }
        return ret;
    }

    public static final boolean isWebDeployable(IModule deployable) {
        return J2EEProjectUtilities.isDynamicWebProject((IProject)deployable.getProject());
    }
}

