/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.sdo.jdbc.ui.internal.deploy;

import com.ibm.etools.sdo.jdbc.ui.internal.connections.impl.DriverManagerConnectionImpl;
import com.ibm.etools.sdo.jdbc.ui.internal.deploy.SDODeployUtil;
import com.ibm.etools.sdo.jdbc.ui.internal.deploy.ServerSetup;
import com.ibm.etools.sdo.jdbc.ui.internal.deploy.WASExtensions;
import com.ibm.etools.sdo.jdbc.ui.internal.deploy.WasExtensionsRegistryReader;
import com.ibm.etools.sdo.jdbc.ui.internal.util.ConnectionsHelper;
import com.ibm.etools.sdo.jdbc.ui.internal.util.RuntimeUtil;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.Connection;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.DatasourceConnection;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.DriverManagerConnection;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.RuntimeConnection;
import com.ibm.etools.webtools.deploy.jdbc.internal.nls.ResourceHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.Description;
import org.eclipse.jst.j2ee.common.EnvEntry;
import org.eclipse.jst.j2ee.common.EnvEntryType;
import org.eclipse.jst.j2ee.common.ResAuthTypeBase;
import org.eclipse.jst.j2ee.common.ResSharingScopeType;
import org.eclipse.jst.j2ee.common.ResourceRef;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.jee.project.facet.IWebCreateDeploymentFilesDataModelProperties;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;

public class JDBCUiUtil {
    private static final String defaultSDOID = "Auto Generated - SDO Datasource connection to";
    private static final String defaultWDOID = "Auto Generated - WDO Datasource connection to";
    private static final String passwordStart = "{xor}";

    public static boolean canHaveResourceRef(IProject project) {
        return JavaEEProjectUtilities.isDynamicWebProject((IProject)project);
    }

    public static boolean createDeployMentDescriptorIfNecesary(IProject project) {
        boolean created = false;
        if (!JDBCUiUtil.hasDeploymentDescriptor(project)) {
            try {
                Class<IWebCreateDeploymentFilesDataModelProperties> dataModelClass = IWebCreateDeploymentFilesDataModelProperties.class;
                IDataModel dataModel = DataModelFactory.createDataModel(dataModelClass);
                dataModel.setProperty("ICreateDeploymentFilesDataModelProperties.TARGET_PROJECT", (Object)project);
                dataModel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
                created = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return created;
    }

    private static void createNewEnvEntry(WebArtifactEdit webEditModel, List envEntries, Connection connection, DriverManagerConnection driverManagerConnection, IProgressMonitor monitor) {
        CommonFactory factory = CommonFactory.eINSTANCE;
        EnvEntry thisEnvEntry = factory.createEnvEntry();
        thisEnvEntry.setName(connection.getId());
        thisEnvEntry.setType(EnvEntryType.STRING_LITERAL);
        EList descs = thisEnvEntry.getDescriptions();
        Description d = factory.createDescription();
        d.setValue(NLS.bind((String)ResourceHandler.ConnectionOperation_datasourceName, (Object[])new Object[]{driverManagerConnection.getUrl()}));
        descs.add(0, (Object)d);
        thisEnvEntry.setValue(connection.getRuntime().getConnectionString());
        envEntries.add(thisEnvEntry);
        webEditModel.saveIfNecessary(monitor);
    }

    private static void createNewResourceRef(WebArtifactEdit webEditModel, IProject project, List resourceRefs, DatasourceConnection dataSourceConnection, org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime, IProgressMonitor monitor) {
        if (JDBCUiUtil.canHaveResourceRef(project)) {
            CommonFactory factory = CommonFactory.eINSTANCE;
            ResourceRef thisResourceRef = factory.createResourceRef();
            thisResourceRef.setName(dataSourceConnection.getResourceReferenceName());
            thisResourceRef.setType("javax.sql.DataSource");
            EList descs = thisResourceRef.getDescriptions();
            Description d = factory.createDescription();
            d.setValue(NLS.bind((String)ResourceHandler.ConnectionOperation_datasourceName, (Object[])new Object[]{dataSourceConnection.getDatabaseName()}));
            descs.add(0, (Object)d);
            thisResourceRef.setResSharingScope(ResSharingScopeType.SHAREABLE_LITERAL);
            JDBCUiUtil.createWASResourceRefExtension(webEditModel, project, dataSourceConnection, runtime, thisResourceRef);
            thisResourceRef.setAuth(ResAuthTypeBase.CONTAINER_LITERAL);
            resourceRefs.add(thisResourceRef);
            webEditModel.saveIfNecessary(monitor);
        }
    }

    public static void createResourceReference(Connection connection, IVirtualComponent comp, IProgressMonitor monitor) {
        JDBCUiUtil.createResourceReference(connection, comp, monitor, false);
    }

    public static void createResourceReference(Connection connection, IVirtualComponent comp, IProgressMonitor monitor, boolean updateAuthAlias) {
        block20: {
            JDBCUiUtil.createDeployMentDescriptorIfNecesary(comp.getProject());
            WebArtifactEdit webEdit = WebArtifactEdit.getWebArtifactEditForWrite((IVirtualComponent)comp);
            if (webEdit != null) {
                try {
                    try {
                        org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime;
                        WebApp app = webEdit.getWebApp();
                        EList resourceRefs = app.getResourceRefs();
                        ResourceRef thisResourceRef = null;
                        boolean refFound = false;
                        int i = 0;
                        while (i < resourceRefs.size()) {
                            ResourceRef resourceRef = (ResourceRef)resourceRefs.get(i);
                            if (JDBCUiUtil.resourceRefMatchesConnection(resourceRef, connection)) {
                                refFound = true;
                                thisResourceRef = resourceRef;
                                break;
                            }
                            ++i;
                        }
                        EList envEntries = app.getEnvironmentProperties();
                        EnvEntry thisEnvEntry = null;
                        boolean entryFound = false;
                        int i2 = 0;
                        while (i2 < envEntries.size()) {
                            EnvEntry envEntry = (EnvEntry)envEntries.get(i2);
                            if (envEntry.getName() != null && envEntry.getName().equals(connection.getId())) {
                                entryFound = true;
                                thisEnvEntry = envEntry;
                                break;
                            }
                            ++i2;
                        }
                        if (connection.getRuntime() instanceof DatasourceConnection) {
                            DatasourceConnection dataSourceConnection = (DatasourceConnection)connection.getRuntime();
                            runtime = RuntimeUtil.getRuntime(comp.getProject());
                            if (entryFound) {
                                JDBCUiUtil.removeEnvEntry(webEdit, connection.getId());
                            }
                            if (runtime != null) {
                                if (!refFound) {
                                    IProject project = comp.getProject();
                                    JDBCUiUtil.createNewResourceRef(webEdit, project, (List)resourceRefs, dataSourceConnection, runtime, monitor);
                                } else {
                                    IProject project = comp.getProject();
                                    JDBCUiUtil.editExistingResourceRef(webEdit, project, dataSourceConnection, thisResourceRef, runtime, monitor, updateAuthAlias);
                                }
                            }
                        }
                        if (!(connection.getRuntime() instanceof DriverManagerConnection)) break block20;
                        DriverManagerConnection driverManagerConnection = (DriverManagerConnection)connection.getRuntime();
                        runtime = RuntimeUtil.getRuntime(comp.getProject());
                        if (RuntimeUtil.isTargetedAtSupportedRuntime(runtime)) {
                            driverManagerConnection = JDBCUiUtil.encrypt(driverManagerConnection, comp.getProject());
                        }
                        if (refFound) {
                            JDBCUiUtil.removeResourceRef(comp.getProject(), webEdit, connection, runtime);
                        }
                        if (!entryFound) {
                            JDBCUiUtil.createNewEnvEntry(webEdit, (List)envEntries, connection, driverManagerConnection, monitor);
                            break block20;
                        }
                        JDBCUiUtil.editExistingEnvEntry(webEdit, connection, driverManagerConnection, thisEnvEntry, monitor);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (webEdit != null) {
                            webEdit.dispose();
                        }
                    }
                }
                finally {
                    if (webEdit != null) {
                        webEdit.dispose();
                    }
                }
            }
        }
    }

    private static void createWASResourceRefExtension(WebArtifactEdit webEditModel, IProject project, DatasourceConnection dataSourceConnection, org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime, ResourceRef thisResourceRef) {
        IRuntime wstRuntime;
        if (runtime != null && (wstRuntime = FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)runtime)) != null) {
            WASExtensions[] wasExtensions;
            String runtimeID = wstRuntime.getRuntimeType().getId();
            WASExtensions[] wASExtensionsArray = wasExtensions = WasExtensionsRegistryReader.createWASExtensions(runtimeID);
            int n = wasExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                WASExtensions element = wASExtensionsArray[n2];
                if (wstRuntime != null) {
                    element.createWASResourceRefExtension(project, webEditModel, dataSourceConnection, runtime, thisResourceRef);
                }
                ++n2;
            }
        }
    }

    private static void editExistingEnvEntry(WebArtifactEdit webEditModel, Connection connection, DriverManagerConnection driverManagerConnection, EnvEntry thisEnvEntry, IProgressMonitor monitor) {
        boolean edited = false;
        if (!thisEnvEntry.getValue().equals(connection.getRuntime().getConnectionString())) {
            thisEnvEntry.setValue(connection.getRuntime().getConnectionString());
            EList descs = thisEnvEntry.getDescriptions();
            if (descs.size() == 0) {
                CommonFactory factory = CommonFactory.eINSTANCE;
                Description d = factory.createDescription();
                d.setValue(NLS.bind((String)ResourceHandler.ConnectionOperation_datasourceName, (Object[])new Object[]{driverManagerConnection.getUrl()}));
                descs.add(0, (Object)d);
            } else {
                Description d = (Description)descs.get(0);
                d.setValue(NLS.bind((String)ResourceHandler.ConnectionOperation_datasourceName, (Object[])new Object[]{driverManagerConnection.getUrl()}));
            }
            edited = true;
        }
        if (edited) {
            webEditModel.saveIfNecessary(monitor);
        }
    }

    private static void editExistingResourceRef(WebArtifactEdit webEditModel, IProject project, DatasourceConnection dataSourceConnection, ResourceRef thisResourceRef, org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime, IProgressMonitor monitor, boolean updateAuthAlias) {
        if (JDBCUiUtil.canHaveResourceRef(project)) {
            boolean edited = false;
            WebApp app = webEditModel.getWebApp();
            ResourceRef resourceRef = thisResourceRef;
            HashMap<String, DatasourceConnection> map = new HashMap<String, DatasourceConnection>();
            String mapKey = dataSourceConnection.getId();
            if (resourceRef.getName() != null) {
                mapKey = dataSourceConnection.getResourceReferenceName();
            }
            map.put(mapKey, dataSourceConnection);
            edited = JDBCUiUtil.modifyWASResourceRefExtension(project, app, resourceRef, runtime, map, edited, updateAuthAlias);
            String dataSourceClassName = "javax.sql.DataSource";
            if (!thisResourceRef.getType().equals(dataSourceClassName)) {
                thisResourceRef.setType(dataSourceClassName);
                EList descs = thisResourceRef.getDescriptions();
                if (descs.size() == 0) {
                    CommonFactory factory = CommonFactory.eINSTANCE;
                    Description d = factory.createDescription();
                    d.setValue(NLS.bind((String)ResourceHandler.ConnectionOperation_datasourceName, (Object[])new Object[]{dataSourceConnection.getDatabaseName()}));
                    descs.add(0, (Object)d);
                } else {
                    Description d = (Description)descs.get(0);
                    d.setValue(NLS.bind((String)ResourceHandler.ConnectionOperation_datasourceName, (Object[])new Object[]{dataSourceConnection.getDatabaseName()}));
                }
                if (thisResourceRef.getResSharingScope() == null) {
                    thisResourceRef.setResSharingScope(ResSharingScopeType.SHAREABLE_LITERAL);
                }
                if (thisResourceRef.getAuth() == null) {
                    thisResourceRef.setAuth(ResAuthTypeBase.CONTAINER_LITERAL);
                }
                edited = true;
            }
            if (edited) {
                webEditModel.saveIfNecessary(monitor);
            }
        }
    }

    private static DriverManagerConnection encrypt(DriverManagerConnection dmc, IProject project) {
        DriverManagerConnection ret = dmc;
        String pass = dmc.getPassword();
        if (pass == null) {
            pass = ((DriverManagerConnectionImpl)ret).getStoredPass();
        }
        if (pass != null && !pass.startsWith(passwordStart)) {
            try {
                IRuntime wstRuntime;
                ServerSetup[] serverSetups;
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime = facetedProject.getPrimaryRuntime();
                if (runtime != null && (serverSetups = SDODeployUtil.getServerSetups(wstRuntime = FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)runtime))).length > 0) {
                    pass = serverSetups[0].sendData(pass);
                    ret.setPassword(pass);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public static int findResourceRefJndiCount(WebArtifactEdit webEditModel, IProject project, String id, String jndiName, org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime, Connection connection) {
        IRuntime wstRuntime;
        WebApp app = webEditModel.getWebApp();
        EList resourceRefs = app.getResourceRefs();
        int foundCount = 0;
        if (runtime != null && (wstRuntime = FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)runtime)) != null) {
            String runtimeID = wstRuntime.getRuntimeType().getId();
            WASExtensions[] wasExtensions = WasExtensionsRegistryReader.createWASExtensions(runtimeID);
            int i = 0;
            while (i < resourceRefs.size()) {
                ResourceRef resourceRef = (ResourceRef)resourceRefs.get(i);
                if (id == null || !JDBCUiUtil.resourceRefMatchesConnection(resourceRef, connection)) {
                    WASExtensions[] wASExtensionsArray = wasExtensions;
                    int n = wasExtensions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        WASExtensions element = wASExtensionsArray[n2];
                        String foundJndiName = element.getJNDI(project, webEditModel, resourceRef);
                        if (foundJndiName.equals(jndiName)) {
                            ++foundCount;
                        }
                        ++n2;
                    }
                }
                ++i;
            }
        }
        return foundCount;
    }

    public static List getAllDescriptions(EnvEntry envEntry) {
        ArrayList<String> allDescriptions = new ArrayList<String>();
        EList descriptions = envEntry.getDescriptions();
        int i = 0;
        while (i < descriptions.size()) {
            Description desc = (Description)descriptions.get(i);
            String description = desc.getValue();
            allDescriptions.add(description);
            ++i;
        }
        if (allDescriptions.size() == 0 && envEntry.getDescription() != null) {
            allDescriptions.add(envEntry.getDescription());
        }
        return allDescriptions;
    }

    public static List getAllDescriptions(ResourceRef resourceRef) {
        ArrayList<String> allDescriptions = new ArrayList<String>();
        EList descriptions = resourceRef.getDescriptions();
        int i = 0;
        while (i < descriptions.size()) {
            Description desc = (Description)descriptions.get(i);
            String description = desc.getValue();
            allDescriptions.add(description);
            ++i;
        }
        if (allDescriptions.size() == 0 && resourceRef.getDescription() != null) {
            allDescriptions.add(resourceRef.getDescription());
        }
        return allDescriptions;
    }

    private static boolean hasDeploymentDescriptor(IProject project) {
        boolean ret = true;
        Path ddFilePath = null;
        if (JavaEEProjectUtilities.isDynamicWebProject((IProject)project)) {
            ddFilePath = new Path("WEB-INF/web.xml");
            IVirtualComponent component = ComponentCore.createComponent((IProject)project);
            if (component.getRootFolder() != null && component.getRootFolder().getUnderlyingFolder() != null) {
                IFile ddXmlFile = component.getRootFolder().getUnderlyingFolder().getFile((IPath)ddFilePath);
                ret = ddXmlFile.exists();
            }
        }
        return ret;
    }

    public static boolean isGeneratedBySDO(String description) {
        if (description == null) {
            return false;
        }
        if (description.startsWith(defaultSDOID)) {
            return true;
        }
        if (description.startsWith(defaultWDOID)) {
            return true;
        }
        String externalizedSdoId = ResourceHandler.ConnectionOperation_datasourceName;
        if (externalizedSdoId != null && !externalizedSdoId.startsWith(defaultSDOID)) {
            String startMatch;
            int index = externalizedSdoId.indexOf(123);
            int endIndex = externalizedSdoId.indexOf(125, index);
            boolean matchesStart = true;
            if (index > 0 && !description.startsWith(startMatch = externalizedSdoId.substring(0, index))) {
                matchesStart = false;
            }
            boolean matchesEnd = true;
            if (matchesStart) {
                if (endIndex > index) {
                    String endMatch = externalizedSdoId.substring(endIndex + 1, externalizedSdoId.length());
                    if (!description.endsWith(endMatch)) {
                        matchesEnd = false;
                    }
                } else {
                    matchesEnd = false;
                }
                if (matchesEnd) {
                    return true;
                }
            }
            if ((index = externalizedSdoId.indexOf("SDO")) != -1) {
                String startMatch2;
                String externalizedWdoId = String.valueOf(externalizedSdoId.substring(0, index)) + "W" + externalizedSdoId.substring(index + 1);
                index = externalizedWdoId.indexOf(123);
                endIndex = externalizedWdoId.indexOf(125, index);
                matchesStart = true;
                if (index > 0 && !description.startsWith(startMatch2 = externalizedWdoId.substring(0, index))) {
                    matchesStart = false;
                }
                matchesEnd = true;
                if (matchesStart) {
                    String endMatch;
                    if (endIndex > index && !description.endsWith(endMatch = externalizedWdoId.substring(endIndex + 1, externalizedWdoId.length()))) {
                        matchesEnd = false;
                    }
                    if (matchesEnd) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static boolean modifyWASResourceRefExtension(IProject project, WebApp app, ResourceRef resourceRef, org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime, Map dataSourceConnections, boolean edited, boolean updateAuthAlias) {
        IRuntime wstRuntime;
        if (runtime != null && (wstRuntime = FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)runtime)) != null) {
            WASExtensions[] wasExtensions;
            String runtimeID = wstRuntime.getRuntimeType().getId();
            WASExtensions[] wASExtensionsArray = wasExtensions = WasExtensionsRegistryReader.createWASExtensions(runtimeID);
            int n = wasExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                WASExtensions element = wASExtensionsArray[n2];
                if (wstRuntime != null) {
                    edited = element.modifyWASResourceRefExtension(project, app, resourceRef, runtime, dataSourceConnections, edited, updateAuthAlias);
                }
                ++n2;
            }
        }
        return edited;
    }

    public static void removeEnvEntry(WebArtifactEdit webEditModel, String id) {
        WebApp app = webEditModel.getWebApp();
        EList envEntries = app.getEnvironmentProperties();
        int i = 0;
        while (i < envEntries.size()) {
            EnvEntry envEntry = (EnvEntry)envEntries.get(i);
            if (envEntry.getName().equals(id)) {
                envEntries.remove(i);
                break;
            }
            ++i;
        }
    }

    public static void removeResourceRef(IProject project, WebArtifactEdit webEditModel, Connection connection, org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime) {
        WebApp app = webEditModel.getWebApp();
        EList resourceRefs = app.getResourceRefs();
        int i = 0;
        while (i < resourceRefs.size()) {
            ResourceRef resourceRef = (ResourceRef)resourceRefs.get(i);
            if (JDBCUiUtil.resourceRefMatchesConnection(resourceRef, connection)) {
                JDBCUiUtil.removeWASResourceRefExtension(project, webEditModel, resourceRef, runtime);
                resourceRefs.remove(i);
                break;
            }
            ++i;
        }
    }

    public static void removeResourceRef(IProject project, WebArtifactEdit webEditModel, String id, org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime) {
        WebApp app = webEditModel.getWebApp();
        EList resourceRefs = app.getResourceRefs();
        int i = 0;
        while (i < resourceRefs.size()) {
            ResourceRef resourceRef = (ResourceRef)resourceRefs.get(i);
            if (resourceRef.getName().equals(id)) {
                JDBCUiUtil.removeWASResourceRefExtension(project, webEditModel, resourceRef, runtime);
                resourceRefs.remove(i);
                break;
            }
            ++i;
        }
    }

    private static void removeWASResourceRefExtension(IProject project, WebArtifactEdit webEditModel, ResourceRef resourceRef, org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime) {
        IRuntime wstRuntime;
        if (runtime != null && (wstRuntime = FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)runtime)) != null) {
            WASExtensions[] wasExtensions;
            String runtimeID = wstRuntime.getRuntimeType().getId();
            WASExtensions[] wASExtensionsArray = wasExtensions = WasExtensionsRegistryReader.createWASExtensions(runtimeID);
            int n = wasExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                WASExtensions element = wASExtensionsArray[n2];
                element.removeWASResourceRefExtension(project, webEditModel, resourceRef);
                ++n2;
            }
        }
    }

    public static boolean resourceRefMatchesConnection(ResourceRef resourceRef, Connection connection) {
        if (resourceRef.getName() != null) {
            RuntimeConnection rtCon = connection.getRuntime();
            if (rtCon instanceof DatasourceConnection) {
                DatasourceConnection dataSourceConnection = (DatasourceConnection)rtCon;
                String resourceRefName = dataSourceConnection.getResourceReferenceName();
                if (resourceRef.getName().equals(resourceRefName)) {
                    return true;
                }
            } else if (resourceRef.getName().equals(connection.getId())) {
                return true;
            }
        }
        return false;
    }

    private static void setJNDIName(WebArtifactEdit webEditModel, ResourceRef resourceRef, Connection connection, IProject project) {
        IRuntime wstRuntime;
        if (connection == null || !(connection.getRuntime() instanceof DatasourceConnection)) {
            return;
        }
        DatasourceConnection dsc = (DatasourceConnection)connection.getRuntime();
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime = RuntimeUtil.getRuntime(project);
        if (runtime != null && (wstRuntime = FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)runtime)) != null) {
            WASExtensions[] wasExtensions;
            String runtimeID = wstRuntime.getRuntimeType().getId();
            WASExtensions[] wASExtensionsArray = wasExtensions = WasExtensionsRegistryReader.createWASExtensions(runtimeID);
            int n = wasExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                WASExtensions element = wASExtensionsArray[n2];
                String jndi = element.getJNDI(project, webEditModel, resourceRef);
                if (jndi != null && !jndi.equals(dsc.getJndiName())) {
                    dsc.setJndiName(jndi);
                    try {
                        ConnectionsHelper.editConnection(project, connection, new Shell());
                    }
                    catch (SWTException sWTException) {
                        try {
                            ConnectionsHelper.editConnection(project, connection, null);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
        }
    }

    public static void syncWebXmlReferences(List connectionsList, IVirtualComponent comp) {
        JDBCUiUtil.createDeployMentDescriptorIfNecesary(comp.getProject());
        WebArtifactEdit webEdit = WebArtifactEdit.getWebArtifactEditForWrite((IVirtualComponent)comp);
        if (webEdit != null) {
            try {
                try {
                    WebApp app = webEdit.getWebApp();
                    EList resourceRefs = app.getResourceRefs();
                    int resourceRefsLength = resourceRefs.size();
                    int i = resourceRefsLength - 1;
                    while (i >= 0) {
                        ResourceRef resourceRef = (ResourceRef)resourceRefs.get(i);
                        int j = 0;
                        while (j < connectionsList.size()) {
                            Connection connection = (Connection)connectionsList.get(j);
                            if (JDBCUiUtil.resourceRefMatchesConnection(resourceRef, connection)) {
                                JDBCUiUtil.setJNDIName(webEdit, resourceRef, connection, comp.getProject());
                            }
                            ++j;
                        }
                        --i;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (webEdit != null) {
                        webEdit.dispose();
                    }
                }
            }
            finally {
                if (webEdit != null) {
                    webEdit.dispose();
                }
            }
        }
    }
}

