/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.sdo.jdbc.ui.internal.deploy;

import com.ibm.etools.sdo.jdbc.ui.internal.deploy.JDBCUiUtil;
import com.ibm.etools.sdo.jdbc.ui.internal.deploy.SDODeployUtil;
import com.ibm.etools.sdo.jdbc.ui.internal.deploy.ServerSetup;
import com.ibm.etools.sdo.jdbc.ui.internal.util.ConnectionsHelper;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.Connection;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.ConnectionsConstants;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;

public class JDBCConnectionDeployBuilder
extends IncrementalProjectBuilder
implements ConnectionsConstants {
    public static String SDO_DEPLOY_BUILDER_ID = "com.ibm.etools.webtools.deploy.jdbc.JDBCConnectionDeploy";
    public static String OLD_SDO_DEPLOY_BUILDER_ID = "com.ibm.etools.webtools.sdo.jdbc.ui.sdoWebDeploy";

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (!this.getProject().exists()) {
            return new IProject[0];
        }
        try {
            if (kind == 6) {
                this.build(monitor);
            } else {
                IResourceDelta delta = this.getDelta(this.getProject());
                if (delta == null) {
                    this.build(monitor);
                } else {
                    this.incrementalBuild(delta, monitor);
                }
            }
        }
        catch (OperationCanceledException operationCanceledException) {}
        return null;
    }

    protected void build(IProgressMonitor monitor) throws CoreException {
        try {
            IVirtualComponent comp = ComponentCore.createComponent((IProject)this.getProject());
            this.build(comp, monitor);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void build(IVirtualComponent comp, IProgressMonitor monitor) throws IOException, CoreException {
        IProject project;
        IProject iProject = comp != null ? (comp.getProject() != null ? comp.getProject() : this.getProject()) : (project = this.getProject());
        if (project != null && ConnectionsHelper.hasConnectionsFile(project)) {
            EList list = ConnectionsHelper.getConnections(project);
            for (Connection connection : list) {
                JDBCUiUtil.createResourceReference(connection, comp, (IProgressMonitor)new NullProgressMonitor());
            }
            JDBCUiUtil.syncWebXmlReferences((List)list, comp);
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
            org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime = null;
            try {
                runtime = facetedProject.getPrimaryRuntime();
            }
            catch (RuntimeException runtimeException) {}
            if (runtime != null) {
                IRuntime wstRuntime = null;
                try {
                    wstRuntime = FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)runtime);
                }
                catch (RuntimeException runtimeException) {}
                if (wstRuntime != null) {
                    ServerSetup[] serverSetups;
                    ServerSetup[] serverSetupArray = serverSetups = SDODeployUtil.getServerSetups(wstRuntime);
                    int n = serverSetups.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ServerSetup element = serverSetupArray[n2];
                        if (wstRuntime != null) {
                            element.doIt(wstRuntime, project);
                        }
                        ++n2;
                    }
                }
            }
        }
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        try {
            class ResourceDeltaVisitor
            implements IResourceDeltaVisitor {
                private boolean shouldBuild = false;

                ResourceDeltaVisitor() {
                }

                public boolean shouldBuild() {
                    return this.shouldBuild;
                }

                public boolean visit(IResourceDelta subdelta) throws CoreException {
                    IResource resource = subdelta.getResource();
                    int type = resource.getType();
                    boolean visitChildren = true;
                    if (type == 1) {
                        if (resource != null && resource.getName() != null && ".wdo-connections".equals(resource.getName()) && resource instanceof IFile) {
                            this.shouldBuild = true;
                            visitChildren = false;
                        }
                    } else if (type == 2) {
                        visitChildren = false;
                    }
                    return visitChildren;
                }
            }
            ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
            delta.accept((IResourceDeltaVisitor)visitor);
            if (visitor.shouldBuild()) {
                this.build(monitor);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

