/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.sdo.jdbc.ui.internal;

import com.ibm.etools.sdo.jdbc.ui.internal.ConnectionControl;
import com.ibm.etools.sdo.jdbc.ui.internal.SimpleTableViewer;
import com.ibm.etools.sdo.jdbc.ui.internal.data.IConnectionData;
import com.ibm.etools.sdo.jdbc.ui.internal.util.ConnectionObserverConstants;
import com.ibm.etools.sdo.jdbc.ui.internal.util.ConnectionsHelper;
import com.ibm.etools.sdo.jdbc.ui.internal.util.DialogUtil;
import com.ibm.etools.sdo.jdbc.ui.internal.util.RSCConnectionsHelper;
import com.ibm.etools.webtools.deploy.jdbc.internal.consts.UIConstants;
import com.ibm.etools.webtools.deploy.jdbc.internal.nls.ResourceHandler;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class ConnectionPage
extends DialogPage
implements Listener,
ConnectionObserverConstants {
    private static final int TABLE_DISPLAY_HEIGHT = 75;
    private SimpleTableViewer fRuntimeConnDisplayTable;
    private SimpleTableViewer fDevConnDisplayTable;
    private Button fReconnectDevConnButton;
    private Button fChangeDevtimeConnButton;
    private Button fChangeRuntimeConnButton;
    private ConnectionControl fConnectionControl = new ConnectionControl();
    private Cursor fWaitCursor;
    private Cursor fNormalCursor;
    private IProject fProject;

    public ConnectionPage() {
        this(ResourceHandler.ConnectionPage_Connections_1, null);
    }

    public ConnectionPage(String title) {
        this(title, null);
    }

    public ConnectionPage(String title, ImageDescriptor image) {
        super(title, image);
        this.fConnectionControl.setAutoConnect(false);
        this.fConnectionControl.setShowDelete(true);
        this.fConnectionControl.setShowConfigureConnections(false);
    }

    public void addObserver(Observer observer) {
        this.fConnectionControl.addObserver(observer);
    }

    public void createControl(Composite composite) {
        Composite base = DialogUtil.createComposite(composite, 1);
        ((GridData)base.getLayoutData()).verticalAlignment = 1;
        this.fConnectionControl.createControl(base);
        Group devConnComposite = DialogUtil.createGroup(base, 2);
        devConnComposite.setText(ResourceHandler.ConnectionPage_dev_conn_details);
        GridData data = new GridData(1808);
        devConnComposite.setLayoutData((Object)data);
        this.fDevConnDisplayTable = new SimpleTableViewer((Composite)devConnComposite, 67842);
        data = new GridData(1808);
        data.heightHint = 75;
        this.fDevConnDisplayTable.getTable().setLayoutData((Object)data);
        Composite buttonComposite = DialogUtil.createComposite((Composite)devConnComposite, 1);
        this.fReconnectDevConnButton = DialogUtil.createPushButton(buttonComposite, ResourceHandler.ConnectionPage_1);
        data = new GridData(768);
        this.fReconnectDevConnButton.setLayoutData((Object)data);
        this.fChangeDevtimeConnButton = DialogUtil.createPushButton(buttonComposite, ResourceHandler.ConnectionPage_1a);
        data = new GridData(768);
        this.fChangeDevtimeConnButton.setLayoutData((Object)data);
        buttonComposite.setLayoutData((Object)new GridData());
        Group runConnComposite = DialogUtil.createGroup(base, 2);
        runConnComposite.setText(ResourceHandler.ConnectionPage_Runtime_connection_details_4);
        data = new GridData(1808);
        runConnComposite.setLayoutData((Object)data);
        this.fRuntimeConnDisplayTable = new SimpleTableViewer((Composite)runConnComposite, 67842);
        data = new GridData(1808);
        data.heightHint = 75;
        this.fRuntimeConnDisplayTable.getTable().setLayoutData((Object)data);
        this.fChangeRuntimeConnButton = DialogUtil.createPushButton((Composite)runConnComposite, ResourceHandler.ConnectionPage_Edit___3);
        data = new GridData();
        this.fChangeRuntimeConnButton.setLayoutData((Object)data);
        this.fWaitCursor = new Cursor((Device)runConnComposite.getDisplay(), 1);
        this.fNormalCursor = new Cursor((Device)runConnComposite.getDisplay(), 0);
        this.fConnectionControl.setListener(this);
        this.fConnectionControl.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                String id = (String)arg;
                Shell shell = ConnectionPage.this.getControl().getShell();
                shell.setCursor(ConnectionPage.this.fWaitCursor);
                try {
                    try {
                        if (id != null) {
                            if (id.equals("handleChangeDevCon")) {
                                ConnectionPage.this.updateDevConnTextArea();
                            } else if (!id.equals("handleConnIdComboSelection")) {
                                if (id.equals("handleChangeRuntimeConn")) {
                                    ConnectionPage.this.updateRuntimeConnTextArea();
                                } else {
                                    id.equals("handleNewConnection");
                                }
                            }
                        }
                        ConnectionPage.this.fConnectionControl.updateConnectionIdDisplay();
                        ConnectionPage.this.updateDevConnTextArea();
                        ConnectionPage.this.updateRuntimeConnTextArea();
                    }
                    catch (RuntimeException e) {
                        e.printStackTrace();
                        shell.setCursor(ConnectionPage.this.fNormalCursor);
                    }
                }
                finally {
                    shell.setCursor(ConnectionPage.this.fNormalCursor);
                }
            }
        });
        this.fReconnectDevConnButton.addListener(13, (Listener)this);
        this.fChangeDevtimeConnButton.addListener(13, (Listener)this);
        this.fChangeRuntimeConnButton.addListener(13, (Listener)this);
        this.setControl((Control)base);
    }

    public void dispose() {
        super.dispose();
        if (this.fWaitCursor != null && !this.fWaitCursor.isDisposed()) {
            this.fWaitCursor.dispose();
        }
        if (this.fNormalCursor != null && !this.fNormalCursor.isDisposed()) {
            this.fNormalCursor.dispose();
        }
    }

    private void enableDevButtons(boolean enabled) {
        this.fChangeDevtimeConnButton.setEnabled(enabled);
        this.fReconnectDevConnButton.setEnabled(enabled);
    }

    public IConnectionData getConnectionData() {
        return this.fConnectionControl.getConnectionData();
    }

    public IProject getProject() {
        return this.fProject;
    }

    public void handleEvent(Event event) {
        Widget widget = event.widget;
        if (widget == this.fConnectionControl.fNewConnButton) {
            this.fConnectionControl.handleNewConnection();
        } else if (widget == this.fReconnectDevConnButton) {
            String devConnection = ConnectionsHelper.getDevConnectionName(this.getConnectionData().getConnectionObject(), true);
            if (devConnection == null) {
                return;
            }
            IConnectionProfile profileByName = ProfileManager.getInstance().getProfileByName(devConnection);
            try {
                Database database = null;
                try {
                    database = RSCConnectionsHelper.getDatabaseAndInitializeConnection(profileByName, devConnection, true, this.getShell(), (IProgressMonitor)new NullProgressMonitor());
                }
                catch (InstantiationException instantiationException) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.getConnectionData().setConnectionProfile(profileByName);
                this.getConnectionData().setRDBDatabase(database);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            this.updateDevConnTextArea();
        } else if (widget == this.fChangeDevtimeConnButton) {
            this.fConnectionControl.handleChangeDevConn();
        } else if (widget == this.fChangeRuntimeConnButton) {
            this.fConnectionControl.handleChangeRuntimeConn();
        } else if (widget == this.fConnectionControl.fConnIdCombo) {
            this.fConnectionControl.handleConnIdComboSelection();
        }
        this.updateCustomAttributeView();
    }

    public void setConnectionData(IConnectionData connectionData) {
        this.fConnectionControl.setConnectionData(connectionData);
    }

    public void setProject(IProject project) {
        this.fProject = project;
    }

    public void updateConnDescriptionComposite() {
        this.updateDevConnTextArea();
        this.updateRuntimeConnTextArea();
    }

    public void updateCustomAttributeView() {
        this.fConnectionControl.setConnectionData(this.getConnectionData());
        this.fConnectionControl.setProject(this.getProject());
        this.fConnectionControl.updateConnectionIdCombo();
    }

    private void updateDevConnTextArea() {
        if (this.fDevConnDisplayTable == null) {
            return;
        }
        if (this.fConnectionControl.fConnIdCombo.getSelectionIndex() == -1) {
            this.fDevConnDisplayTable.setItems(new String[]{ResourceHandler.ConnectionPage_create_new}, new Image[]{UIConstants.INFO_IMAGE});
            this.enableDevButtons(false);
        } else {
            IConnectionData connectionData = this.getConnectionData();
            if (connectionData.isImportedDatabase()) {
                if (connectionData.getDatabaseName() != null) {
                    this.fDevConnDisplayTable.setItems(new String[]{NLS.bind((String)ResourceHandler.ConnectionPage_Imported_database, (Object[])new Object[]{connectionData.getDatabaseName()})}, new Image[]{UIConstants.DATABASE_IMG});
                } else {
                    this.fDevConnDisplayTable.setItems(new String[]{ResourceHandler.ConnectionPage_Problems_encountered_while__14, ResourceHandler.ConnectionPage_establishing_the_development_15, ResourceHandler.ConnectionPage_time_connection__Configure__16}, new Image[]{UIConstants.ERROR_IMAGE});
                }
                this.fChangeDevtimeConnButton.setEnabled(true);
                this.fReconnectDevConnButton.setEnabled(false);
            } else if (connectionData.isConnection()) {
                IConnectionProfile connectionProfile = connectionData.getConnectionProfile();
                this.enableDevButtons(true);
                if (connectionProfile != null) {
                    this.fDevConnDisplayTable.setItems(new String[]{NLS.bind((String)ResourceHandler.ConnectionPage_dev_connection_name, (Object[])new Object[]{connectionProfile.getName()}), NLS.bind((String)ResourceHandler.ConnectionPage_dev_database_name, (Object[])new Object[]{RSCConnectionsHelper.getDatabaseName(connectionProfile)})}, new Image[]{UIConstants.CONNECTION_IMG, UIConstants.DATABASE_IMG});
                    this.fDevConnDisplayTable.refresh();
                } else {
                    this.fDevConnDisplayTable.setItems(new String[]{ResourceHandler.ConnectionPage_2}, new Image[]{UIConstants.ERROR_IMAGE});
                }
            }
        }
    }

    private void updateRuntimeConnTextArea() {
        if (this.fRuntimeConnDisplayTable == null) {
            return;
        }
        if (this.fConnectionControl.fConnIdCombo.getSelectionIndex() == -1) {
            this.fChangeRuntimeConnButton.setEnabled(false);
            this.fRuntimeConnDisplayTable.setItems(new String[]{ResourceHandler.ConnectionPage_create_new}, new Image[]{UIConstants.INFO_IMAGE});
        } else {
            IConnectionData connectionData = this.getConnectionData();
            if (RSCConnectionsHelper.getSQLVendorType(connectionData.getConnectionProfile()).getValue() == -1) {
                this.fChangeRuntimeConnButton.setEnabled(false);
                this.fRuntimeConnDisplayTable.setItems(new String[]{ResourceHandler.ConnectionPage_create_new}, new Image[]{UIConstants.INFO_IMAGE});
                return;
            }
            this.fChangeRuntimeConnButton.setEnabled(true);
            Vector<String> items = new Vector<String>();
            Vector<Image> images = new Vector<Image>();
            if (connectionData.isDriverManager()) {
                if (connectionData.getURL() != null) {
                    items.add(NLS.bind((String)ResourceHandler.ConnectionPage_Driver_url, (Object[])new Object[]{connectionData.getURL()}));
                    images.add(UIConstants.INFO_IMAGE);
                } else {
                    items.add(NLS.bind((String)ResourceHandler.ConnectionPage_Driver_url, (Object[])new Object[]{ResourceHandler.URL_can_not_be_null_16}));
                    images.add(UIConstants.ERROR_IMAGE);
                }
                if (connectionData.getDriver() != null) {
                    items.add(NLS.bind((String)ResourceHandler.ConnectionPage_Driver_name, (Object[])new Object[]{connectionData.getDriver()}));
                    images.add(UIConstants.INFO_IMAGE);
                } else {
                    items.add(NLS.bind((String)ResourceHandler.ConnectionPage_Driver_name, (Object[])new Object[]{ResourceHandler.Driver_name_can_not_be_null_17}));
                    images.add(UIConstants.ERROR_IMAGE);
                }
                if (connectionData.isAutoDeploy()) {
                    items.add(ResourceHandler.RuntimeConnectionPage_deploy_msg);
                    images.add(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OPEN_MARKER"));
                }
                if (connectionData.getClassLocation() != null) {
                    items.add(NLS.bind((String)ResourceHandler.ConnectionPage_Driver_class_location, (Object[])new Object[]{connectionData.getClassLocation()}));
                    images.add(UIConstants.INFO_IMAGE);
                } else {
                    items.add(NLS.bind((String)ResourceHandler.ConnectionPage_Driver_class_location, (Object[])new Object[]{ResourceHandler.RuntimeConnectionPage_Database_driver_not_be_null_12}));
                    images.add(UIConstants.ERROR_IMAGE);
                }
            } else if (connectionData.isDataSource()) {
                if (RSCConnectionsHelper.needsJ2CCJar(connectionData) && !RSCConnectionsHelper.hasJ2CCJar(connectionData)) {
                    items.add(ResourceHandler.ConnectionPage_db2jcc_error);
                    images.add(UIConstants.ERROR_IMAGE);
                }
                if (connectionData.getResourceRefName() != null) {
                    items.add(NLS.bind((String)ResourceHandler.ConnectionPage_Resource_Ref_name, (Object[])new Object[]{connectionData.getResourceRefName()}));
                    images.add(UIConstants.RESOURCE_REF_IMAGE);
                } else {
                    items.add(NLS.bind((String)ResourceHandler.ConnectionPage_Resource_Ref_name, (Object[])new Object[]{ResourceHandler.Data_Source_name_can_not_be_null_18}));
                    images.add(UIConstants.ERROR_IMAGE);
                }
                if (connectionData.isAutoDeploy()) {
                    items.add(ResourceHandler.RuntimeConnectionPage_deploy_msg);
                    images.add(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OPEN_MARKER"));
                    if (connectionData.getDataSourceClassName() != null) {
                        items.add(NLS.bind((String)ResourceHandler.ConnectionPage_Datasource_class_name, (Object[])new Object[]{connectionData.getDataSourceClassName()}));
                        images.add(UIConstants.INFO_IMAGE);
                    } else {
                        items.add(NLS.bind((String)ResourceHandler.ConnectionPage_Datasource_class_name, (Object[])new Object[]{ResourceHandler.RuntimeConnectionPage_Data_Source_not_be_null_13}));
                        images.add(UIConstants.ERROR_IMAGE);
                    }
                    if (connectionData.getDatabaseName() != null) {
                        items.add(NLS.bind((String)ResourceHandler.ConnectionPage_Database_name, (Object[])new Object[]{connectionData.getDatabaseName()}));
                        images.add(UIConstants.DATABASE_IMG);
                    } else {
                        items.add(NLS.bind((String)ResourceHandler.ConnectionPage_Database_name, (Object[])new Object[]{ResourceHandler.RuntimeConnectionPage_Database_name_not_be_null_14}));
                        images.add(UIConstants.ERROR_IMAGE);
                    }
                    if (connectionData.getClassLocation() != null) {
                        items.add(NLS.bind((String)ResourceHandler.ConnectionPage_Driver_class_location, (Object[])new Object[]{connectionData.getClassLocation()}));
                        images.add(UIConstants.INFO_IMAGE);
                    } else {
                        items.add(NLS.bind((String)ResourceHandler.ConnectionPage_Driver_class_location, (Object[])new Object[]{ResourceHandler.RuntimeConnectionPage_Database_driver_not_be_null_12}));
                        images.add(UIConstants.ERROR_IMAGE);
                    }
                }
            }
            this.fRuntimeConnDisplayTable.setItems(items.toArray(new String[items.size()]), images.toArray(new Image[images.size()]));
        }
    }
}

