/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.cea.version;

import com.ibm.etools.webtools.cea.internal.nls.Messages;
import org.eclipse.osgi.util.NLS;

public class CeaWidgetVersion {
    public static final short UNKNOWN = -1;
    private short major = (short)-1;
    private short minor = (short)-1;
    private short service = (short)-1;
    private String qualifier;
    private String buildID;
    private String raw;

    public CeaWidgetVersion() {
    }

    public CeaWidgetVersion(String fullString) {
        this.raw = fullString;
        this.parse(fullString);
        if (this.qualifier == null) {
            this.setQualifier(".0");
        }
        this.buildRaw();
    }

    public static void main(String[] args) {
    }

    private void buildRaw() {
        this.raw = NLS.bind((String)"{0}.{1}.{2}{3} ({4})", (Object[])new Object[]{Short.toString(this.major), Short.toString(this.minor), Short.toString(this.service), this.qualifier, this.buildID});
    }

    public int compareTo(CeaWidgetVersion v) {
        if (this.major > v.getMajor()) {
            return 1;
        }
        if (this.major < v.getMajor()) {
            return -1;
        }
        if (this.minor > v.getMinor()) {
            return 1;
        }
        if (this.minor < v.getMinor()) {
            return -1;
        }
        if (this.service == -1 || v.getService() == -1 || this.service == v.getService()) {
            if (this.buildID != null && v.getBuildID() != null) {
                return this.buildID.compareTo(v.getBuildID());
            }
            return 0;
        }
        if (this.service > v.getService()) {
            return 1;
        }
        if (this.service < v.getService()) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this.raw == null) {
            this.buildRaw();
        }
        return this.raw.equals(o);
    }

    public String getBuildID() {
        return this.buildID;
    }

    public short getMajor() {
        return this.major;
    }

    public short getMinor() {
        return this.minor;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public short getService() {
        return this.service;
    }

    private void parse(String s) throws IllegalArgumentException {
        int idx2;
        if (s == null || s.equals("")) {
            throw new IllegalArgumentException(Messages.CeaWidgetVersion_wrongformat);
        }
        int idx1 = (s = s.trim()).indexOf("(");
        if (idx1 > (idx2 = s.indexOf(")"))) {
            throw new IllegalArgumentException(Messages.CeaWidgetVersion_wrongformat);
        }
        if (idx1 * idx2 < 0) {
            throw new IllegalArgumentException(Messages.CeaWidgetVersion_wrongformat);
        }
        if (idx1 > 0 && idx2 > 0) {
            this.buildID = s.substring(idx1 + 1, idx2);
        }
        String a = null;
        a = idx1 > 0 ? s.substring(0, idx1) : s;
        idx1 = (a = a.trim()).indexOf(".");
        if (idx1 < 0) {
            throw new IllegalArgumentException(Messages.CeaWidgetVersion_NoMajorVersion);
        }
        this.major = Short.parseShort(a.substring(0, idx1));
        if ((idx1 = (a = a.substring(idx1 + 1)).indexOf(".")) < 0) {
            char[] segment = a.toCharArray();
            StringBuffer serviceString = new StringBuffer();
            idx1 = 0;
            char[] cArray = segment;
            int n = segment.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (!Character.isDigit(c)) break;
                serviceString.append(c);
                ++idx1;
                ++n2;
            }
            this.minor = Short.parseShort(serviceString.toString());
            if (a.length() > idx1) {
                this.qualifier = a.substring(idx1);
            }
            return;
        }
        this.minor = Short.parseShort(a.substring(0, idx1));
        if (idx1 > 0) {
            a = a.substring(idx1 + 1);
            char[] segment = a.toCharArray();
            StringBuffer serviceString = new StringBuffer();
            idx1 = 0;
            char[] cArray = segment;
            int n = segment.length;
            int n3 = 0;
            while (n3 < n) {
                char c = cArray[n3];
                if (!Character.isDigit(c)) break;
                serviceString.append(c);
                ++idx1;
                ++n3;
            }
            this.service = Short.parseShort(serviceString.toString());
            if (a.length() > idx1) {
                this.qualifier = a.substring(idx1);
            }
        }
    }

    public void setBuildID(String buildID) {
        this.buildID = buildID;
    }

    public void setMajor(short major) {
        this.major = major;
    }

    public void setMinor(short minor) {
        this.minor = minor;
    }

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    public void setService(short service) {
        this.service = service;
    }

    public String toString() {
        if (this.raw == null) {
            this.buildRaw();
        }
        return this.raw;
    }
}

