/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.cea.settings;

import com.ibm.etools.webtools.cea.internal.CeaWidgetInspector;
import com.ibm.etools.webtools.cea.internal.nls.Messages;
import com.ibm.etools.webtools.cea.version.CeaWidgetVersion;
import java.net.MalformedURLException;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class CeaWidgetSettings {
    public static String getCeaWidgetCSS(IProject project) throws CoreException {
        return CeaWidgetSettings.getProjectCeaWidgetSetting(project, "cea-css");
    }

    public static String getCeaWidgetDijitCSS(IProject project) throws CoreException {
        return CeaWidgetSettings.getProjectCeaWidgetSetting(project, "cea-dijit-css");
    }

    public static String getCeaWidgetLoaderJS(IProject project) throws CoreException {
        return CeaWidgetSettings.getProjectCeaWidgetSetting(project, "cea-bootstrap-js");
    }

    public static IPath getCeaWidgetRoot(IProject project) throws CoreException, MalformedURLException {
        String s = CeaWidgetSettings.getProjectCeaWidgetSetting(project, "cea-root");
        return new Path(s);
    }

    public static String getCeaWidgetThemeCSS(IProject project) throws CoreException {
        return CeaWidgetSettings.getProjectCeaWidgetSetting(project, "cea-theme-css");
    }

    public static CeaWidgetVersion getCeaWidgetVersion(IProject project) throws CoreException, MalformedURLException {
        return CeaWidgetInspector.getCeaWidgetVersion(project);
    }

    private static String getProjectCeaWidgetSetting(IProject project, String name) throws CoreException {
        IFacetedProject fp = ProjectFacetsManager.create((IProject)project);
        if (fp == null) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.etools.webtools.cea", NLS.bind((String)Messages.CeaWidgetSettings_Error_FacetNotInstalled, (Object)project.getName())));
        }
        Set facets = fp.getProjectFacets();
        boolean found = false;
        for (IProjectFacetVersion facet : facets) {
            if (!facet.getProjectFacet().getId().equals("rad.cea.widgets")) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.etools.webtools.cea", NLS.bind((String)Messages.CeaWidgetSettings_Error_FacetNotInstalled, (Object)project.getName())));
        }
        ProjectScope context = new ProjectScope(project);
        IEclipsePreferences pref = context.getNode("com.ibm.etools.webtools.cea");
        return pref.get(name, null);
    }
}

