/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.cea.internal.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

public class ZipImportUtil {
    private static IContainer generateContainer(IPath path, IProgressMonitor monitor) throws CoreException {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IContainer container = (IContainer)workspaceRoot.findMember(path);
        if (container != null) {
            return container;
        }
        container = workspaceRoot;
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)"", (int)path.segmentCount());
        int i = 0;
        while (i < path.segmentCount()) {
            SubMonitor child = sub.newChild(1);
            String currentSegment = path.segment(i);
            IResource resource = container.findMember(currentSegment);
            if (resource == null) {
                IFolder folderHandle = container.getFolder((IPath)new Path(currentSegment));
                folderHandle.create(false, true, (IProgressMonitor)child);
                container = folderHandle;
            } else {
                container = (IContainer)resource;
            }
            ++i;
        }
        return container;
    }

    public static void importZip(URL sourceZipUrl, IPath unzipLocation, String zipPrefix, IProgressMonitor monitor) throws IOException, CoreException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IContainer destinationContainer = ZipImportUtil.generateContainer(unzipLocation, (IProgressMonitor)sub.newChild(10));
        ZipInputStream input = new ZipInputStream(sourceZipUrl.openStream());
        ZipEntry entry = input.getNextEntry();
        byte[] buf = new byte[8024];
        sub.newChild(90);
        while (entry != null) {
            String entryName = entry.getName();
            if (zipPrefix != null && entryName.startsWith(zipPrefix)) {
                entryName = entryName.substring(zipPrefix.length());
            }
            if (entry.isDirectory()) {
                IFolder ifolder = destinationContainer.getFolder((IPath)new Path(entryName));
                if (!ifolder.exists()) {
                    ifolder.create(false, true, null);
                }
            } else {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                int n = 0;
                while ((n = input.read(buf, 0, 1024)) > -1) {
                    out.write(buf, 0, n);
                }
                out.flush();
                out.close();
                IFile file = destinationContainer.getFile((IPath)new Path(entryName));
                ByteArrayInputStream contentStream = new ByteArrayInputStream(out.toByteArray());
                if (file.exists()) {
                    file.setContents((InputStream)contentStream, 2, null);
                } else {
                    file.create((InputStream)contentStream, false, null);
                }
                ((InputStream)contentStream).close();
            }
            entry = input.getNextEntry();
        }
        sub.done();
    }
}

