/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.cea.internal.util;

import com.ibm.etools.webtools.cea.internal.nls.Messages;
import com.ibm.etools.webtools.cea.internal.util.CeaWidgetInstallUtil;
import com.ibm.etools.webtools.cea.settings.CeaWidgetSettings;
import java.net.MalformedURLException;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.validation.Validator;
import org.eclipse.wst.validation.internal.ValManager;
import org.eclipse.wst.validation.internal.ValPrefManagerProject;
import org.eclipse.wst.validation.internal.model.FilterGroup;
import org.eclipse.wst.validation.internal.model.FilterRule;
import org.eclipse.wst.validation.internal.model.ProjectPreferences;

public class CeaWidgetUninstallUtil {
    public static void removeDojoJSContainer(IProject project, IProgressMonitor monitor) throws CoreException {
        JavaProject jsProject = (JavaProject)JavaScriptCore.create((IProject)project);
        jsProject.setProject(project);
        IIncludePathEntry[] rawClasspath = null;
        try {
            rawClasspath = jsProject.getRawIncludepath();
        }
        catch (JavaScriptModelException e) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.etools.webtools.cea", NLS.bind((String)Messages.CeaWidgetFacetUninstallDelegate_js_include_get, (Object)((Object)e))));
        }
        int index = 0;
        boolean found = false;
        IIncludePathEntry[] iIncludePathEntryArray = rawClasspath;
        int n = rawClasspath.length;
        int n2 = 0;
        while (n2 < n) {
            IIncludePathEntry entry = iIncludePathEntryArray[n2];
            if (entry.getPath().segment(0).equals("com.ibm.etools.webtools.cea.jscontainer")) {
                found = true;
                break;
            }
            ++index;
            ++n2;
        }
        if (found) {
            IIncludePathEntry[] newClasspath = new IIncludePathEntry[rawClasspath.length - 1];
            if (index > 1) {
                System.arraycopy(rawClasspath, 0, newClasspath, 0, index);
            }
            if (index < rawClasspath.length - 1) {
                System.arraycopy(rawClasspath, index + 1, newClasspath, index, rawClasspath.length - index - 1);
            }
            try {
                jsProject.setRawIncludepath(newClasspath, monitor);
            }
            catch (JavaScriptModelException e) {
                throw new CoreException((IStatus)new Status(4, "com.ibm.etools.webtools.cea", NLS.bind((String)Messages.CeaWidgetFacetUninstallDelegate_js_include_set, (Object)((Object)e))));
            }
        }
    }

    public static void removeHTMLValidationExcludeRules(IProject project) throws CoreException {
        IPath root = null;
        try {
            root = CeaWidgetSettings.getCeaWidgetRoot(project);
        }
        catch (MalformedURLException malformedURLException) {
            return;
        }
        if (root instanceof IPath) {
            IPath rootpath = root.removeFirstSegments(project.getFullPath().segmentCount());
            Validator[] validators = ValManager.getDefault().getValidators(project);
            Validator[] _validators = new Validator[validators.length];
            int i = 0;
            while (i < validators.length) {
                _validators[i] = validators[i].copy();
                ++i;
            }
            Validator html = null;
            Validator[] validatorArray = _validators;
            int n = _validators.length;
            int n2 = 0;
            while (n2 < n) {
                Validator val = validatorArray[n2];
                if (CeaWidgetInstallUtil.HTML_VALIDATOR.equals(val.getId())) {
                    html = val;
                }
                ++n2;
            }
            if (html != null) {
                Validator.V2 _v2 = html.asV2Validator();
                FilterGroup[] groups = _v2.getGroups();
                FilterGroup exclude = null;
                FilterGroup[] filterGroupArray = groups;
                int n3 = groups.length;
                int n4 = 0;
                while (n4 < n3) {
                    FilterGroup g = filterGroupArray[n4];
                    if (g.isExclude()) {
                        exclude = g;
                    }
                    ++n4;
                }
                if (exclude == null) {
                    return;
                }
                FilterRule[] rules = exclude.getRules();
                if (rules != null && rules.length > 0) {
                    ArrayList<FilterRule> newrules = new ArrayList<FilterRule>();
                    FilterRule[] filterRuleArray = rules;
                    int n5 = rules.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        FilterRule rule = filterRuleArray[n6];
                        if (rule instanceof FilterRule.File) {
                            Path path = new Path(rule.getPattern());
                            if (path.matchingFirstSegments(rootpath) != rootpath.segmentCount()) {
                                newrules.add(rule);
                            }
                        } else {
                            newrules.add(rule);
                        }
                        ++n6;
                    }
                    _v2.replaceFilterGroup(exclude, FilterGroup.create((boolean)true, (FilterRule[])newrules.toArray(new FilterRule[newrules.size()])));
                    ProjectPreferences oldpp = ValManager.getDefault().getProjectPreferences(project);
                    ProjectPreferences newpp = new ProjectPreferences(project, oldpp.getOverride(), oldpp.getSuspend(), _validators);
                    ValPrefManagerProject vpm = new ValPrefManagerProject(project);
                    vpm.savePreferences(newpp);
                }
            }
        }
    }
}

