/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.cea.internal.util;

import com.ibm.etools.webtools.cea.internal.CeaWidgetPlugin;
import com.ibm.etools.webtools.cea.internal.nls.Messages;
import com.ibm.etools.webtools.cea.internal.settings.CeaWidgetSettingsWriter;
import com.ibm.etools.webtools.cea.internal.util.ZipImportUtil;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.core.ClasspathEntry;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.util.Util;
import org.eclipse.wst.jsdt.web.core.internal.project.JsWebNature;
import org.eclipse.wst.validation.Validator;
import org.eclipse.wst.validation.internal.ValManager;
import org.eclipse.wst.validation.internal.ValPrefManagerProject;
import org.eclipse.wst.validation.internal.model.FilterGroup;
import org.eclipse.wst.validation.internal.model.FilterRule;
import org.eclipse.wst.validation.internal.model.GlobalPreferencesValues;
import org.eclipse.wst.validation.internal.model.ProjectPreferences;
import org.osgi.framework.Bundle;

public class CeaWidgetInstallUtil {
    private static final String CEA_ZIP_PREFIX_DIRECTORY = "ceadojo/";
    public static String HTML_VALIDATOR = "org.eclipse.wst.html.ui.HTMLValidator";

    public static void configureHTMLValidationExcludeRules(IProject project, IDataModel model) {
        String root = CeaWidgetSettingsWriter.calculateDojoRoot(project, model);
        Path dojoroot = new Path(root);
        final ArrayList excludeFolders = new ArrayList();
        if (dojoroot.matchingFirstSegments(project.getFullPath()) != project.getFullPath().segmentCount()) {
            return;
        }
        IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)dojoroot);
        try {
            folder.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource instanceof IFile && CeaWidgetInstallUtil.isHTMLFile((IFile)resource)) {
                        IPath p = resource.getParent().getProjectRelativePath();
                        boolean exists = false;
                        for (IPath _p : excludeFolders) {
                            if (!_p.equals((Object)p)) continue;
                            exists = true;
                            break;
                        }
                        if (!exists) {
                            excludeFolders.add(p);
                        }
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        Validator[] validators = ValManager.getDefault().getValidators(project);
        Validator[] _validators = new Validator[validators.length];
        int i = 0;
        while (i < validators.length) {
            _validators[i] = validators[i].copy();
            ++i;
        }
        Validator html = null;
        Validator[] validatorArray = _validators;
        int n = _validators.length;
        int n2 = 0;
        while (n2 < n) {
            Validator val = validatorArray[n2];
            if (HTML_VALIDATOR.equals(val.getId())) {
                html = val;
            }
            ++n2;
        }
        if (html != null) {
            Validator.V2 _v2 = html.asV2Validator();
            FilterGroup[] groups = _v2.getGroups();
            FilterGroup exclude = null;
            FilterGroup[] filterGroupArray = groups;
            int n3 = groups.length;
            int n4 = 0;
            while (n4 < n3) {
                FilterGroup g = filterGroupArray[n4];
                if (g.isExclude()) {
                    exclude = g;
                }
                ++n4;
            }
            FilterRule[] rules = new FilterRule[excludeFolders.size()];
            int i2 = 0;
            for (IPath excludePath : excludeFolders) {
                rules[i2++] = FilterRule.createFile((String)excludePath.toString(), (boolean)false, (int)2);
            }
            if (exclude == null) {
                exclude = FilterGroup.create((boolean)true, (FilterRule[])rules);
                _v2.add(exclude);
            } else {
                FilterRule[] existing = exclude.getRules();
                if (existing != null && existing.length > 0) {
                    FilterRule[] newRules = new FilterRule[existing.length + rules.length];
                    System.arraycopy(existing, 0, newRules, 0, existing.length);
                    System.arraycopy(rules, 0, newRules, existing.length, rules.length);
                    FilterGroup newExclude = FilterGroup.create((boolean)true, (FilterRule[])newRules);
                    _v2.replaceFilterGroup(exclude, newExclude);
                }
            }
            GlobalPreferencesValues gp = ValManager.getDefault().getGlobalPreferences().asValues();
            gp.override = true;
            ValManager vm = ValManager.getDefault();
            vm.replace(gp);
            ProjectPreferences oldpp = ValManager.getDefault().getProjectPreferences(project);
            ProjectPreferences newpp = new ProjectPreferences(project, true, oldpp.getSuspend(), _validators);
            ValPrefManagerProject vpm = new ValPrefManagerProject(project);
            vpm.savePreferences(newpp);
        }
    }

    private static void configureJSNatureIfNecessary(IProject project) throws CoreException {
        if (!JsWebNature.hasNature((IProject)project)) {
            JsWebNature nature = new JsWebNature(project, null);
            nature.configure();
        }
    }

    private static IPath createSourcePathFromVersion(String version) {
        return new Path("resources/" + version + "/ceadojo.zip");
    }

    public static void importResourcesIfNecessary(IProject project, IDataModel model, String version, IProgressMonitor monitor) {
        IPath sourceZipPath = CeaWidgetInstallUtil.createSourcePathFromVersion(version);
        URL sourceZipUrl = FileLocator.find((Bundle)Platform.getBundle((String)"com.ibm.etools.webtools.cea"), (IPath)sourceZipPath, null);
        IStatus status = Status.OK_STATUS;
        try {
            IPath targetPath = project.getFullPath().append((IPath)model.getProperty("ICeaFacetInstallDataModelProperties.target"));
            ZipImportUtil.importZip(sourceZipUrl, targetPath, CEA_ZIP_PREFIX_DIRECTORY, monitor);
        }
        catch (IOException e) {
            status = new Status(4, "com.ibm.etools.webtools.cea", NLS.bind((String)Messages.CeaWidgetFacetInstallDelegate_ErrorImporting, (Object)sourceZipUrl.getPath()), (Throwable)e);
        }
        catch (CoreException e) {
            status = new Status(4, "com.ibm.etools.webtools.cea", NLS.bind((String)Messages.CeaWidgetFacetInstallDelegate_ErrorImporting, (Object)sourceZipUrl.getPath()), (Throwable)e);
        }
        if (!status.isOK()) {
            CeaWidgetPlugin.getDefault().getLog().log(status);
        }
    }

    public static void initializeJSIncludPathContainer(IProject project, IDataModel model, IProgressMonitor monitor) throws CoreException {
        String dojoroot = CeaWidgetSettingsWriter.calculateDojoRoot(project, model);
        CeaWidgetInstallUtil.configureJSNatureIfNecessary(project);
        JavaProject jsProject = (JavaProject)JavaScriptCore.create((IProject)project);
        jsProject.setProject(project);
        IIncludePathEntry[] rawClasspath = null;
        try {
            rawClasspath = jsProject.getRawIncludepath();
        }
        catch (JavaScriptModelException e) {
            e.printStackTrace();
        }
        int i = 0;
        while (i < rawClasspath.length) {
            Path dojoPath;
            IPath path;
            int kind = rawClasspath[i].getEntryKind();
            if (!(kind != 3 && kind != 5 || !(path = rawClasspath[i].getPath()).isPrefixOf((IPath)(dojoPath = new Path(dojoroot))) || path.equals((Object)dojoPath) || Util.isExcluded((IPath)dojoPath.append("*"), (char[][])((ClasspathEntry)rawClasspath[i]).fullInclusionPatternChars(), (char[][])((ClasspathEntry)rawClasspath[i]).fullExclusionPatternChars(), (boolean)false))) {
                String exclusionPattern = dojoPath.removeFirstSegments(path.segmentCount()).segment(0);
                if (!exclusionPattern.endsWith("/")) {
                    exclusionPattern = String.valueOf(exclusionPattern) + "/";
                }
                IPath[] existingExcusionPatterns = rawClasspath[i].getExclusionPatterns();
                IPath[] newExcusionPatterns = new IPath[existingExcusionPatterns.length + 1];
                System.arraycopy(existingExcusionPatterns, 0, newExcusionPatterns, 0, existingExcusionPatterns.length);
                newExcusionPatterns[existingExcusionPatterns.length] = new Path(exclusionPattern);
                ClasspathEntry newSourceEntry = new ClasspathEntry(rawClasspath[i].getContentKind(), kind, path, rawClasspath[i].getInclusionPatterns(), newExcusionPatterns, rawClasspath[i].getSourceAttachmentPath(), rawClasspath[i].getSourceAttachmentRootPath(), rawClasspath[i].getOutputLocation(), rawClasspath[i].isExported(), rawClasspath[i].getAccessRules(), rawClasspath[i].combineAccessRules(), rawClasspath[i].getExtraAttributes());
                rawClasspath[i] = newSourceEntry;
            }
            ++i;
        }
        Path containerPath = new Path("com.ibm.etools.webtools.cea.jscontainer");
        IIncludePathEntry atfContainerEntry = JavaScriptCore.newContainerEntry((IPath)containerPath);
        IIncludePathEntry[] newClasspath = new IIncludePathEntry[rawClasspath.length + 1];
        System.arraycopy(rawClasspath, 0, newClasspath, 0, rawClasspath.length);
        newClasspath[rawClasspath.length] = atfContainerEntry;
        try {
            jsProject.setRawIncludepath(newClasspath, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (JavaScriptModelException e) {
            e.printStackTrace();
            return;
        }
    }

    private static boolean isHTMLFile(IFile file) {
        String name = file.getFileExtension();
        return name != null && (name.equalsIgnoreCase("html") || name.equalsIgnoreCase("htm"));
    }
}

