/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.cea.internal.settings;

import com.ibm.etools.webtools.cea.ICeaWidgetConstants;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class CeaWidgetSettingsWriter
implements ICeaWidgetConstants {
    public static String calculateDojoRoot(IProject project, IDataModel model) {
        IPath dojoroot = (IPath)model.getProperty("ICeaFacetInstallDataModelProperties.target");
        dojoroot = project.getFolder(dojoroot).getFullPath();
        return dojoroot.toString();
    }

    public static void clearDojoSettings(IProject project) throws CoreException {
        ProjectScope context = new ProjectScope(project);
        IEclipsePreferences pref = context.getNode("com.ibm.etools.webtools.cea");
        try {
            Preferences parent = pref.parent();
            pref.removeNode();
            parent.flush();
        }
        catch (BackingStoreException e) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.etools.webtools.cea", e.getMessage(), (Throwable)e));
        }
    }

    public static void persistDojoSettings(IProject project, IDataModel model) throws CoreException {
        String dojoroot = CeaWidgetSettingsWriter.calculateDojoRoot(project, model);
        Properties props = new Properties();
        props.put("cea-root", dojoroot);
        props.put("cea-bootstrap-js", model.getStringProperty("ICeaFacetInstallDataModelProperties.loader.js"));
        props.put("cea-css", model.getStringProperty("ICeaFacetInstallDataModelProperties.dojo.css"));
        props.put("cea-dijit-css", model.getStringProperty("ICeaFacetInstallDataModelProperties.dijit.css"));
        props.put("cea-theme-css", model.getStringProperty("ICeaFacetInstallDataModelProperties.theme.css"));
        CeaWidgetSettingsWriter.persistDojoSettings(project, props);
    }

    public static void persistDojoSettings(IProject project, Properties properties) throws CoreException {
        ProjectScope context = new ProjectScope(project);
        IEclipsePreferences pref = context.getNode("com.ibm.etools.webtools.cea");
        pref.put("cea-root", properties.getProperty("cea-root"));
        pref.put("cea-bootstrap-js", properties.getProperty("cea-bootstrap-js"));
        pref.put("cea-css", properties.getProperty("cea-css"));
        pref.put("cea-dijit-css", properties.getProperty("cea-dijit-css"));
        pref.put("cea-theme-css", properties.getProperty("cea-theme-css"));
        try {
            pref.flush();
        }
        catch (BackingStoreException e) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.etools.webtools.cea", e.getMessage(), (Throwable)e));
        }
    }

    public static void persistDojoSettings(IProject project, String property, String value) throws CoreException {
        ProjectScope context = new ProjectScope(project);
        IEclipsePreferences pref = context.getNode("com.ibm.etools.webtools.cea");
        pref.put(property, value);
        try {
            pref.flush();
        }
        catch (BackingStoreException e) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.etools.webtools.cea", e.getMessage(), (Throwable)e));
        }
    }
}

