/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.cea.internal.facet.datamodel;

import com.ibm.etools.webtools.cea.internal.ICeaWidgetBuildConstants;
import com.ibm.etools.webtools.cea.internal.facet.datamodel.ICeaWidgetFacetInstallDataModelProperties;
import java.io.File;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.datamodel.FacetInstallDataModelProvider;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class CeaWidgetFacetInstallDataModelProvider
extends FacetInstallDataModelProvider
implements ICeaWidgetFacetInstallDataModelProperties {
    private static final String DEFAULT_CEA_FOLDER = "ceadojo";

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("IFacetDataModelProperties.FACET_ID")) {
            return "rad.cea.widgets";
        }
        if (propertyName.equals("ICeaFacetInstallDataModelProperties.target")) {
            IPath webContentFolder = this.getWebContentFolder();
            if (webContentFolder != null) {
                return webContentFolder.append(DEFAULT_CEA_FOLDER);
            }
        } else if (propertyName.equals("ICeaFacetInstallDataModelProperties.source")) {
            IProject project = this.getProject();
            if (project != null) {
                IPath projectPath = project.getFullPath();
                return projectPath.append(this.getWebContentFolder().append(DEFAULT_CEA_FOLDER));
            }
        } else {
            if (propertyName.equals("ICeaFacetInstallDataModelProperties.loader.js")) {
                return this.searchForDefault(propertyName, ICeaWidgetBuildConstants.DEFAULT_CEA_WIDGET_LOADER_JS);
            }
            if (propertyName.equals("ICeaFacetInstallDataModelProperties.dojo.css")) {
                return this.searchForDefault(propertyName, ICeaWidgetBuildConstants.DEFAULT_CEA_WIDGET_CSS);
            }
            if (propertyName.equals("ICeaFacetInstallDataModelProperties.dijit.css")) {
                return this.searchForDefault(propertyName, ICeaWidgetBuildConstants.DEFAULT_CEA_WIDGET_DIJIT_CSS);
            }
            if (propertyName.equals("ICeaFacetInstallDataModelProperties.theme.css")) {
                return ICeaWidgetBuildConstants.DEFAULT_CEA_WIDGET_THEMES_CSS[0];
            }
        }
        return super.getDefaultProperty(propertyName);
    }

    private IProject getProject() {
        String projectName = this.model.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
        if (projectName == null || projectName.equals("")) {
            return null;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        return project;
    }

    public Set getPropertyNames() {
        Set names = super.getPropertyNames();
        names.add("ICeaFacetInstallDataModelProperties.source");
        names.add("ICeaFacetInstallDataModelProperties.target");
        names.add("ICeaFacetInstallDataModelProperties.loader.js");
        names.add("ICeaFacetInstallDataModelProperties.dojo.css");
        names.add("ICeaFacetInstallDataModelProperties.dijit.css");
        names.add("ICeaFacetInstallDataModelProperties.theme.css");
        return names;
    }

    private IPath getWebContentFolder() {
        IPath webContentFolder;
        IProject project = this.getProject();
        if (project != null && project.exists()) {
            webContentFolder = ComponentCore.createComponent((IProject)project).getRootFolder().getUnderlyingFolder().getProjectRelativePath();
        } else {
            IDataModel projModel = (IDataModel)this.getProperty("FacetInstallDataModelProvider.MASTER_PROJECT_DM");
            IFacetProjectCreationDataModelProperties.FacetDataModelMap dmMap = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)projModel.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
            String webContentFolderName = new String("WebContent");
            IDataModel webFacet = dmMap.getFacetDataModel("jst.web");
            if (webFacet == null) {
                webFacet = dmMap.getFacetDataModel("wst.web");
                webContentFolderName = webFacet.getStringProperty("IStaticWebFacetInstallDataModelProperties.CONTENT_DIR");
            } else {
                webContentFolderName = webFacet.getStringProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER");
            }
            webContentFolder = new Path(webContentFolderName);
        }
        return webContentFolder;
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        if (propertyName.equals("ICeaFacetInstallDataModelProperties.source")) {
            this.model.notifyPropertyChange("ICeaFacetInstallDataModelProperties.target", 3);
        }
        return super.propertySet(propertyName, propertyValue);
    }

    private File search(File root, IPath searchPath) {
        File found = null;
        int count = searchPath.segmentCount();
        if (count > 0) {
            boolean valid = true;
            int i = 0;
            while (i < count && valid) {
                found = null;
                File[] members = root.listFiles();
                if (members != null && members.length > 0) {
                    File[] fileArray = members;
                    int n = members.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File m = fileArray[n2];
                        if (m.getName().equals(searchPath.segment(i))) {
                            found = m;
                            break;
                        }
                        ++n2;
                    }
                    if (found == null) {
                        valid = false;
                    } else {
                        root = found;
                    }
                }
                ++i;
            }
            if (!valid) {
                found = null;
            }
        }
        return found;
    }

    private String searchForDefault(String propertyName, String[] values) {
        block5: {
            IPath source;
            block6: {
                source = (IPath)this.model.getProperty("ICeaFacetInstallDataModelProperties.source");
                if (source == null || source.equals((Object)"")) break block5;
                if (!ResourcesPlugin.getWorkspace().getRoot().exists(source)) break block6;
                IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(source);
                if (!(resource instanceof IFolder)) break block5;
                IFolder folder = (IFolder)resource;
                String[] stringArray = values;
                int n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    if (folder.exists((IPath)new Path(value))) {
                        return value;
                    }
                    ++n2;
                }
                break block5;
            }
            File file = source.toFile();
            if (file.exists()) {
                String[] stringArray = values;
                int n = values.length;
                int n3 = 0;
                while (n3 < n) {
                    String value = stringArray[n3];
                    File found = this.search(file, (IPath)new Path(value));
                    if (found != null) {
                        return value;
                    }
                    ++n3;
                }
            }
        }
        return "";
    }
}

