/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.cea.internal.facet;

import com.ibm.etools.webtools.cea.internal.facet.CeaWidgetsFacetInstallDelegate;
import com.ibm.etools.webtools.cea.internal.facet.CeaWidgetsFacetUninstallDelegate;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class CeaWidgetsFacetVersionChangeDelegate
implements IDelegate {
    private static final String CEA_WIDGETS_FACET_ID = "rad.cea.widgets";

    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        IProjectFacetVersion oldVersion = this.getInstalledFacetVersion(project, CEA_WIDGETS_FACET_ID);
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        CeaWidgetsFacetUninstallDelegate uninstall = new CeaWidgetsFacetUninstallDelegate();
        uninstall.execute(project, oldVersion, config, (IProgressMonitor)sub.newChild(1));
        CeaWidgetsFacetInstallDelegate install = new CeaWidgetsFacetInstallDelegate();
        install.execute(project, fv, config, (IProgressMonitor)sub.newChild(1));
    }

    private IFacetedProject getFacetedProject(IProject project) {
        try {
            return ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    private IProjectFacetVersion getInstalledFacetVersion(IProject project, String facetId) {
        IFacetedProject facetedProject = this.getFacetedProject(project);
        if (facetedProject != null) {
            return this.getInstalledFacetVersion(facetedProject, facetId);
        }
        return null;
    }

    private IProjectFacetVersion getInstalledFacetVersion(IFacetedProject facetedProject, String facetId) {
        IProjectFacet projectFacet = this.getProjectFacet(facetId);
        if (projectFacet != null) {
            return facetedProject.getInstalledVersion(projectFacet);
        }
        return null;
    }

    private IProjectFacet getProjectFacet(String facetId) {
        try {
            return ProjectFacetsManager.getProjectFacet((String)facetId);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }
}

