/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.cea.library.internal.palette;

import com.ibm.etools.palette.model.PaletteCategoryDataImpl;
import com.ibm.etools.palette.model.PaletteData;
import com.ibm.etools.palette.model.PaletteItemData;
import com.ibm.etools.webedit.palette.PaletteProvider;
import com.ibm.etools.webtools.cea.library.internal.palette.AJAXLibraryManager;
import com.ibm.etools.webtools.cea.library.internal.palette.AJAXLibraryManagerHelper;
import com.ibm.etools.webtools.cea.library.internal.palette.PaletteItemDataComparator;
import com.ibm.etools.webtools.cea.library.internal.palette.dojo.DOJOLibraryManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class AJAXLibraryPaletteProvider
implements PaletteProvider {
    private static DOJOLibraryManager dojoLibraryManager = new DOJOLibraryManager();

    public AJAXLibraryPaletteProvider() {
        AJAXLibraryManagerHelper.getInstance().resetPaletteItemsMap();
        AJAXLibraryManagerHelper.getInstance().registerLibraryManager(dojoLibraryManager);
    }

    public static void sortPaletteDataList(List<PaletteItemData> paletteDataList) {
        Collections.sort(paletteDataList, new PaletteItemDataComparator());
    }

    public PaletteData[] providePaletteItems() {
        ArrayList<PaletteData> listOfPaletteItems = new ArrayList<PaletteData>();
        Set<AJAXLibraryManager> libraryManagers = AJAXLibraryManagerHelper.getInstance().getLibraryManagers();
        for (AJAXLibraryManager libraryMgr : libraryManagers) {
            List<PaletteData> list = AJAXLibraryManagerHelper.getInstance().buildLibraryPalette(libraryMgr);
            ListIterator<PaletteData> paletteDataIterator = list.listIterator();
            while (paletteDataIterator.hasNext()) {
                PaletteData categoryElement = paletteDataIterator.next();
                if (!(categoryElement instanceof PaletteCategoryDataImpl)) continue;
                List elementList = ((PaletteCategoryDataImpl)categoryElement).getChildren();
                AJAXLibraryPaletteProvider.sortPaletteDataList(elementList);
            }
            listOfPaletteItems.addAll(list);
        }
        return listOfPaletteItems.toArray(new PaletteData[0]);
    }
}

